/**
 * @file
 *
 * @brief Build system configuration
 *
 * @copyright BSD License (see doc/COPYING or http://www.libelektra.org)
 */


/***************************************************************************
 *                                                                         *
 * This header file is AUTO GENERATED.                                     *
 * Do not edit this file, otherwise your changes will be discarded in the  *
 * next cmake run.                                                         *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the BSD License (revised).                      *
 *                                                                         *
 ***************************************************************************/

#ifndef KDBCONFIG_H
#define KDBCONFIG_H

/**Below this directory the system configuration (system/) will be searched.*/
#define KDB_DB_SYSTEM            "/etc/kdb"

/** Depending on the resolver this might be the
  * postfix to search for user configuration. */
#define KDB_DB_USER              ".config"

/** Prefix to search specification configuration (spec/). */
#define KDB_DB_SPEC              "/usr/share/elektra/specification"

/** The folder to add for directory namespace */
#define KDB_DB_DIR               ".dir"

/** Depending on the resolver this might be the root 
  * to search for user configuration. */
#define KDB_DB_HOME              "/home"

#define KDB_DB_FILE              "default.ecf"

#define KDB_DEFAULT_STORAGE      "dump"

#define KDB_DEFAULT_RESOLVER     "resolver"

#define ELEKTRA_PLUGINS          "dump;resolver;sync;error;template;doc;ccode;fstab;csvstorage;lineendings;hexcode;hidden;ni;null;struct;tracer;counter;type;constants;noresolver;wresolver;ini;list;logchange;glob;hosts;iconv;network;path;enum;mathcheck;conditionals;keytometa;rename;syslog;uname;timeofday;simpleini;line;validation;regexstore;filecheck;resolver_fm_b_b;resolver_fm_hb_b;resolver_fm_hp_b;resolver_fm_ub_x;resolver_fm_xb_x;resolver_fm_xp_x;resolver_fm_xhp_x;resolver_fm_uhb_xb;yajl;dbus;tcl;xmltool;augeas;journald;jni;python;python2;lua;crypto"

#define ELEKTRA_TOOLS            "kdb;gen;race;qt-gui"

/** Declares a parameter as unused. */
#define ELEKTRA_UNUSED           __attribute__ ((unused))

/** Declares an API as deprecated. */
#define ELEKTRA_DEPRECATED       __attribute__ ((deprecated))

#define BUILTIN_EXEC_FOLDER      "/usr/lib/elektra/tool_exec"

#define BUILTIN_DATA_FOLDER      "/usr/share/elektra/test_data"

#define SIZEOF_INT               4
#define SIZEOF_LONG              8
#define SIZEOF_MODE_T            4

#define HAVE_SIZEOF_LONG_LONG
#ifdef HAVE_SIZEOF_LONG_LONG
# define SIZEOF_LONG_LONG         8
#endif

#define HAVE_SIZEOF_LONG_DOUBLE
#ifdef HAVE_SIZEOF_LONG_DOUBLE
# define SIZEOF_LONG_DOUBLE       16
#endif

/* disable debug output messages */
#define DEBUG 0

#ifndef DEBUG
# define NDEBUG
#endif

/* disable verbose output messages */
#define VERBOSE 0

/* cmakedefine if your system has the `clearenv' function. */
#ifndef HAVE_CLEARENV
#define HAVE_CLEARENV
#endif

/* cmakedefine if your system has the <ctype.h> header file. */
#ifndef HAVE_CTYPE_H
#define HAVE_CTYPE_H
#endif

/* cmakedefine if your system has the <errno.h> header file. */
#ifndef HAVE_ERRNO_H
#define HAVE_ERRNO_H
#endif

/* cmakedefine if your system has the <locale.h> header file. */
#ifndef HAVE_LOCALE_H
#define HAVE_LOCALE_H
#endif

/* cmakedefine if your system has the `setenv' function. */
#ifndef HAVE_SETENV
#define HAVE_SETENV
#endif

/* cmakedefine if your system has the `futimens' function. */
#ifndef HAVE_FUTIMENS
#define HAVE_FUTIMENS
#endif

/* cmakedefine if your system has the `futimes' function. */
#ifndef HAVE_FUTIMES
#define HAVE_FUTIMES
#endif

/* cmakedefine if your system has the <stdio.h> header file. */
#ifndef HAVE_STDIO_H
#define HAVE_STDIO_H
#endif

/* cmakedefine if your system has the <stdlib.h> header file. */
#ifndef HAVE_STDLIB_H
#define HAVE_STDLIB_H
#endif

/* cmakedefine if your system has the <string.h> header file. */
#ifndef HAVE_STRING_H
#define HAVE_STRING_H
#endif

/* cmakedefine if your system has the <time.h> header file. */
#ifndef HAVE_TIME_H
#define HAVE_TIME_H
#endif

/* cmakedefine if your system has the <unistd.h> header file. */
#ifndef HAVE_UNISTD_H
#define HAVE_UNISTD_H
#endif

#endif
