/**
 * @file
 *
 * @brief Exported methods of the Library
 *
 * @copyright BSD License (see doc/COPYING or http://www.libelektra.org)
 */


/***************************************************************************
 *                                                                         *
 * This header file is AUTO GENERATED.                                     *
 * Do not edit this file, otherwise your changes will be discarded in the  *
 * next cmake run.                                                         *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the BSD License (revised).                      *
 *                                                                         *
 ***************************************************************************/

#ifndef KDB_H
#define KDB_H

#define ELEKTRA_SENTINEL // needed for SWIG
#define KDB_VERSION "0.8.14"
#define KDB_VERSION_MAJOR 0
#define KDB_VERSION_MINOR 8
#define KDB_VERSION_MICRO 14

#include "kdbos.h"


enum {
	KEY_FLAGS=3, // unique value, does not have to be a power of two
	KEY_END=0,
	KEY_NAME=1,
	KEY_VALUE=1<<1,
	KEY_OWNER=1<<2,
	KEY_COMMENT=1<<3,
	KEY_BINARY=1<<4,
	KEY_UID=1<<5,
	KEY_GID=1<<6,
	KEY_MODE=1<<7,
	KEY_ATIME=1<<8,
	KEY_MTIME=1<<9,
	KEY_CTIME=1<<10,
	KEY_SIZE=1<<11,
	KEY_FUNC=1<<12,
	KEY_DIR=1<<14,
	KEY_META=1<<15,
	KEY_NULL=1<<16,
	KEY_CASCADING_NAME=1<<20,
	KEY_META_NAME=1<<21
};

enum {
	KDB_O_NONE=0,
	KDB_O_DEL=1,
	KDB_O_POP=1<<1,
	KDB_O_NODIR=1<<2,
	KDB_O_DIRONLY=1<<3,
	KDB_O_NOREMOVE=1<<6,
	KDB_O_REMOVEONLY=1<<7,
	KDB_O_INACTIVE=1<<8,
	KDB_O_SYNC=1<<9,
	KDB_O_SORT=1<<10,
	KDB_O_NORECURSIVE=1<<11,
	KDB_O_NOCASE=1<<12,
	KDB_O_WITHOWNER=1<<13,
	KDB_O_NOALL=1<<14
};

enum
{
	KEY_NS_NONE=0,
	KEY_NS_EMPTY=1,
	KEY_NS_META=2,
	KEY_NS_CASCADING=3,
	KEY_NS_FIRST=4,
	KEY_NS_SPEC=4,
	KEY_NS_PROC=5,
	KEY_NS_DIR=6,
	KEY_NS_USER=7,
	KEY_NS_SYSTEM=8,
	KEY_NS_LAST=8
};


#ifdef __cplusplus
namespace ckdb {
extern "C" {
#endif


typedef struct _KDB	KDB;
typedef struct _Key	Key;
typedef struct _KeySet	KeySet;


/**************************************
 *
 * KDB methods
 *
 **************************************/

KDB * kdbOpen(Key *errorKey);
int kdbClose(KDB *handle, Key *errorKey);

int kdbGet(KDB *handle, KeySet *returned,
	Key *parentKey);
int kdbSet(KDB *handle, KeySet *returned,
	Key *parentKey);



/**************************************
 *
 * Key methods
 *
 **************************************/

/* Basic Methods */
Key *keyNew(const char *keyname, ...);
Key *keyVNew(const char *keyname, va_list ap);

Key *keyDup(const Key *source);
int keyCopy(Key *dest, const Key *source);

int keyClear(Key *key);
int keyDel(Key *key);

ssize_t keyIncRef(Key *key);
ssize_t keyDecRef(Key *key);
ssize_t keyGetRef(const Key *key);

/* Meta Info */
int keyRewindMeta(Key *key);
const Key *keyNextMeta(Key *key);
const Key *keyCurrentMeta(const Key *key);

int keyCopyMeta(Key *dest, const Key *source, const char *metaName);
int keyCopyAllMeta(Key *dest, const Key *source);

const Key *keyGetMeta(const Key *key, const char* metaName);
ssize_t    keySetMeta(Key *key, const char* metaName,
	const char *newMetaString);


/* Methods for Making Tests */
int keyCmp(const Key *k1, const Key *k2);
int keyRel (const Key *k1, const Key *k2);

int keyNeedSync(const Key *key);

int keyIsBelow(const Key *key, const Key *check);
int keyIsBelowOrSame(const Key *key, const Key *check);
int keyIsDirectBelow(const Key *key, const Key *check);

int keyIsInactive(const Key *key);

int keyIsBinary(const Key *key);
int keyIsString(const Key *key);

/* Name Manipulation Methods */
const char *keyName(const Key *key);
ssize_t keyGetNameSize(const Key *key);
ssize_t keyGetName(const Key *key, char *returnedName, size_t maxSize);

ssize_t keySetName(Key *key, const char *newname);
ssize_t keyAddName(Key *key, const char *addName);

const void *keyUnescapedName(const Key *key);
ssize_t keyGetUnescapedNameSize(const Key *key);

ssize_t keyGetFullNameSize(const Key *key);
ssize_t keyGetFullName(const Key *key, char *returnedName, size_t maxSize);

const char *keyBaseName(const Key *key);
ssize_t keyGetBaseNameSize(const Key *key);
ssize_t keyGetBaseName(const Key *key, char *returned, size_t maxSize);

ssize_t keySetBaseName(Key *key,const char *baseName);
ssize_t keyAddBaseName(Key *key,const char *baseName);

elektraNamespace keyGetNamespace(Key const* key);

/* Value Manipulation Methods */
const void *keyValue(const Key *key);
ssize_t keyGetValueSize(const Key *key);

const char *keyString(const Key *key);
ssize_t keyGetString(const Key *key, char *returnedString, size_t maxSize);
ssize_t keySetString(Key *key, const char *newString);

ssize_t keyGetBinary(const Key *key, void *returnedBinary, size_t maxSize);
ssize_t keySetBinary(Key *key, const void *newBinary, size_t dataSize);



/**************************************
 *
 * KeySet methods
 *
 **************************************/

KeySet *ksNew(size_t alloc, ...) ELEKTRA_SENTINEL;
KeySet *ksVNew(size_t alloc, va_list ap);

KeySet *ksDup(const KeySet * source);
int ksCopy(KeySet *dest, const KeySet *source);

int ksClear(KeySet *ks);
int ksDel(KeySet *ks);

int ksNeedSync(const KeySet *ks);

ssize_t ksGetSize(const KeySet *ks);

ssize_t ksAppendKey(KeySet *ks, Key *toAppend);

ssize_t ksAppend(KeySet *ks, const KeySet *toAppend);
KeySet *ksCut(KeySet *ks, const Key *cutpoint);

Key *ksPop(KeySet *ks);

int ksRewind(KeySet *ks);
Key *ksNext(KeySet *ks);
Key *ksCurrent(const KeySet *ks);

Key *ksHead(const KeySet *ks);
Key *ksTail(const KeySet *ks);

cursor_t ksGetCursor(const KeySet *ks);
int ksSetCursor(KeySet *ks, cursor_t cursor);
Key *ksAtCursor(KeySet *ks, cursor_t cursor);

Key *ksLookup(KeySet *ks, Key *k, option_t options);
Key *ksLookupByName(KeySet *ks, const char *name, option_t options);

#ifdef __cplusplus
}
}
#endif


#endif /* KDB_H */
