/**
 * @file
 *
 * @brief internal header for crypto.h
 *
 * @copyright BSD License (see doc/COPYING or http://www.libelektra.org)
 *
 */

#ifndef ELEKTRA_PLUGIN_CRYPTO_H_INTERNAL
#define ELEKTRA_PLUGIN_CRYPTO_H_INTERNAL

#define LIBGCRYPT_FOUND

enum ElektraCryptoHeaderFlags
{
	ELEKTRA_CRYPTO_FLAG_NONE = 0,
	ELEKTRA_CRYPTO_FLAG_STRING = 1,
	ELEKTRA_CRYPTO_FLAG_NULL = 2
};

struct ElektraCryptoHeader
{
	unsigned short flags;
	unsigned long contentLen;
};

#define ELEKTRA_CRYPTO_META_ENCRYPT ("crypto/encrypt")
#define ELEKTRA_CRYPTO_META_ENCRYPTED ("crypto/encrypted")

#ifdef LIBGCRYPT_FOUND

#include <gcrypt.h>
typedef gcry_cipher_hd_t elektraCryptoHandle;

#endif

#endif
