
plugin.loadMainCSS();


plugin.attachPageToTabs($('<div>').attr("id","FileShare").addClass('table_tab').get(0), 'File Share');


theWebUI.FS = {

	downlink: '',
	clip: {},

	 hasFlash:  function() {
	    return (typeof navigator.plugins == "undefined" || navigator.plugins.length == 0) ? !!(new ActiveXObject("ShockwaveFlash.ShockwaveFlash")) : navigator.plugins["Shockwave Flash"];
	},
	add: function (button) {

		var file = $('#FS_file').val();
		var duration = $('#FS_duration').val();
		var password = $('#FS_password').val();

		if(!duration.match(/^\d+$/) || (duration < 1)) {alert(theUILang.FSvdur); return false;}
		if(this.islimited(this.maxdur, duration)) {alert(theUILang.FSmaxdur+' '+this.maxdur); return false;}
		
		$(button).attr('disabled',true);
		
				
		var call = {'method': 'createShare',
					'file': file,
					'password': password,
					'expire': duration
					};

	var self = this;
		this.query(call,
				function() {
						self.refresh();	
						theDialogManager.hide('FS_main');
						log(theUILang.FSshow+': '+theUILang.FSlinkcreate + ' ' + self.getDownloadLink({'uh': '', 's': ''}) );
		});
	},

	edit: function (button) {

		var duration = $('#FS_duration').val();
		var password = $('#FS_password').val();
		var linkid = $('#FS_lid').val();

		if($.trim(duration) != '') {
			if (!duration.match(/^\d+$/) || (duration < 1)) {alert(theUILang.FSvdur); return false;}	
			if(this.islimited(this.maxdur, duration)) {alert(theUILang.FSmaxdur+' '+this.maxdur); return false;}
		}	

		$(button).attr('disabled',true);
		
						
		var call = {'method': 'editShare',
					'file': linkid,
					'password': password,
					'expire': duration};

		this.query(call,
				function() {	
						theDialogManager.hide('FS_main');
						theWebUI.FS.refresh();
				
						log(theUILang.FSshow+': '+theUILang.FSlinkcreate);
		});
	
	
	},

	del: function () {
		
		var sr = theWebUI.getTable("fsh").rowSel;
		var list = {};

		var x = 0;
		for (i in sr) {
			var id = i.split('_fsh_')[1];
			if (sr[i]) {list[x] = id; x++;}
		}
		
		var call = {'method': 'deleteShare',
					'files': list};

		this.query(call, function() {theWebUI.FS.refresh();});

	},

	islimited: function (max, cur) {return (max > 0) ? ((cur <= max) ? false : true) : false;},

	show: function (what, how) { 

		var file;
		var password;

		var edit = $('#FS_editbut');
		var add = $('#FS_addbut');

		switch(how) {

			case 'edit':
				var table = theWebUI.getTable("fsh");
				file = table.getValueById('_fsh_'+what, 'name');
				password = table.getValueById('_fsh_'+what, 'pass');
				$('#FS_downlink').val(table.getValueById('_fsh_'+what, 'link')).show();
				add.hide();
				edit.show();
				break;
			case 'add':
			
				if(what.split('|').length > 1){
					// we got called from torrent files table
					file = what;
				} else {
					file = theWebUI.fManager.curpath+what.split('|')[0];
				}
				password = '';
				$('#FS_downlink').hide();
				edit.hide();
				add.show();
				break;
		}

		$('#FS_lid').val(what);
		add.attr('disabled',false);
		edit.attr('disabled',false);
		$('#FS_duration').val('');
		$('#FS_password').val(password);
		$('#FS_file').val(file);
		theWebUI.fManager.makeVisbile('FS_main');
	},

	refresh: function() {
		
		var call = {'method': 'fileList'};
		var callback = function (data) {theWebUI.FS.tableadd(data);};

		theWebUI.FS.query(call, callback);
		
},

	getDownloadLink: function(getdata) {
		
		var uri = $.param(getdata);
		
		return theWebUI.FS.downlink+'?'+uri;
	},
	
	resize: function (w, h) {

		if(w!==null) {w-=8;}

		if(h!==null) {
			h-=($("#tabbar").height());
			h-=2;
        	}

		var table = theWebUI.getTable("fsh");
		if(table) {table.resize(w,h);}
	},


	rename: function() {
		var table = theWebUI.getTable("fsh");
		if(table.created && plugin.allStuffLoaded) {

			table.renameColumnById('time',theUILang.FSexpire);
			table.renameColumnById('name',theUILang.FSfile);
			table.renameColumnById('pass',theUILang.FSpassword);
			table.renameColumnById('link',theUILang.FSdlink);

		} else { setTimeout(arguments.callee,1000);}

	},

	tableadd: function(data) { 

		var table = theWebUI.getTable("fsh");
		table.clearRows();

		$.each(data.list, function(ndx,item) {
   			 
				table.addRowById({
					name: item.file,
					size: item.size,
					time: item.expire,
					pass: item.password,
					link: theWebUI.FS.getDownloadLink({'uh' : data.uh, 's': item.id}),
				}, "_fsh_"+item.id, 'Icon_File');
		});
		
		table.refreshRows();
	},

	tablecreate: function () {

		theWebUI.tables.fsh = {
			obj: new dxSTable(),
			columns:
			[
				{ text: '',			width: "210px", id: "name",		type: TYPE_STRING },
				{ text: theUILang.Size,			width: "60px",	id: "size",		type: TYPE_NUMBER },
				{ text: '', 			width: "120px", 	id: "time",		type: TYPE_STRING, 	"align" : ALIGN_CENTER},
				{ text: '',			width: "80px", 	id: "pass",		type: TYPE_STRING },
				{ text: '',			width: "310px",	id: "link",		type: TYPE_STRING }
			],
			container:	"FileShare",
			format:		theWebUI.FS.tableformat,
			onselect:	function(e,id) { theWebUI.FS.tablemenu(e,id); }
		};


	},


	tableformat: function(table,arr) {
		for(var i in arr)
		{
			if(arr[i]==null)
				arr[i] = '';
			else
   			switch(table.getIdByCol(i)) {
      				case 'size' : 
      					arr[i] = theConverter.bytes(arr[i], 2);
      					break;
				case 'time':
					arr[i] = theConverter.date(iv(arr[i])+theWebUI.deltaTime/1000);
					break;
	      		}
	   	}
		return(arr);
	},

	tablemenu: function(e, id) {

		if($type(id) && (e.button == 2)) {

		       theContextMenu.clear();

			var table = theWebUI.getTable("fsh");
			var target = id.split('_fsh_')[1];
			if(table.selCount == 1) {
				var link = theWebUI.getTable("fsh").getValueById('_fsh_'+target, 'link');
				
				if(theWebUI.FS.hasFlash() ){
					theWebUI.FS.clip.setText(link);
				}
			}

			var target = id.split('_fsh_')[1];
			theContextMenu.add([theUILang.fDelete, function() {askYesNo(theUILang.FSdel, theUILang.FSdelmsg, "theWebUI.FS.del()" );}]);
			theContextMenu.add([theUILang.FSedit, (table.selCount > 1) ? null : function() {theWebUI.FS.show(target, 'edit');}]);
			theContextMenu.add([CMENU_SEP]);
			theContextMenu.add([theUILang.FScopylink, ((table.selCount > 1) || !theWebUI.FS.hasFlash() )  ? null : function() {}]);

	   		theContextMenu.show();
			
			if(table.selCount == 1) {
				var lie = theContextMenu.get(theUILang.FScopylink)[0];

				if(theWebUI.FS.hasFlash() ) {
					if(!theWebUI.FS.clip.ready) {
						theWebUI.FS.clip.glue(lie); 
						theWebUI.FS.clip.addEventListener( 'onComplete', function() {theWebUI.FS.clip.hide();} );
					}
					theWebUI.FS.clip.reposition(lie);
	       			theWebUI.FS.clip.show(lie);
				}
			}
			

			return(true);
		}
		return(false);
	},


	query: function(data2send, complete, err) {

			console.log(data2send);
			$.ajax({
  				type: 'POST',
   				url: 'plugins/fileshare/action.php',
				timeout: theWebUI.settings["webui.reqtimeout"],
			    cache: false,
				data: {'action': flmUtil.json_encode(data2send)},
   				dataType: "json",

				error: function(XMLHttpRequest, textStatus, errorThrown) {
					log('FILE SHARE: error - STATUS:'+textStatus+' MSG: '+XMLHttpRequest.responseText);	
					console.log(XMLHttpRequest);
					if($type(err)) {err(textStatus, XMLHttpRequest);}		
				},

				success: function(data, textStatus) {if($type(complete)) {complete(data);}}
 		});


	}

};




plugin.config = theWebUI.config;
theWebUI.config = function(data) {

		theWebUI.FS.tablecreate();
		theWebUI.FS.rename();
		plugin.config.call(this,data);
};


plugin.createFileMenu = theWebUI.createFileMenu;
theWebUI.createFileMenu = function( e, id ) 
	{
		if(plugin.createFileMenu.call(this, e, id)) 
		{
			if(plugin.enabled) 
			{
//				theContextMenu.add([CMENU_SEP]);
				var fno = null;
				var table = this.getTable("fls");
				if((table.selCount == 1)  && (theWebUI.dID.length==40))
				{
					var fid = table.getFirstSelected();
					if(this.settings["webui.fls.view"])
					{
						var arr = fid.split('_f_');
						fno = arr[1];
					}
					else
					if(!this.dirs[this.dID].isDirectory(fid))
						fno = fid.substr(3);
				}
				theContextMenu.add( [theUILang.FSshare,  (fno==null) ? null : function() {theWebUI.FS.show(fno+'|'+theWebUI.dID+'|'+$('#_f_1').attr('title'), 'add');}] );
			}
			return(true);
		}
		return(false);
};

plugin.resizeBottom = theWebUI.resizeBottom;
theWebUI.resizeBottom = function( w, h ) {

		theWebUI.FS.resize(w, h);
		plugin.resizeBottom.call(this,w,h);
};


plugin.onShow = theTabs.onShow;
theTabs.onShow = function(id) {

	if(id == "FileShare") {
			$('#FS_refresh').show();
			theWebUI.getTable('fsh').refreshRows();
			theWebUI.resize();
	} else {$('#FS_refresh').hide(); plugin.onShow.call(this,id);}
};


plugin.flmMenu = theWebUI.fManager.flmSelect;
theWebUI.fManager.flmSelect = function( e, id ) {

		plugin.flmMenu.call(this, e, id);
		if(plugin.enabled) {
			var el = theContextMenu.get( theUILang.fcNewTor );
			if(el) {
				var item = id.split('_flm_')[1];
				theContextMenu.add( el, [theUILang.FSshare, (!flmUtil.isDir(item) && !(theWebUI.getTable("flm").selCount > 1) && !theWebUI.FS.islimited(theWebUI.FS.maxlinks, theWebUI.getTable("fsh").rows)) ? function() {theWebUI.FS.show(item, 'add');} : null]);
			}
		}
		
};



plugin.onLangLoaded = function() {

	injectScript('plugins/fileshare/settings.js.php', function() {theWebUI.FS.refresh();});
	if(theWebUI.FS.hasFlash()) {
		injectScript('plugins/fileshare/clip/clip.js', function() {
								ZeroClipboard.setMoviePath('plugins/fileshare/clip/ZeroClipboard.swf');
								theWebUI.FS.clip = new ZeroClipboard.Client();
							});
	}
	
	if(this.enabled) {
		plugin.renameTab('FileShare', theUILang.FSshow);
		$('#tab_lcont').append('<input type="button" id="FS_refresh" class="Button" value="'+theUILang.fRefresh+'" style="display: none;">');


		var add = '<div class="cont fxcaret"><fieldset><legend>Options:</legend>'+
				'<table border="0" cellspacing="0" cellpadding="0" >'+
  				'<tr><td>'+theUILang.FSfile+':</td>'+
    					'<td align="right"><input type="text" name="FS_file" class="TextboxLarge" readonly="readonly" id="FS_file" value=""/></td>'+
  				'</tr><tr><td>'+theUILang.FSdhours+':</td>'+
   				' <td align="right"><label><input type="text" name="FS_duration" id="FS_duration" class="Textbox" /></label></td>'+
 				' </tr><tr><td>'+theUILang.FSpassword+':</td><td align="right"><label><input name="FS_password" type="text" id="FS_password" class="Textbox" />'+
  				'</label><input name="FS_lid" type="hidden" id="FS_lid" value="" /></td></tr></table>'+
				'<textarea name="FS_downlink" rows="2" style="width: 100%" readonly="readonly" id="FS_downlink"></textarea></fieldset></div>'+
				'<div class="aright buttons-list">'+
					'<input type="button" id="FS_editbut" class="Button" value="'+theUILang.FSedit+'" class="Button" />'+
					'<input type="button" id="FS_addbut" class="Button" value="'+theUILang.FSadd+'" class="Button" />'+
					'<input type="button" class="Cancel Button" value="'+theUILang.fDiagClose+'"/>'+
				'</div>';
				

		theDialogManager.make('FS_main', theUILang.FSshow, add, false);

		$('#FS_addbut').click(function() {theWebUI.FS.add(this);});
		$('#FS_editbut').click(function() {theWebUI.FS.edit(this);});
		$('#FS_refresh').click(function() {theWebUI.FS.refresh();});



	}
};


plugin.onRemove = function() {
	this.removePageFromTabs('FileShare');
	$('[id^="FS_"]').remove();
};

plugin.loadLang(true);