#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Imports (Global)
import dbus, os, sys
from commands import getoutput
from time import sleep
from PyQt4.QtCore import Qt, QLocale, QProcess, QThread, QTranslator, QSettings, QVariant, SIGNAL
from PyQt4.QtGui import QAction, QCursor, QDialog, QFileDialog, QIcon, QMainWindow, QMenu, QMessageBox, QPixmap, QTableWidgetItem

# Imports (Custom)
import icons_rc, ui_festige, ui_settings, systray

VERSION = "1.0.2"

if not os.getenv("HOME"):
  print "HOME variable not set, cannot continue"
  sys.exit(1)

if not os.getenv("PATH"):
  print "PATH variable not set, cannot continue"
  sys.exit(1)

# DBus connections
class DBus(object):
    __slots__ = [
            'loopBus',
            'controlBus',
            'studioBus',
            'roomBus',
            'appBus',
    ]
DBus = DBus()

HOME = os.getenv("HOME")
WINEPREFIX = os.getenv("WINEPREFIX") if os.getenv("WINEPREFIX") else os.path.join(os.getenv("HOME"), ".wine")

cx_root = os.path.join(sys.path[0], "cx_root").replace(os.path.join("festige", "cx_root"),"")
if (os.path.exists(os.path.join(cx_root, "fst.exe"))):
  festige_root = cx_root
else:
  festige_root = os.path.join(sys.path[0].replace("src",""), "fst")
fst_exe = os.path.join(festige_root, "fst.exe")
fstinfo_exe = os.path.join(festige_root, "fstinfo.exe")

# Properly convert QString to str
def QStringStr(string):
    return str(unicode(string).encode('utf-8'))

# Convert QList<QVariant(QString)> to python list<str>
def QVariantStringList(variant):
    ret_list = []
    for i in range(len(variant)):
      ret_list.append(QStringStr(variant[i].toString()))
    return ret_list

# New Thread for getting info from plugin, so it doesn't lock the GUI
class VstInfoThread(QThread):
    def __init__(self, parent=None):
        super(VstInfoThread, self).__init__(parent)

        self._close = False
        self.next_plugin  = None
        self.next_command = None

    def getInfo(self, plugin, command):
        self.next_plugin  = QStringStr(plugin)
        self.next_command = QStringStr(command)

    def func_close(self):
        self._close = True
        sleep(0.5)

    def func_killall(self):
        os.system("killall fstinfo.exe fstinfo.exe.so &> /dev/null")

    def run(self):
        while True:
          if self._close:
            break

          if self.next_plugin != None:
            self.func_killall()
            output = getoutput(self.next_command)
            self.emit(SIGNAL("pluginChecked(QString, QString)"), self.next_plugin, output)
            self.func_killall()
            self.next_plugin = None
          else:
            sleep(0.5)

# Main Window
class FeSTigeMainW(QMainWindow, ui_festige.Ui_FeSTigeMainW):
    def __init__(self, app_=None):
        super(FeSTigeMainW, self).__init__(None)
        self.setupUi(self)
        self.setWindowIcon(QIcon(":/festige.png"))
        
        global app
        app = app_

        # Load Settings (GUI state)
        self.settings = QSettings()
        self.loadSettings()

        self.project_folder = self.settings_data["DefaultLadishFolder"]

        # LADI room
        ladi_room = os.getenv("LADISH_VGRAPH_NAME")
        if (DBus.studioBus and ladi_room):
          for RoomId, RoomProperties in DBus.studioBus.GetRoomList():
            if (RoomProperties["name"] == ladi_room):
              try:
                DBus.roomBus = DBus.loopBus.get_object("org.ladish", RoomId)
                DBus.appBus = dbus.Interface(DBus.roomBus, "org.ladish.AppSupervisor")
                ProjectRev, ProjectProperties = DBus.roomBus.GetProjectProperties()
                if ("dir" in ProjectProperties.keys()):
                  self.project_folder = QStringStr(ProjectProperties["dir"])
              except:
                DBus.roomBus = None
                DBus.appBus = dbus.Interface(DBus.studioBus, "org.ladish.AppSupervisor")
              break
          else:
            print "Failed to find requested LADI room"

        elif os.getenv("FESTIGE_PROJECT_FOLDER"):
          self.project_folder = os.getenv("FESTIGE_PROJECT_FOLDER")

        if self.project_folder[-1] != os.sep:
          self.project_folder += os.sep

        print "FeSTige project folder set to", self.project_folder

        if (os.getenv("LADISH_APP_NAME")):
          self.setWindowTitle(os.getenv("LADISH_APP_NAME"))

        # New Thread for lockless GUI
        self.infoThread = VstInfoThread(self)
        self.infoThread.start()

        # Pre-Setup GUI
        self.act_save.setEnabled(bool(DBus.studioBus))
        self.act_launch.setEnabled(False)
        self.act_ladish.setEnabled(False)
        self.act_info.setEnabled(False)
        self.act_delete.setEnabled(False)
        self.b_launch.setEnabled(False)
        self.b_ladish.setEnabled(False)
        self.b_info.setEnabled(False)
        self.b_delete.setEnabled(False)
        self.b_copy.setEnabled(False)
        self.b_copy.setText("") #PyQt4 Bug

        self.act_open.setIcon(self.getIcon("document-open"))
        self.act_save.setIcon(self.getIcon("document-save"))
        self.act_quit.setIcon(self.getIcon("application-exit"))
        self.act_launch.setIcon(self.getIcon("arrow-right"))
        self.act_ladish.setIcon(self.getIcon("list-add"))
        self.act_info.setIcon(self.getIcon("dialog-information"))
        self.act_delete.setIcon(self.getIcon("edit-delete"))
        self.act_refresh.setIcon(self.getIcon("view-refresh"))
        self.act_pref.setIcon(self.getIcon("configure"))

        self.b_launch.setIcon(self.getIcon("arrow-right"))
        self.b_ladish.setIcon(self.getIcon("list-add"))
        self.b_info.setIcon(self.getIcon("dialog-information"))
        self.b_delete.setIcon(self.getIcon("edit-delete"))
        self.b_copy.setIcon(self.getIcon("edit-copy"))
        self.b_refresh.setIcon(self.getIcon("view-refresh"))

        # Custom List Menu
        self.cMenu = QMenu()
        self.cMenu.addAction(self.act_launch)
        self.cMenu.addAction(self.act_ladish)
        self.cMenu.addAction(self.act_info)
        self.cMenu.addAction(self.act_delete)
        self.cMenu.addSeparator()
        self.cMenu.addAction(self.act_refresh)
        self.cMenu.addSeparator()
        self.sMenu = QMenu(self.tr("Sort By"))
        self.act_x_sort_name_asc = self.sMenu.addAction(self.tr("Name (Ascending)"))
        self.act_x_sort_name_desc = self.sMenu.addAction(self.tr("Name (Descending)"))
        self.act_x_sort_folder_asc = self.sMenu.addAction(self.tr("Folder (Ascending)"))
        self.act_x_sort_folder_desc = self.sMenu.addAction(self.tr("Folder (Descending)"))
        self.cMenu.addMenu(self.sMenu)

        # Systray
        self.systray = systray.GlobalSysTray("FeSTige", "festige")
        self.systray.setQtParent(self)
        self.systray.addAction("open", QStringStr(self.act_open.text()).replace("&",""))
        self.systray.addMenu("plugin", QStringStr(self.menu_plugin.title()).replace("&",""))

        self.systray.addAction("save", QStringStr(self.act_save.text()).replace("&",""))
        self.systray.addSeparator("sep1")
        self.systray.addAction("refresh", QStringStr(self.act_refresh.text()).replace("&",""))
        self.systray.addSeparator("sep2")
        self.systray.addAction("pref", QStringStr(self.act_pref.text()).replace("&",""))
        self.systray.addSeparator("sep3")
        self.systray.addAction("quit", QStringStr(self.act_quit.text()).replace("&",""))

        self.systray.setActionEnabled("save", bool(DBus.studioBus))

        self.systray.setActionIcon("open", "document-open")
        self.systray.setActionIcon("save", "document-save")
        self.systray.setActionIcon("refresh", "view-refresh")
        self.systray.setActionIcon("pref", "configure")
        self.systray.setActionIcon("quit", "application-exit")

        self.systray.connect("open", self.func_open)
        self.systray.connect("save", self.func_save)
        self.systray.connect("refresh", self.refreshPluginList)
        self.systray.connect("pref", self.func_Settings)
        self.systray.connect("quit", self.close)

        if (self.systray.getTrayEngine() == "AppIndicator"):
          if (os.path.exists("/usr/local/share/pixmaps/festige.png")):
            self.systray.setIcon("/usr/local/share/pixmaps/festige.png")
          elif (os.path.exists("/usr/share/pixmaps/festige.png")):
            self.systray.setIcon("/usr/share/pixmaps/festige.png")
          else:
            self.systray.setIcon("wine")
          self.gtk_timer_helper = self.startTimer(1000)
        else:
          self.gtk_timer_helper = None

        self.systray.setToolTip(self.tr(""
                                 "<b>FeSTige v%1</b><br>"
                                 "Using '%2' utility").arg(VERSION).arg(self.settings_data["Utility"]))

        self.systray.show()

        # Connect actions to functions
        self.connect(self.act_open, SIGNAL("triggered()"), self.func_open)
        self.connect(self.act_save, SIGNAL("triggered()"), self.func_save)
        self.connect(self.act_quit, SIGNAL("triggered()"), self.close)
        self.connect(self.act_launch, SIGNAL("triggered()"), self.func_launch)
        self.connect(self.act_ladish, SIGNAL("triggered()"), self.func_ladish)
        self.connect(self.act_info, SIGNAL("triggered()"), self.func_info)
        self.connect(self.act_delete, SIGNAL("triggered()"), self.func_delete)
        self.connect(self.act_refresh, SIGNAL("triggered()"), self.refreshPluginList)
        self.connect(self.act_pref, SIGNAL("triggered()"), self.func_Settings)
        self.connect(self.act_about, SIGNAL("triggered()"), self.func_About)
        self.connect(self.b_launch, SIGNAL("clicked()"), self.func_launch)
        self.connect(self.b_ladish, SIGNAL("clicked()"), self.func_ladish)
        self.connect(self.b_info, SIGNAL("clicked()"), self.func_info)
        self.connect(self.b_delete, SIGNAL("clicked()"), self.func_delete)
        self.connect(self.b_copy, SIGNAL("clicked()"), self.func_copy)
        self.connect(self.b_refresh, SIGNAL("clicked()"), self.refreshPluginList)
        self.connect(self.listVST, SIGNAL("currentCellChanged(int, int, int, int)"), self.checkActions)
        self.connect(self.listVST, SIGNAL("cellDoubleClicked(int, int)"), self.doubleClickedList)
        self.connect(self.listVST, SIGNAL("customContextMenuRequested(QPoint)"), self.showCustomMenu)
        self.connect(self.line_cmd, SIGNAL("textChanged(QString)"), self.updateToolTip)
        self.connect(self.infoThread, SIGNAL("pluginChecked(QString, QString)"), self.showVstInfo)

        self.connect(self.act_x_sort_name_asc,  SIGNAL("triggered()"), lambda column=0, mode=Qt.AscendingOrder: self.listVST.sortByColumn(column, mode))
        self.connect(self.act_x_sort_name_desc,  SIGNAL("triggered()"), lambda column=0, mode=Qt.DescendingOrder: self.listVST.sortByColumn(column, mode))
        self.connect(self.act_x_sort_folder_asc,  SIGNAL("triggered()"), lambda column=1, mode=Qt.AscendingOrder: self.listVST.sortByColumn(column, mode))
        self.connect(self.act_x_sort_folder_desc,  SIGNAL("triggered()"), lambda column=1, mode=Qt.DescendingOrder: self.listVST.sortByColumn(column, mode))

        # Search for plugins
        self.refreshPluginList()

    def func_open(self):
        fileLocation = QFileDialog.getOpenFileName(self, self.tr("Open Windows VST Plugin"), "", self.tr(""
                                                   "Windows VST Plugins%1").arg(" (*dll *DLL *Dll)")) # FIXME
        if not fileLocation.isEmpty():
          cmd = "%s &" % (self.getFinalCommand(QStringStr(fileLocation)))
          os.system(cmd)

    def func_save(self):
        if (DBus.roomBus):
          DBus.roomBus.Save()
        elif (DBus.studioBus):
          DBus.studioBus.Save()

    def func_launch(self):
        if not self.line_cmd.text().isEmpty():
          cmd = "%s &" % (QStringStr(self.line_cmd.text()))
          os.system(cmd)

    def func_ladish(self):
        cmd = QStringStr(self.line_cmd.text())
        name = QStringStr(self.listVST.item(self.listVST.currentRow(), 0).text())
        level = self.settings_data["DefaultLadishLevel"] if (self.settings_data["Utility"] == "fst") else 0

        if (cmd and DBus.appBus):
          DBus.appBus.RunCustom(False, cmd, name, level)

    def func_info(self):
        plugin = self.listVST.item(self.listVST.currentRow(), 0).text()
        command = "env WINEDEBUG=-all WINEPREFIX='%s' %s '%s'" % (WINEPREFIX, fstinfo_exe, QStringStr(self.listVST.item(self.listVST.currentRow(), 0).toolTip()))
        self.statusBar.showMessage(self.tr("Getting info from plugin '%1'...").arg(plugin))

        # Use the VstInfoThread to get the info, so the GUI doesn't lock
        self.infoThread.getInfo(plugin, command)

    def func_delete(self):
        ask = QMessageBox.question(self, self.tr("Delete?"), self.tr(""
                          "Are you sure you want to delete plugin '%1' ?%2(It will NOT be available in the trash!)%3"
                          "").arg(self.listVST.item(self.listVST.currentRow(), 0).text()).arg("<br><i>").arg("</i>"),
                          QMessageBox.Yes | QMessageBox.No)
        if (ask == QMessageBox.Yes):
            plugin = QStringStr(self.listVST.item(self.listVST.currentRow(), 0).toolTip())
            if (os.path.exists(plugin)):
              try:
                os.remove(plugin)
                self.refreshPluginList()
              except:
                QMessageBox.warning(self, self.tr("Warning"), self.tr(""
                "Could not delete selected plugin..."))
            else:
              QMessageBox.critical(self, self.tr("Error"), self.tr(""
              "Could not find the selected plugin..."))

    def func_copy(self):
        clipboard = app.clipboard()
        clipboard.setText(self.line_cmd.text())

    def func_exit(self):
        self.systray.close()
        self.infoThread.func_close()
        self.infoThread.quit()
        self.saveSettings()

        # Kill all fst/vsthost processes ?
        procs = getoutput("ps -e").split()
        if ("fst" in procs or "fst.exe" in procs or "fst.exe.so" in procs or "vsthost" in procs):
            ask = QMessageBox.question(self, self.tr("Quit fst/dssi-vst too?"), self.tr(""
                              "Do you also want to close all plugin instances too?"), QMessageBox.Yes | QMessageBox.No)
            if (ask == QMessageBox.Yes):
                os.system("killall fst fst.exe fst.exe.so fstinfo.exe fstinfo.exe.so vsthost")
                os.system("killall -KILL fst fst.exe fst.exe.so fstinfo.exe fstinfo.exe.so vsthost")

    def func_Settings(self):
        if FeSTigeSettingsW(self).exec_():
          self.loadSettings(False)
          self.refreshPluginList()

    def func_About(self):
        QMessageBox.about(self, "FeSTige v"+VERSION, self.tr(""
        "<b>FeSTige</b> is a GUI for 'fst' and 'dssi-vst',<br>"
        "allowing you to run Windows VST plugins on Linux.<p>"
        "FeSTige is being developed by falkTX,<br>"
        "and it's released under the terms of the GNU GPL v2 or superior."))

    def isNewLadish(self):
        try:
          DBus.loopBus.get_object("org.ladish", "/org/ladish/LashServer")
          is_new = True
        except:
          is_new = False
        return is_new

    def doubleClickedList(self, row, column):
        if (row >= 0):
          self.func_launch()

    def getIcon(self, icon):
        return QIcon.fromTheme(icon, QIcon(":/%s.png" % (icon)))

    def getFinalCommand(self, plugin_file):
        cmd = "env WINEPREFIX=%s" % (self.settings_data["WINEPREFIX"])
        cmd += " VST_PATH='%s'" % (plugin_file.replace(os.path.basename(plugin_file), ""))

        if (self.settings_data["UseWineRT"]):
          cmd += " WINE_RT=%s" % (self.settings_data["WINE_RT"])

        if (self.settings_data["UseWineSVRT"]):
          cmd += " WINE_SVRT=%s" % (self.settings_data["WINE_SVRT"])

        if (self.settings_data["UseChrt"]):
          cmd += " chrt -f -p 1"

        if (self.settings_data["Utility"] == "fst"):
          cmd += " %s '%s' '%s'" % (fst_exe, os.path.join(self.project_folder, os.path.basename(plugin_file).rsplit(".",1)[0]), os.path.basename(plugin_file))
        else:
          cmd += " vsthost '%s'" % (os.path.basename(plugin_file).replace(" ","*"))

        return cmd

    def checkActions(self, currentRow, currentColumn, previousRow, previousColumn):
        if (currentRow >= 0):
          state = True
        else:
          state = False

        self.act_launch.setEnabled(state)
        self.act_info.setEnabled(state)
        self.act_delete.setEnabled(state)
        self.b_launch.setEnabled(state)
        self.b_info.setEnabled(state)
        self.b_delete.setEnabled(state)
        self.b_copy.setEnabled(state)

        if (DBus.appBus): self.act_ladish.setEnabled(state)
        if (DBus.appBus): self.b_ladish.setEnabled(state)
        if (DBus.appBus): self.systray.setActionEnabled("save", state)

        if (state):
          p_name   = QStringStr(self.listVST.item(currentRow, 0).text())
          p_folder = QStringStr(self.listVST.item(currentRow, 1).text())
          p_file   = QStringStr(self.listVST.item(currentRow, 0).toolTip())

          cmd = self.getFinalCommand(p_file)

          cmd_splitted = ""
          for i in range(len(cmd.split())):
            cmd_splitted += cmd.split()[i]+" "
            if (i and i % 4 == 0 and i != len(cmd.split())-1): cmd_splitted += "\n"

          self.line_cmd.setText(cmd)
          self.line_cmd.setToolTip(cmd_splitted)
          self.statusBar.showMessage(p_file)

        else:
          self.line_cmd.setText("")
          self.line_cmd.setToolTip("")
          self.statusBar.showMessage("")

    def showVstInfo(self, plugin, output):
        QMessageBox.information(self, self.tr("VST Plugin Info"), self.tr(""
          "Info from plugin %1").arg("<b>"+plugin+"</b>:<p>"+output.replace("\n","<br>")))

    def doubleClickedList(self, row, column):
        if (row >= 0):
          self.func_launch()

    def refreshPluginList(self):
        # Disable sorting while changing content
        self.listVST.setSortingEnabled(False)

        # Remove Old Stuff
        self.menu_plugin.clear()
        self.systray.clearMenu("plugin")
        self.listVST.clearContents()
        for i in range(self.listVST.rowCount()):
          self.listVST.removeRow(0)

        # Get More folders
        extraHomePaths = [
          os.path.join(HOME, "vst"),
          os.path.join(HOME, "linux-vst"),
          os.path.join(HOME, ".vst"),
          os.path.join(WINEPREFIX, "drive_c", "Program Files", "VstPlugins"),
          os.path.join(WINEPREFIX, "drive_c", "Program Files", "Steinberg/VstPlugins"),
          os.path.join(WINEPREFIX, "drive_c", "Programas", "VstPlugins"),
          os.path.join(WINEPREFIX, "drive_c", "Programas", "Steinberg", "VstPlugins")
        ]

        extraSysPaths = [ 
          "/usr/local/lib/vst/",
          "/usr/lib/vst/",
          "/usr/lib32/vst/"
        ]

        if os.getenv("VST_PATH"):
          VST_PATH_str = os.getenv("VST_PATH")
          VST_PATH = VST_PATH_str.split(":") if ":" in VST_PATH_str else [VST_PATH_str]
          #print "VST_PATH is set to:", VST_PATH
        else:
          VST_PATH = []

        # Check if they exist
        for PATH in extraHomePaths:
          if os.path.exists(PATH) and PATH not in VST_PATH:
            VST_PATH.append(PATH)

        for j in range(len(extraSysPaths)):
          if os.path.exists(PATH) and PATH not in VST_PATH:
            VST_PATH.append(PATH)

        if self.settings_data["ExtraVstPath"]:
          for VstPath in self.settings_data["ExtraVstPath"]:
            VST_PATH.append(VstPath)

        VST_PATH.sort()

        # Add plugins to the list
        last_pos = 0
        AddedPluginList = []
        listOfMenus_f = []
        listOfMenus_m = []

        for PATH in VST_PATH:
          if os.path.exists(PATH):
            PluginList = getoutput("find '%s' -name \*.dll" % (PATH)).split("\n")
            PluginList.sort()

            for Plugin in PluginList:
              if (Plugin):
                if Plugin not in AddedPluginList:
                  AddedPluginList.append(Plugin)

                  p_name   = os.path.basename(Plugin).rsplit(".dll", 1)[0]
                  p_folder = Plugin.rsplit(p_name, 1)[0]

                  if (p_folder in listOfMenus_f):
                    pMenu = listOfMenus_m[listOfMenus_f.index(p_folder)]
                  else:
                    pMenu = QMenu(p_folder, self.menu_plugin)
                    self.menu_plugin.addMenu(pMenu)
                    listOfMenus_f.append(p_folder)
                    listOfMenus_m.append(pMenu)
                    self.systray.addSubMenu("plugin", "plugin:"+p_folder, p_folder)

                  # Add to Menu
                  p_action = QAction(p_name, pMenu)
                  pMenu.addAction(p_action)
                  self.connect(p_action, SIGNAL("triggered()"), lambda filename=Plugin: self.func_loadPluginFromMenu(filename))
                  
                  self.systray.addMenuAction("plugin:"+p_folder, Plugin, p_name)
                  self.systray.connect(Plugin, lambda filename=Plugin: self.func_loadPluginFromMenu(filename))

                  # Add to list
                  tw_name   = QTableWidgetItem(p_name)
                  tw_folder = QTableWidgetItem(p_folder)
                  self.listVST.insertRow(last_pos)
                  self.listVST.setItem(last_pos, 0, tw_name)
                  self.listVST.setItem(last_pos, 1, tw_folder)
                  self.listVST.item(last_pos, 0).setStatusTip(Plugin)
                  self.listVST.item(last_pos, 0).setToolTip(Plugin)
                  last_pos += 1

        # Re-Enable Sorting Back again
        self.listVST.setSortingEnabled(True)

        # Sort by folder, then name
        self.listVST.sortByColumn(0, Qt.AscendingOrder)
        self.listVST.sortByColumn(1, Qt.AscendingOrder)

        # Auto-Select first plugin, if there are any
        if (self.listVST.rowCount() > 0):
          self.listVST.setCurrentCell(0, 0)

    def func_loadPluginFromMenu(self, filename):
        cmd = "%s &" % (self.getFinalCommand(QStringStr(filename)))
        os.system(cmd)

    def updateToolTip(self, text):
        if (text.isEmpty() or self.listVST.rowCount() < 0):
          self.line_cmd.setToolTip("")
          self.act_launch.setEnabled(False)
          self.act_ladish.setEnabled(False)
          self.b_launch.setEnabled(False)
          self.b_ladish.setEnabled(False)
          self.systray.setActionEnabled("save", False)
        else:
          cmd_splitted = ""
          for i in range(len(text.split(" "))):
            cmd_splitted += text.split(" ")[i]+" "
            if (i and i % 4 == 0 and i != len(text.split(" "))-1): cmd_splitted += "\n"
          self.line_cmd.setToolTip(cmd_splitted)
          self.act_launch.setEnabled(True)
          self.b_launch.setEnabled(True)

          if DBus.appBus:
            self.act_ladish.setEnabled(True)
            self.b_ladish.setEnabled(True)
            self.systray.setActionEnabled("save", True)

    def showCustomMenu(self, pos):
        # Show Menu at cursor position
        newPos = QCursor.pos()
        self.cMenu.setGeometry(newPos.x(), newPos.y(), 0, 0)
        self.cMenu.exec_()

    def saveSettings(self):
        self.settings.setValue("Geometry", QVariant(self.saveGeometry()))
        self.settings.setValue("ColumnName", self.listVST.columnWidth(0))
        self.settings.setValue("ColumnFolder", self.listVST.columnWidth(1))

    def loadSettings(self, geometry=True):
        if (geometry):
          self.restoreGeometry(self.settings.value("Geometry").toByteArray())
          self.listVST.setColumnWidth(0, self.settings.value("ColumnName", 200).toInt()[0])
          self.listVST.setColumnWidth(1, self.settings.value("ColumnFolder", 200).toInt()[0])

        self.settings_data = {
          "Utility": QStringStr(self.settings.value("Utility", "fst").toString()),
          "ExtraVstPath": QVariantStringList(self.settings.value("ExtraVstPath", []).toList()),

          "DefaultLadishFolder": QStringStr(self.settings.value("DefaultLadishFolder", os.path.join(HOME, ".ladish", "festige")).toString()),
          "DefaultLadishLevel": self.settings.value("DefaultLadishLevel", 1).toInt()[0],

          "UseChrt": self.settings.value("UseChrt", False).toBool(), 
          "UseWineRT": self.settings.value("UseWineRT", True).toBool(),
          "UseWineSVRT": self.settings.value("UseWineSVRT", True).toBool(),

          "WINE_RT": self.settings.value("WINE_RT", 15).toInt()[0],
          "WINE_SVRT": self.settings.value("WINE_SVRT", 10).toInt()[0],
          "WINEPREFIX": QStringStr(self.settings.value("WINEPREFIX", WINEPREFIX).toString()),
        }

    def timerEvent(self, event):
        if (self.gtk_timer_helper and event.timerId() == self.gtk_timer_helper):
          self.repaint()
        QMainWindow.timerEvent(self, event)

    def closeEvent(self, event):
        self.func_exit()
        return QMainWindow.closeEvent(self, event)

# Main Window
class FeSTigeSettingsW(QDialog, ui_settings.Ui_FeSTigeSettingsW):
    def __init__(self, parent=None):
        super(FeSTigeSettingsW, self).__init__(parent)
        self.setupUi(self)
        self.setWindowIcon(QIcon(":/festige.png"))

        self.settings = self.parent().settings
        self.settings_data = self.parent().settings_data
        self.loadSettings()

        self.b_add.setIcon(self.getIcon("list-add"))
        self.b_remove.setIcon(self.getIcon("list-remove"))
        self.b_edit.setIcon(self.getIcon("edit-rename"))
        self.b_reset_ladish.setIcon(self.getIcon("edit-undo"))
        self.b_reset_wine.setIcon(self.getIcon("edit-undo"))

        for PATH in os.getenv("PATH").split(":"):
          if os.path.exists(os.path.join(PATH, "vsthost")):
            break
        else:
          self.ch_fst.setChecked(True)
          self.ch_vsthost.setEnabled(False)

        self.connect(self.b_add,  SIGNAL("clicked()"), self.func_addDir)
        self.connect(self.b_remove,  SIGNAL("clicked()"), self.func_deleteDir)
        self.connect(self.b_edit,  SIGNAL("clicked()"), self.func_editDir)
        self.connect(self.listPaths, SIGNAL("currentRowChanged(int)"), self.changedDirRow)
        self.connect(self.b_reset_wine,  SIGNAL("clicked()"), self.func_resetWinePrefix)
        self.connect(self.b_reset_ladish,  SIGNAL("clicked()"), self.func_resetLadishFolder)
        self.connect(self, SIGNAL("accepted()"), self.saveSettings)

        self.connect(self.ch_fst, SIGNAL("clicked()"), lambda is_fst=True: self.func_updateInfo(is_fst))
        self.connect(self.ch_vsthost, SIGNAL("clicked()"), lambda is_fst=False: self.func_updateInfo(is_fst))

        self.icon_yes = self.getIcon("dialog-ok-apply").pixmap(16, 16)
        self.icon_no  = self.getIcon("dialog-cancel").pixmap(16, 16)

        self.func_updateInfo(self.settings_data["Utility"] == "fst")

    def func_addDir(self):
        folderLocation = QFileDialog.getExistingDirectory(self, self.tr("VST Plugins Folder"), "")
        if not folderLocation.isEmpty() and os.path.exists(QStringStr(folderLocation)):
          self.listPaths.addItem(folderLocation)

    def func_deleteDir(self):
        if (self.listPaths.currentRow() >= 0):
          self.listPaths.takeItem(self.listPaths.currentRow())
          self.listPaths.setCurrentRow(-1)

    def func_editDir(self):
        if (self.listPaths.currentRow() >= 0):
          folderLocation = QFileDialog.getExistingDirectory(self, self.tr("VST Plugins Folder"), self.listPaths.currentItem().text())
          if not folderLocation.isEmpty() and os.path.exists(QStringStr(folderLocation)):
            self.listPaths.currentItem().setText(folderLocation)

    def changedDirRow(self, row):
        if (row < 0):
          state = False
        else:
          state = True
        self.b_remove.setEnabled(state)
        self.b_edit.setEnabled(state)

    def func_resetWinePrefix(self):
        self.lineWinePrefix.setText(WINEPREFIX)

    def func_resetLadishFolder(self):
        self.lineLadishFolder.setText(os.path.join(HOME, ".ladish", "festige"))

    def func_updateInfo(self, is_fst):
        self.label_ladish.setEnabled(is_fst)
        self.lineLadishFolder.setEnabled(is_fst)
        self.b_reset_ladish.setEnabled(is_fst)
        self.gr_ladish.setEnabled(is_fst)

        if (is_fst):
          self.i_nogui.setPixmap(self.icon_no)
          self.i_presets.setPixmap(self.icon_yes)
          self.i_lash.setPixmap(self.icon_yes)
          self.i_tempo.setPixmap(self.icon_yes)
          self.i_midi.setText("JACK")
        else:
          self.i_nogui.setPixmap(self.icon_yes)
          self.i_presets.setPixmap(self.icon_no)
          self.i_lash.setPixmap(self.icon_no)
          self.i_tempo.setPixmap(self.icon_no)
          self.i_midi.setText("ALSA")

    def getIcon(self, icon):
        return self.parent().getIcon(icon)

    def saveSettings(self):
        ExtraVstPath = []
        for i in range(self.listPaths.count()):
          ExtraVstPath.append(QStringStr(self.listPaths.item(i).text()))

        ladish_folder = QStringStr(self.lineLadishFolder.text())
        if not os.path.exists(ladish_folder):
          os.system("mkdir -p %s" % (ladish_folder))

        self.settings.setValue("Utility", "fst" if self.ch_fst.isChecked() else "vsthost")
        self.settings.setValue("ExtraVstPath", QVariant(ExtraVstPath))

        self.settings.setValue("DefaultLadishFolder", ladish_folder)
        self.settings.setValue("DefaultLadishLevel", self.co_ladish_level.currentIndex())

        self.settings.setValue("UseChrt", self.ch_chrt.isChecked())
        self.settings.setValue("UseWineRT", self.ch_winert.isChecked())
        self.settings.setValue("UseWineSVRT", self.ch_winesvrt.isChecked())

        self.settings.setValue("WINE_RT", self.spinRT.value())
        self.settings.setValue("WINE_SVRT", self.spinSVRT.value())
        self.settings.setValue("WINEPREFIX", self.lineWinePrefix.text())

    def loadSettings(self):
        if (self.settings_data["Utility"] == "vsthost"):
          self.ch_vsthost.setChecked(True)
        else:
          self.ch_fst.setChecked(True)

        self.lineWinePrefix.setText(self.settings_data["WINEPREFIX"])
        self.lineLadishFolder.setText(self.settings_data["DefaultLadishFolder"])
        self.spinRT.setValue(self.settings_data["WINE_RT"])
        self.spinSVRT.setValue(self.settings_data["WINE_SVRT"])
        self.co_ladish_level.setCurrentIndex(self.settings_data["DefaultLadishLevel"])

        self.ch_winert.setChecked(self.settings_data["UseWineRT"])
        self.ch_winesvrt.setChecked(self.settings_data["UseWineSVRT"])
        self.ch_chrt.setChecked(self.settings_data["UseChrt"])

        self.listPaths.clear()
        for VstPath in self.settings_data["ExtraVstPath"]:
          self.listPaths.addItem(VstPath)
