/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.oware;

import com.joansala.engine.Book;
import com.joansala.engine.Game;
import com.joansala.engine.Roots;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Random;

public class OwareRoots
extends Book
implements Roots {
    public static final String SIGNATURE = "Oware Opening Book ";
    public static final int ENTRY_SIZE = 20;
    private final long OFFSET;
    private final int MAX_POSITION;
    private final RandomAccessFile database;
    private final Random generator = new Random();
    private int scoreMargin = 10;
    private boolean outOfBook = false;

    public OwareRoots(File file) throws IOException {
        super(file, SIGNATURE);
        this.database = this.getDatabase();
        this.OFFSET = this.database.getFilePointer();
        this.MAX_POSITION = (int)((this.database.length() - this.OFFSET) / 20L);
    }

    public void setScoreMargin(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Margin must be greater or equal to zero");
        }
        this.scoreMargin = n;
    }

    @Override
    public void newMatch() {
        this.outOfBook = false;
    }

    @Override
    public int pickBestMove(Game game) throws IOException {
        if (this.outOfBook) {
            return -1;
        }
        int[] nArray = this.findBestMoves(game);
        if (nArray == null) {
            this.outOfBook = true;
            return -1;
        }
        int n = this.generator.nextInt(nArray.length);
        return nArray[n];
    }

    public int[] findBestMoves(Game game) throws IOException {
        int n = 0;
        int n2 = this.MAX_POSITION;
        long l = game.hash();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            this.database.seek(this.OFFSET + (long)(n3 * 20));
            long l2 = this.database.readLong();
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l2 > l) {
                n2 = n3 - 1;
                continue;
            }
            short[] sArray = new short[6];
            short s = Short.MIN_VALUE;
            for (int i = 0; i < 6; ++i) {
                sArray[i] = this.database.readShort();
                if (sArray[i] <= s) continue;
                s = sArray[i];
            }
            if (s == Short.MIN_VALUE) {
                return null;
            }
            int[] nArray = new int[6];
            int n4 = game.turn() == 1 ? 0 : 6;
            int n5 = 0;
            for (int i = 0; i < 6; ++i) {
                int n6;
                if (s >= -this.scoreMargin ? sArray[i] < (n6 = Math.max(s - this.scoreMargin, -this.scoreMargin)) : sArray[i] != s) continue;
                nArray[n5++] = (byte)(i + n4);
            }
            return Arrays.copyOf(nArray, n5);
        }
        return null;
    }
}

