/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.oware;

import com.joansala.engine.UCIClient;
import com.joansala.engine.UCIMatch;
import com.joansala.oware.OwareBoard;
import com.joansala.oware.OwareGame;

public final class OwareMatch {
    private OwareMatch() {
    }

    private static void showUsage(Exception exception) {
        System.out.format("Exception:%n%n  %s%n%nUsage:%n%n  Match [parameters] <command> [argument ...]%n%nValid parameters are:%n%n  -turn      <string>  (south/north)%n  -movetime  <int>     (milliseconds)%n", exception.getMessage());
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = null;
        int n = 1;
        int n2 = 2000;
        OwareBoard owareBoard = new OwareBoard();
        OwareGame owareGame = new OwareGame();
        try {
            if (stringArray.length < 1) {
                throw new IllegalArgumentException("No engine command was specified");
            }
            int n3 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if ("-turn".equals(stringArray[n3])) {
                    String string;
                    if ("south".equals(string = stringArray[++n3])) {
                        n = 1;
                        continue;
                    }
                    if ("north".equals(string)) {
                        n = -1;
                        continue;
                    }
                    throw new IllegalArgumentException("Not a valid turn argument");
                }
                if (!"-movetime".equals(stringArray[n3])) break;
                if ((n2 = Integer.parseInt(stringArray[++n3])) >= 1) continue;
                throw new IllegalArgumentException("Not a valid time per move argument");
            }
            if (stringArray.length <= n3) {
                throw new IllegalArgumentException("No engine command was specified");
            }
            int n4 = stringArray.length - n3;
            stringArray2 = new String[n4];
            System.arraycopy(stringArray, n3, stringArray2, 0, n4);
        }
        catch (Exception exception) {
            OwareMatch.showUsage(exception);
            System.exit(1);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
            Process process = processBuilder.start();
            UCIClient uCIClient = new UCIClient(process, owareBoard, owareGame);
            UCIMatch uCIMatch = new UCIMatch(uCIClient, owareBoard, new OwareGame());
            uCIMatch.start(n, n2);
        }
        catch (Exception exception) {
            OwareMatch.showUsage(new Exception("Cannot start engine process."));
        }
    }
}

