/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.oware;

import com.joansala.engine.Book;
import com.joansala.engine.Game;
import com.joansala.engine.Leaves;
import com.joansala.oware.OwareGame;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OwareLeaves
extends Book
implements Leaves {
    public static final String SIGNATURE = "Oware Endgames ";
    public static final int MAX_SEEDS = 15;
    private static final int SEEDS_DIFF = -33;
    private static final int EXACT_SCORE = 3;
    private static final int CYCLE_SCORE = 1;
    private final int NUM_CAPTURES;
    private final byte[] data;
    private int score = 0;
    private static final int[][] COEFFICIENTS = new int[][]{{15, 120, 680, 3060, 11628, 38760, 116280, 319770, 817190, 1961256, 4457400, 9657700}, {14, 105, 560, 2380, 8568, 27132, 77520, 203490, 497420, 1144066, 2496144, 5200300}, {13, 91, 455, 1820, 6188, 18564, 50388, 125970, 293930, 646646, 1352078, 2704156}, {12, 78, 364, 1365, 4368, 12376, 31824, 75582, 167960, 352716, 705432, 1352078}, {11, 66, 286, 1001, 3003, 8008, 19448, 43758, 92378, 184756, 352716, 646646}, {10, 55, 220, 715, 2002, 5005, 11440, 24310, 48620, 92378, 167960, 293930}, {9, 45, 165, 495, 1287, 3003, 6435, 12870, 24310, 43758, 75582, 125970}, {8, 36, 120, 330, 792, 1716, 3432, 6435, 11440, 19448, 31824, 50388}, {7, 28, 84, 210, 462, 924, 1716, 3003, 5005, 8008, 12376, 18564}, {6, 21, 56, 126, 252, 462, 792, 1287, 2002, 3003, 4368, 6188}, {5, 15, 35, 70, 126, 210, 330, 495, 715, 1001, 1365, 1820}, {4, 10, 20, 35, 56, 84, 120, 165, 220, 286, 364, 455}, {3, 6, 10, 15, 21, 28, 36, 45, 55, 66, 78, 91}, {2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private static final int[] OFFSETS = new int[]{0, 1, 13, 91, 455, 1820, 6188, 18564, 50388, 125970, 293930, 646646, 1352078, 2704156, 5200300, 9657700, 17383860};

    public OwareLeaves(File file, int n) throws IOException {
        super(file, SIGNATURE);
        if (n < 1 || n > 15) {
            throw new IllegalArgumentException("Incorrect number of seeds");
        }
        this.NUM_CAPTURES = 48 - n;
        this.data = new byte[1 + OFFSETS[1 + n]];
        RandomAccessFile randomAccessFile = this.getDatabase();
        randomAccessFile.readFully(this.data);
        randomAccessFile.close();
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public boolean find(Game game) {
        OwareGame owareGame = (OwareGame)game;
        int n = owareGame.southStore() + owareGame.northStore();
        if (n < this.NUM_CAPTURES) {
            return false;
        }
        return game.turn() == 1 ? this.findSouth(owareGame, n) : this.findNorth(owareGame, n);
    }

    private boolean findSouth(OwareGame owareGame, int n) {
        int n2 = this.southIndex(owareGame, n);
        byte by = this.data[n2];
        int n3 = by & 3;
        if (n3 == 1 && !owareGame.wasCapture()) {
            return false;
        }
        int n4 = (by >> 2) + owareGame.southStore();
        this.score = n4 == 24 ? 0 : (n4 > 24 ? (n3 == 1 ? n << 4 : 1000) : (n3 == 1 ? -(n << 4) : -1000));
        return true;
    }

    private boolean findNorth(OwareGame owareGame, int n) {
        int n2 = this.northIndex(owareGame, n);
        byte by = this.data[n2];
        int n3 = by & 3;
        if (n3 == 1 && !owareGame.wasCapture()) {
            return false;
        }
        int n4 = (by >> 2) + owareGame.northStore();
        this.score = n4 == 24 ? 0 : (n4 > 24 ? (n3 == 1 ? -(n << 4) : -1000) : (n3 == 1 ? n << 4 : 1000));
        return true;
    }

    private int southIndex(OwareGame owareGame, int n) {
        byte[] byArray = owareGame.gameState();
        int n2 = -33 + n;
        int n3 = 0;
        for (int i = 11; n2 < 15 && i >= 0; n2 += byArray[i], --i) {
            n3 += COEFFICIENTS[n2][i];
        }
        return n3;
    }

    private int northIndex(OwareGame owareGame, int n) {
        int n2;
        byte[] byArray = owareGame.gameState();
        int n3 = -33 + n;
        int n4 = 0;
        for (n2 = 5; n3 < 15 && n2 >= 0; n3 += byArray[n2], --n2) {
            n4 += COEFFICIENTS[n3][n2 + 6];
        }
        for (n2 = 11; n3 < 15 && n2 >= 6; n3 += byArray[n2], --n2) {
            n4 += COEFFICIENTS[n3][n2 - 6];
        }
        return n4;
    }
}

