/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.oware;

import com.joansala.engine.Game;

public class OwareGame
implements Game {
    public static final int MAX_SCORE = 1000;
    public static final int MAX_CAPACITY = 0x7FFFFFF;
    private static final int DEFAULT_CAPACITY = 254;
    private static final int CAPACITY_INCREMENT = 126;
    private static final byte GEN_CAPTURES = 0;
    private static final byte GEN_SOWS = 1;
    private static final byte GEN_VULNERABLES = 2;
    private static final byte GEN_REMAINING = 3;
    private static final byte GEN_FINALIZED = 4;
    private int capacity;
    private int turn;
    private byte move;
    private long hash;
    private byte status;
    private byte house;
    private int[] legal = new int[6];
    private byte[] position;
    private long[] hashes;
    private byte[] moves;
    private byte[] history;
    private int[] captures;
    private int index;
    private int capture;
    private int captureIndex;
    public static final byte[] START_POSITION = new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0};
    private static final byte[] EMPTY_POSITION = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 24};
    private static final byte[] SOUTH_HOUSES = new byte[]{5, 4, 3, 2, 1, 0};
    private static final byte[] NORTH_HOUSES = new byte[]{11, 10, 9, 8, 7, 6};
    private static final byte[][] HARVESTER = new byte[][]{{0}, {1, 0}, {2, 1, 0}, {3, 2, 1, 0}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 1, 0}, {6}, {7, 6}, {8, 7, 6}, {9, 8, 7, 6}, {10, 9, 8, 7, 6}, {11, 10, 9, 8, 7, 6}};
    private static final byte[][] REAPER = new byte[][]{{-1, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    protected static final long[][] COEFFICIENTS = new long[][]{{48L, 1176L, 19600L, 249900L, 2598960L, 22957480L, 177100560L, 1217566350L, 7575968400L, 43183019880L, 227692286640L, 1119487075980L, 5166863427600L}, {47L, 1128L, 18424L, 230300L, 2349060L, 20358520L, 154143080L, 1040465790L, 6358402050L, 35607051480L, 184509266760L, 891794789340L, 4047376351620L}, {46L, 1081L, 17296L, 211876L, 2118760L, 18009460L, 133784560L, 886322710L, 5317936260L, 29248649430L, 148902215280L, 707285522580L, 3155581562280L}, {45L, 1035L, 16215L, 194580L, 1906884L, 15890700L, 115775100L, 752538150L, 4431613550L, 23930713170L, 119653565850L, 558383307300L, 2448296039700L}, {44L, 990L, 15180L, 178365L, 1712304L, 13983816L, 99884400L, 636763050L, 3679075400L, 19499099620L, 95722852680L, 438729741450L, 1889912732400L}, {43L, 946L, 14190L, 163185L, 1533939L, 12271512L, 85900584L, 536878650L, 3042312350L, 15820024220L, 76223753060L, 343006888770L, 1451182990950L}, {42L, 903L, 13244L, 148995L, 1370754L, 10737573L, 73629072L, 450978066L, 2505433700L, 12777711870L, 60403728840L, 266783135710L, 1108176102180L}, {41L, 861L, 12341L, 135751L, 1221759L, 9366819L, 62891499L, 377348994L, 2054455634L, 10272278170L, 47626016970L, 206379406870L, 841392966470L}, {40L, 820L, 11480L, 123410L, 1086008L, 8145060L, 53524680L, 314457495L, 1677106640L, 8217822536L, 37353738800L, 158753389900L, 635013559600L}, {39L, 780L, 10660L, 111930L, 962598L, 0x6BB66CL, 45379620L, 260932815L, 1362649145L, 6540715896L, 29135916264L, 121399651100L, 476260169700L}, {38L, 741L, 9880L, 101270L, 850668L, 6096454L, 38320568L, 215553195L, 1101716330L, 5178066751L, 22595200368L, 92263734836L, 354860518600L}, {37L, 703L, 9139L, 91390L, 749398L, 5245786L, 32224114L, 177232627L, 886163135L, 4076350421L, 17417133617L, 69668534468L, 262596783764L}, {36L, 666L, 8436L, 82251L, 658008L, 4496388L, 26978328L, 145008513L, 708930508L, 3190187286L, 13340783196L, 52251400851L, 192928249296L}, {35L, 630L, 7770L, 73815L, 575757L, 3838380L, 22481940L, 118030185L, 563921995L, 2481256778L, 10150595910L, 38910617655L, 140676848445L}, {34L, 595L, 7140L, 66045L, 501942L, 3262623L, 18643560L, 95548245L, 445891810L, 1917334783L, 7669339132L, 28760021745L, 101766230790L}, {33L, 561L, 6545L, 58905L, 435897L, 2760681L, 15380937L, 76904685L, 350343565L, 1471442973L, 5752004349L, 21090682613L, 73006209045L}, {32L, 528L, 5984L, 52360L, 376992L, 2324784L, 12620256L, 61523748L, 273438880L, 1121099408L, 4280561376L, 15338678264L, 51915526432L}, {31L, 496L, 5456L, 46376L, 324632L, 1947792L, 10295472L, 48903492L, 211915132L, 847660528L, 3159461968L, 11058116888L, 36576848168L}, {30L, 465L, 4960L, 40920L, 278256L, 1623160L, 8347680L, 38608020L, 163011640L, 635745396L, 2311801440L, 7898654920L, 25518731280L}, {29L, 435L, 4495L, 35960L, 237336L, 1344904L, 6724520L, 30260340L, 124403620L, 472733756L, 1676056044L, 5586853480L, 17620076360L}, {28L, 406L, 4060L, 31465L, 201376L, 1107568L, 5379616L, 23535820L, 94143280L, 348330136L, 1203322288L, 3910797436L, 12033222880L}, {27L, 378L, 3654L, 27405L, 169911L, 906192L, 4272048L, 18156204L, 70607460L, 254186856L, 854992152L, 2707475148L, 8122425444L}, {26L, 351L, 3276L, 23751L, 142506L, 736281L, 3365856L, 13884156L, 52451256L, 183579396L, 600805296L, 1852482996L, 5414950296L}, {25L, 325L, 2925L, 20475L, 118755L, 593775L, 2629575L, 10518300L, 38567100L, 131128140L, 417225900L, 1251677700L, 3562467300L}, {24L, 300L, 2600L, 17550L, 98280L, 475020L, 2035800L, 7888725L, 28048800L, 92561040L, 286097760L, 834451800L, 2310789600L}, {23L, 276L, 2300L, 14950L, 80730L, 376740L, 1560780L, 5852925L, 20160075L, 64512240L, 193536720L, 548354040L, 1476337800L}, {22L, 253L, 2024L, 12650L, 65780L, 296010L, 0x121128L, 4292145L, 14307150L, 44352165L, 129024480L, 354817320L, 927983760L}, {21L, 231L, 1771L, 10626L, 53130L, 230230L, 888030L, 3108105L, 10015005L, 30045015L, 84672315L, 225792840L, 573166440L}, {20L, 210L, 1540L, 8855L, 42504L, 177100L, 657800L, 2220075L, 6906900L, 20030010L, 54627300L, 141120525L, 347373600L}, {19L, 190L, 1330L, 7315L, 33649L, 134596L, 480700L, 1562275L, 4686825L, 13123110L, 34597290L, 86493225L, 206253075L}, {18L, 171L, 1140L, 5985L, 26334L, 100947L, 346104L, 1081575L, 3124550L, 8436285L, 21474180L, 51895935L, 119759850L}, {17L, 153L, 969L, 4845L, 20349L, 74613L, 245157L, 735471L, 2042975L, 5311735L, 13037895L, 30421755L, 67863915L}, {16L, 136L, 816L, 3876L, 15504L, 54264L, 170544L, 490314L, 1307504L, 3268760L, 7726160L, 17383860L, 37442160L}, {15L, 120L, 680L, 3060L, 11628L, 38760L, 116280L, 319770L, 817190L, 1961256L, 4457400L, 9657700L, 20058300L}, {14L, 105L, 560L, 2380L, 8568L, 27132L, 77520L, 203490L, 497420L, 1144066L, 2496144L, 5200300L, 10400600L}, {13L, 91L, 455L, 1820L, 6188L, 18564L, 50388L, 125970L, 293930L, 646646L, 1352078L, 2704156L, 5200300L}, {12L, 78L, 364L, 1365L, 4368L, 12376L, 31824L, 75582L, 167960L, 352716L, 705432L, 1352078L, 2496144L}, {11L, 66L, 286L, 1001L, 3003L, 8008L, 19448L, 43758L, 92378L, 184756L, 352716L, 646646L, 1144066L}, {10L, 55L, 220L, 715L, 2002L, 5005L, 11440L, 24310L, 48620L, 92378L, 167960L, 293930L, 497420L}, {9L, 45L, 165L, 495L, 1287L, 3003L, 6435L, 12870L, 24310L, 43758L, 75582L, 125970L, 203490L}, {8L, 36L, 120L, 330L, 792L, 1716L, 3432L, 6435L, 11440L, 19448L, 31824L, 50388L, 77520L}, {7L, 28L, 84L, 210L, 462L, 924L, 1716L, 3003L, 5005L, 8008L, 12376L, 18564L, 27132L}, {6L, 21L, 56L, 126L, 252L, 462L, 792L, 1287L, 2002L, 3003L, 4368L, 6188L, 8568L}, {5L, 15L, 35L, 70L, 126L, 210L, 330L, 495L, 715L, 1001L, 1365L, 1820L, 2380L}, {4L, 10L, 20L, 35L, 56L, 84L, 120L, 165L, 220L, 286L, 364L, 455L, 560L}, {3L, 6L, 10L, 15L, 21L, 28L, 36L, 45L, 55L, 66L, 78L, 91L, 105L}, {2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}};

    public OwareGame() {
        this(254);
    }

    public OwareGame(int n) {
        this.capacity = n;
        this.history = new byte[n << 4];
        this.moves = new byte[n];
        this.hashes = new long[n];
        this.captures = new int[n];
        this.position = new byte[16];
        this.setStart(START_POSITION, 1);
    }

    @Override
    public void setStart(Object object, int n) {
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException("Game turn is not a valid");
        }
        byte[] byArray = (byte[])object;
        if (!OwareGame.isPosition(byArray)) {
            throw new IllegalArgumentException("Position representation is not valid");
        }
        this.setStart(byArray, n);
    }

    private void setStart(byte[] byArray, int n) {
        this.index = -1;
        this.move = (byte)-1;
        this.capture = -1;
        this.captureIndex = 0;
        this.turn = n;
        this.status = 0;
        this.position[14] = this.house = (byte)(n == 1 ? 6 : 12);
        this.position[15] = this.status;
        System.arraycopy(byArray, 0, this.position, 0, 14);
        this.hash = this.computeHash();
    }

    private static boolean isPosition(byte[] byArray) {
        if (byArray == null || byArray.length != 14) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < 14; ++i) {
            if (byArray[i] < 0) {
                return false;
            }
            n += byArray[i];
        }
        return n == 48;
    }

    @Override
    public int length() {
        return this.index + 1;
    }

    @Override
    public int[] moves() {
        if (this.index == -1) {
            return null;
        }
        int n = 1 + this.index;
        int[] nArray = new int[n];
        for (int i = 0; i < this.index; ++i) {
            nArray[i] = this.moves[1 + i];
        }
        nArray[this.index] = this.move;
        return nArray;
    }

    @Override
    public int turn() {
        return this.turn;
    }

    public byte[] position() {
        byte[] byArray = new byte[14];
        System.arraycopy(this.position, 0, byArray, 0, 14);
        return byArray;
    }

    protected byte[] gameState() {
        return this.position;
    }

    public byte southStore() {
        return this.position[12];
    }

    public byte northStore() {
        return this.position[13];
    }

    @Override
    public void endMatch() {
        int n;
        if (this.position[12] > 24 || this.position[13] > 24) {
            return;
        }
        if (this.position[12] == 24 && this.position[13] == 24) {
            return;
        }
        ++this.index;
        this.moves[this.index] = this.move;
        this.position[14] = this.house;
        this.position[15] = this.status;
        System.arraycopy(this.position, 0, this.history, this.index << 4, 16);
        this.hashes[this.index] = this.hash;
        this.move = (byte)-1;
        this.status = (byte)4;
        this.house = (byte)-1;
        for (n = 0; n < 6; ++n) {
            this.position[12] = (byte)(this.position[12] + this.position[n]);
        }
        for (n = 6; n < 12; ++n) {
            this.position[13] = (byte)(this.position[13] + this.position[n]);
        }
        System.arraycopy(EMPTY_POSITION, 0, this.position, 0, 12);
        this.hash = this.computeHash();
    }

    @Override
    public boolean hasEnded() {
        if (this.position[12] > 24 || this.position[13] > 24) {
            return true;
        }
        return this.isRepetition() || !this.hasLegalMoves();
    }

    @Override
    public int winner() {
        byte by;
        if (this.position[12] > 24) {
            return 1;
        }
        if (this.position[13] > 24) {
            return -1;
        }
        if (this.position[12] == 24 && this.position[13] == 24) {
            return 0;
        }
        if (this.hasLegalMoves()) {
            return 0;
        }
        byte by2 = this.position[12];
        for (by = 0; by < 6; ++by) {
            by2 = (byte)(by2 + this.position[by]);
        }
        by = this.position[13];
        for (int i = 6; i < 12; ++i) {
            by = (byte)(by + this.position[i]);
        }
        if (by2 == by) {
            return 0;
        }
        return by2 > by ? 1 : -1;
    }

    @Override
    public int score() {
        byte by;
        int n;
        int n2 = 25 * (this.position[12] - this.position[13]);
        for (n = 0; n < 6; ++n) {
            by = this.position[n];
            if (by > 12) {
                n2 += 28;
                continue;
            }
            if (by == 0) {
                n2 -= 54;
                continue;
            }
            if (by >= 3) continue;
            n2 -= 36;
        }
        for (n = 6; n < 12; ++n) {
            by = this.position[n];
            if (by > 12) {
                n2 -= 28;
                continue;
            }
            if (by == 0) {
                n2 += 54;
                continue;
            }
            if (by >= 3) continue;
            n2 += 36;
        }
        return n2;
    }

    @Override
    public int outcome() {
        if (this.position[12] > 24) {
            return 1000;
        }
        if (this.position[13] > 24) {
            return -1000;
        }
        int n = this.position[12];
        for (int i = 0; i < 6; ++i) {
            n += this.position[i];
        }
        if (n > 24) {
            return 1000;
        }
        if (n < 24) {
            return -1000;
        }
        return 0;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    private long computeHash() {
        long l = this.turn == 1 ? 0x80000000000L : 0L;
        int n = this.position[13];
        for (int i = 12; n < 48 && i >= 0; n += this.position[i], --i) {
            l += COEFFICIENTS[n][i];
        }
        return l;
    }

    @Override
    public boolean isLegal(int n) {
        int[] nArray = this.legalMoves();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasLegalMoves() {
        if (this.turn == 1) {
            for (int i = 5; i >= 0; --i) {
                int n;
                if (this.position[i] == 0) continue;
                for (n = 11; n > 5; --n) {
                    if (this.position[n] == 0) continue;
                    return true;
                }
                for (n = i; n >= 0; --n) {
                    if (this.position[n] <= 5 - n) continue;
                    return true;
                }
                break;
            }
        } else {
            for (int i = 11; i > 5; --i) {
                int n;
                if (this.position[i] == 0) continue;
                for (n = 5; n >= 0; --n) {
                    if (this.position[n] == 0) continue;
                    return true;
                }
                for (n = i; n > 5; --n) {
                    if (this.position[n] <= 11 - n) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public boolean isRepetition() {
        for (int i = this.index - 11; i > this.capture; i -= 2) {
            if (this.hashes[i] != this.hash) continue;
            return true;
        }
        return false;
    }

    public boolean isCapture(int n) {
        block20: {
            byte by;
            byte by2;
            int n2;
            block21: {
                block19: {
                    n2 = REAPER[n][this.position[n]];
                    if (n2 == -1 || this.position[n2] > 2) {
                        return false;
                    }
                    by2 = this.position[n];
                    by = this.position[n2];
                    if (by2 >= 12 || by <= 0) break block19;
                    if (n < 6) {
                        int n3;
                        for (n3 = 11; n3 > n2; --n3) {
                            if (this.position[n3] == 0) continue;
                            return true;
                        }
                        for (n3 = n2 - 1; n3 > 5; --n3) {
                            if (this.position[n3] != 0 && this.position[n3] <= 2) continue;
                            return true;
                        }
                    } else {
                        int n4;
                        for (n4 = 5; n4 > n2; --n4) {
                            if (this.position[n4] == 0) continue;
                            return true;
                        }
                        for (n4 = n2 - 1; n4 >= 0; --n4) {
                            if (this.position[n4] != 0 && this.position[n4] <= 2) continue;
                            return true;
                        }
                    }
                    break block20;
                }
                if (by2 <= 11 || by2 >= 23 || by >= 2) break block21;
                if (n < 6) {
                    if (n2 < 11) {
                        return true;
                    }
                    for (int i = 10; i > 5; --i) {
                        if (this.position[i] <= 1) continue;
                        return true;
                    }
                } else {
                    if (n2 < 5) {
                        return true;
                    }
                    for (int i = 4; i >= 0; --i) {
                        if (this.position[i] <= 1) continue;
                        return true;
                    }
                }
                break block20;
            }
            if (by2 <= 22 || by != 0) break block20;
            if (n < 6) {
                if (n2 < 11) {
                    return true;
                }
                for (int i = 10; i > 5; --i) {
                    if (this.position[i] == 0) continue;
                    return true;
                }
            } else {
                if (n2 < 5) {
                    return true;
                }
                for (int i = 4; i >= 0; --i) {
                    if (this.position[i] == 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean wasCapture() {
        return this.capture == this.index;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void makeMove(int n) {
        ++this.index;
        this.moves[this.index] = this.move;
        this.position[14] = this.house;
        this.position[15] = this.status;
        System.arraycopy(this.position, 0, this.history, this.index << 4, 16);
        this.hashes[this.index] = this.hash;
        this.move = (byte)n;
        this.status = 0;
        this.house = (byte)(this.turn == -1 ? 6 : 12);
        int n2 = n;
        int n3 = this.position[n];
        while (n3 > 0) {
            ++n2;
            if ((n2 %= 12) == n) continue;
            int n4 = n2;
            this.position[n4] = (byte)(this.position[n4] + 1);
            --n3;
        }
        this.position[n] = 0;
        this.turn = -this.turn;
        if (this.position[n2] > 3 || this.position[n2] < 2) {
            this.hash = this.computeHash();
            return;
        }
        if (n < 6 && n2 > 5) {
            byte by;
            void var7_16;
            for (byte n5 : NORTH_HOUSES) {
                if (n5 <= n2 ? this.position[n5] > 3 || this.position[n5] < 2 : this.position[n5] != 0) break;
                if (n5 != 6) continue;
                this.hash = this.computeHash();
                return;
            }
            byte by2 = this.position[12];
            byte[] byArray = HARVESTER[n2];
            int n5 = byArray.length;
            boolean n6 = false;
            while (var7_16 < n5 && this.position[by = byArray[var7_16]] <= 3 && this.position[by] >= 2) {
                by2 = (byte)(by2 + this.position[by]);
                this.position[by] = 0;
                ++var7_16;
            }
            this.position[12] = by2;
            ++this.captureIndex;
            this.captures[this.captureIndex] = this.capture;
            this.capture = this.index;
        } else if (n > 5 && n2 < 6) {
            byte by;
            void var7_19;
            for (byte by3 : SOUTH_HOUSES) {
                if (by3 <= n2 ? this.position[by3] > 3 || this.position[by3] < 2 : this.position[by3] != 0) break;
                if (by3 != 0) continue;
                this.hash = this.computeHash();
                return;
            }
            byte by4 = this.position[13];
            byte[] byArray = HARVESTER[n2];
            int n6 = byArray.length;
            boolean bl = false;
            while (var7_19 < n6 && this.position[by = byArray[var7_19]] <= 3 && this.position[by] >= 2) {
                by4 = (byte)(by4 + this.position[by]);
                this.position[by] = 0;
                ++var7_19;
            }
            this.position[13] = by4;
            ++this.captureIndex;
            this.captures[this.captureIndex] = this.capture;
            this.capture = this.index;
        }
        this.hash = this.computeHash();
    }

    @Override
    public void unmakeMove() {
        System.arraycopy(this.history, this.index << 4, this.position, 0, 16);
        this.move = this.moves[this.index];
        this.hash = this.hashes[this.index];
        this.house = this.position[14];
        this.status = this.position[15];
        this.turn = -this.turn;
        --this.index;
        if (this.capture > this.index) {
            this.capture = this.captures[this.captureIndex];
            --this.captureIndex;
        }
    }

    @Override
    public int nextMove() {
        if (this.turn == 1) {
            return this.nextMoveSouth();
        }
        return this.nextMoveNorth();
    }

    private byte nextMoveSouth() {
        if (this.status == 0) {
            while (this.house > 0) {
                this.house = (byte)(this.house - 1);
                if (this.position[this.house] <= 0 || this.position[this.house] <= 5 - this.house || !this.isCapture(this.house)) continue;
                return this.house;
            }
            this.status = 1;
            this.house = (byte)6;
            for (byte by : NORTH_HOUSES) {
                if (this.position[by] == 0) continue;
                this.status = (byte)2;
                break;
            }
        }
        switch (this.status) {
            case 1: {
                while (this.house > 0) {
                    this.house = (byte)(this.house - 1);
                    if (this.position[this.house] <= 0 || this.position[this.house] <= 5 - this.house || this.isCapture(this.house)) continue;
                    return this.house;
                }
                this.status = (byte)4;
                break;
            }
            case 2: {
                while (this.house > 0) {
                    this.house = (byte)(this.house - 1);
                    if (this.position[this.house] <= 0 || this.position[this.house] >= 3 || this.isCapture(this.house)) continue;
                    return this.house;
                }
                this.status = (byte)3;
                this.house = (byte)6;
            }
            case 3: {
                while (this.house > 0) {
                    this.house = (byte)(this.house - 1);
                    if (this.position[this.house] <= 2 || this.isCapture(this.house)) continue;
                    return this.house;
                }
                this.status = (byte)4;
            }
        }
        return -1;
    }

    private byte nextMoveNorth() {
        if (this.status == 0) {
            while (this.house > 6) {
                this.house = (byte)(this.house - 1);
                if (this.position[this.house] <= 0 || this.position[this.house] <= 11 - this.house || !this.isCapture(this.house)) continue;
                return this.house;
            }
            this.status = 1;
            this.house = (byte)12;
            for (byte by : SOUTH_HOUSES) {
                if (this.position[by] == 0) continue;
                this.status = (byte)2;
                break;
            }
        }
        switch (this.status) {
            case 1: {
                while (this.house > 6) {
                    this.house = (byte)(this.house - 1);
                    if (this.position[this.house] <= 0 || this.position[this.house] <= 11 - this.house || this.isCapture(this.house)) continue;
                    return this.house;
                }
                this.status = (byte)4;
                break;
            }
            case 2: {
                while (this.house > 6) {
                    this.house = (byte)(this.house - 1);
                    if (this.position[this.house] <= 0 || this.position[this.house] >= 3 || this.isCapture(this.house)) continue;
                    return this.house;
                }
                this.status = (byte)3;
                this.house = (byte)12;
            }
            case 3: {
                while (this.house > 6) {
                    this.house = (byte)(this.house - 1);
                    if (this.position[this.house] <= 2 || this.isCapture(this.house)) continue;
                    return this.house;
                }
                this.status = (byte)4;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] legalMoves() {
        boolean bl;
        int n = 0;
        if (this.turn == 1) {
            void var5_14;
            for (int n2 : SOUTH_HOUSES) {
                if (this.position[n2] <= 0 || this.position[n2] <= 5 - n2 || !this.isCapture(n2)) continue;
                this.legal[n++] = n2;
            }
            bl = true;
            byte[] byArray = NORTH_HOUSES;
            int n2 = byArray.length;
            boolean n4 = false;
            while (var5_14 < n2) {
                byte by = byArray[var5_14];
                if (this.position[by] != 0) {
                    bl = false;
                    break;
                }
                ++var5_14;
            }
            if (bl) {
                void var5_16;
                byArray = SOUTH_HOUSES;
                n2 = byArray.length;
                boolean bl2 = false;
                while (var5_16 < n2) {
                    int n3 = byArray[var5_16];
                    if (this.position[n3] > 0 && this.position[n3] > 5 - n3 && !this.isCapture(n3)) {
                        this.legal[n++] = n3;
                    }
                    ++var5_16;
                }
            } else {
                void var5_20;
                void var5_18;
                byArray = SOUTH_HOUSES;
                n2 = byArray.length;
                boolean bl3 = false;
                while (var5_18 < n2) {
                    int n5 = byArray[var5_18];
                    if (this.position[n5] > 0 && this.position[n5] < 3 && !this.isCapture(n5)) {
                        this.legal[n++] = n5;
                    }
                    ++var5_18;
                }
                byArray = SOUTH_HOUSES;
                n2 = byArray.length;
                boolean bl4 = false;
                while (var5_20 < n2) {
                    int n6 = byArray[var5_20];
                    if (this.position[n6] > 2 && !this.isCapture(n6)) {
                        this.legal[n++] = n6;
                    }
                    ++var5_20;
                }
            }
        } else {
            void var5_23;
            for (int n7 : NORTH_HOUSES) {
                if (this.position[n7] <= 0 || this.position[n7] <= 11 - n7 || !this.isCapture(n7)) continue;
                this.legal[n++] = n7;
            }
            bl = true;
            byte[] byArray = SOUTH_HOUSES;
            int n8 = byArray.length;
            boolean bl5 = false;
            while (var5_23 < n8) {
                byte by = byArray[var5_23];
                if (this.position[by] != 0) {
                    bl = false;
                    break;
                }
                ++var5_23;
            }
            if (bl) {
                void var5_25;
                byArray = NORTH_HOUSES;
                n8 = byArray.length;
                boolean bl6 = false;
                while (var5_25 < n8) {
                    int n9 = byArray[var5_25];
                    if (this.position[n9] > 0 && this.position[n9] > 11 - n9 && !this.isCapture(n9)) {
                        this.legal[n++] = n9;
                    }
                    ++var5_25;
                }
            } else {
                void var5_29;
                void var5_27;
                byArray = NORTH_HOUSES;
                n8 = byArray.length;
                boolean bl7 = false;
                while (var5_27 < n8) {
                    int n10 = byArray[var5_27];
                    if (this.position[n10] > 0 && this.position[n10] < 3 && !this.isCapture(n10)) {
                        this.legal[n++] = n10;
                    }
                    ++var5_27;
                }
                byArray = NORTH_HOUSES;
                n8 = byArray.length;
                boolean bl8 = false;
                while (var5_29 < n8) {
                    int n11 = byArray[var5_29];
                    if (this.position[n11] > 2 && !this.isCapture(n11)) {
                        this.legal[n++] = n11;
                    }
                    ++var5_29;
                }
            }
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        System.arraycopy(this.legal, 0, nArray, 0, n);
        return nArray;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n <= this.capacity) {
            return;
        }
        if (n > 0x7FFFFFF) {
            throw new IllegalStateException("Requested capacity is above the maximum");
        }
        this.capacity = Math.min(0x7FFFFFF, Math.max(n, this.capacity + 126));
        byte[] byArray = new byte[this.capacity << 4];
        byte[] byArray2 = new byte[this.capacity];
        long[] lArray = new long[this.capacity];
        int[] nArray = new int[this.capacity];
        System.arraycopy(this.history, 0, byArray, 0, this.index + 1 << 4);
        System.arraycopy(this.moves, 0, byArray2, 0, this.index + 1);
        System.arraycopy(this.hashes, 0, lArray, 0, this.index + 1);
        System.arraycopy(this.captures, 0, nArray, 0, this.captureIndex + 1);
        this.history = byArray;
        this.moves = byArray2;
        this.hashes = lArray;
        this.captures = nArray;
        System.gc();
    }
}

