/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.oware;

import com.joansala.engine.Cache;
import com.joansala.engine.Game;

public class OwareCache
implements Cache {
    public static final int SLOT_SIZE = 8;
    public static final int MIN_CAPACITY = 4096;
    public static final int MAX_CAPACITY = 0x40000000;
    private int entries;
    private int capacity;
    private long[] data;
    private byte flag = 0;
    private int move = -1;
    private int depth = 0;
    private int score = 0;
    private long stamp = 0L;
    private long reset = 0x100000000L;

    public OwareCache(long l) {
        int n = this.toCapacity(l);
        this.entries = (n >> 1) - 1;
        this.capacity = n;
        this.data = new long[n];
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public int getMove() {
        return this.move == 15 ? -1 : this.move;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public byte getFlag() {
        return this.flag;
    }

    @Override
    public boolean find(Game game) {
        int n;
        long l = game.hash();
        long l2 = l >>> 12;
        if (l2 == (0xFFFFFFFFL & this.data[n = (int)((l & (long)this.entries) << 1)]) || l2 == (0xFFFFFFFFL & this.data[++n])) {
            long l3 = this.data[n];
            this.move = (int)(l3 >>> 35 & 0xFL);
            this.flag = (byte)(l3 >>> 39 & 3L);
            this.depth = (int)(l3 >>> 41 & 0x7FL);
            this.score = (int)(l3 >> 52);
            return true;
        }
        return false;
    }

    @Override
    public void store(Game game, int n, int n2, int n3, byte by) {
        long l = game.hash();
        int n4 = (int)((l & (long)this.entries) << 1);
        if ((long)n3 <= (this.data[n4] >> 41 & 0x7FL) && this.reset != (this.data[n4] & 0x300000000L)) {
            ++n4;
        }
        this.data[n4] = (long)n << 52 | (long)n3 << 41 | (long)by << 39 | (long)(n2 & 0xF) << 35 | this.stamp | l >>> 12;
    }

    @Override
    public void discharge() {
        this.stamp = this.stamp + 0x100000000L & 0x300000000L;
        this.reset = this.reset + 0x100000000L & 0x300000000L;
    }

    @Override
    public void resize(long l) {
        int n = this.toCapacity(l);
        if (n == this.capacity) {
            return;
        }
        this.entries = (n >> 1) - 1;
        this.capacity = n;
        this.clear();
    }

    @Override
    public void clear() {
        this.score = 0;
        this.depth = 0;
        this.flag = 0;
        this.move = -1;
        this.data = null;
        System.gc();
        this.data = new long[this.capacity];
    }

    @Override
    public long size() {
        return this.capacity * 8;
    }

    private int toCapacity(long l) {
        if (l > 0x200000000L) {
            l = 0x200000000L;
        }
        int n = (int)(l / 8L);
        n = (int)Math.pow(2.0, (int)(Math.log(n) / Math.log(2.0)));
        return Math.max(4096, n);
    }
}

