/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.oware;

import com.joansala.engine.Board;
import com.joansala.engine.Game;
import com.joansala.oware.OwareGame;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OwareBoard
implements Board {
    private static Pattern boardPattern = Pattern.compile("((?:[1-4]?[0-9]-){14})(S|N)");
    private static Pattern movesPattern = Pattern.compile("([A-F]([a-f][A-F])*[a-f]?)|([a-f]([A-F][a-f])*[A-F]?)");
    private byte[] position;
    private int turn;

    public OwareBoard() {
        this.turn = 1;
        this.position = OwareBoard.startPosition();
    }

    public OwareBoard(long l) {
        this.turn = (l & 0x80000000000L) > 0L ? 1 : -1;
        this.position = OwareBoard.unrankPosition(l & 0x7FFFFFFFFFFL);
    }

    public OwareBoard(byte[] byArray, int n) {
        if (!OwareBoard.isValidTurn(n)) {
            throw new IllegalArgumentException("Game turn is not a valid");
        }
        if (!OwareBoard.isValidPosition(byArray)) {
            throw new IllegalArgumentException("Position representation is not valid");
        }
        this.turn = n;
        this.position = Arrays.copyOf(byArray, byArray.length);
    }

    public byte[] position() {
        return Arrays.copyOf(this.position, this.position.length);
    }

    @Override
    public int turn() {
        return this.turn;
    }

    private static boolean isValidTurn(int n) {
        return n == 1 || n == -1;
    }

    private static boolean isValidPosition(byte[] byArray) {
        if (byArray == null || byArray.length != 14) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < 14; ++i) {
            if (byArray[i] < 0) {
                return false;
            }
            n += byArray[i];
        }
        return n == 48;
    }

    private static byte[] startPosition() {
        byte[] byArray = new byte[14];
        System.arraycopy(OwareGame.START_POSITION, 0, byArray, 0, 14);
        return byArray;
    }

    public static long rankPosition(byte[] byArray) {
        if (!OwareBoard.isValidPosition(byArray)) {
            throw new IllegalArgumentException("Position representation is not valid");
        }
        long l = 0L;
        int n = byArray[13];
        for (int i = 12; n < 48 && i >= 0; n += byArray[i], --i) {
            l += OwareGame.COEFFICIENTS[n][i];
        }
        return l;
    }

    public static byte[] unrankPosition(long l) {
        byte[] byArray = new byte[14];
        int n = 12;
        int n2 = 0;
        int n3 = 0;
        while (n >= 0 && n2 < 48) {
            long l2 = OwareGame.COEFFICIENTS[n2][n];
            if (l >= l2) {
                l -= l2;
                byArray[n + 1] = n3;
                n3 = 0;
                --n;
                continue;
            }
            n3 = (byte)(n3 + 1);
            ++n2;
        }
        byArray[n + 1] = (byte)(48 - n2 + n3);
        return byArray;
    }

    @Override
    public OwareBoard toBoard(Game game) {
        if (!(game instanceof OwareGame)) {
            throw new IllegalArgumentException("Not a valid game object");
        }
        return new OwareBoard((byte[])game.position(), game.turn());
    }

    @Override
    public OwareBoard toBoard(String string) {
        Matcher matcher = boardPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Position notation is not valid");
        }
        int n = 1;
        byte[] byArray = new byte[14];
        if ("N".equals(matcher.group(2))) {
            n = -1;
        }
        String[] stringArray = matcher.group(1).split("-");
        for (int i = 0; i < 14; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        return new OwareBoard(byArray, n);
    }

    @Override
    public String toNotation() {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : this.position) {
            stringBuilder.append(by);
            stringBuilder.append('-');
        }
        stringBuilder.append(this.turn == 1 ? (char)'S' : 'N');
        return stringBuilder.toString();
    }

    @Override
    public String toAlgebraic(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(OwareBoard.toCharacter(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toAlgebraic(int n) {
        return String.valueOf(OwareBoard.toCharacter(n));
    }

    private static char toCharacter(int n) {
        if (n < 0 || n > 11) {
            throw new IllegalArgumentException("Not a valid move representation");
        }
        return (char)(n < 6 ? n + 65 : n + 91);
    }

    @Override
    public int[] toMoves(String string) {
        Matcher matcher = movesPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Moves notation is not valid");
        }
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            nArray[i] = OwareBoard.toMove(c);
        }
        return nArray;
    }

    @Override
    public int toMove(String string) {
        if (string.length() != 1) {
            throw new IllegalArgumentException("Not a valid move notation");
        }
        return OwareBoard.toMove(string.charAt(0));
    }

    private static int toMove(char c) {
        int n = -1;
        if (c > '`' && c < 'g') {
            n = (byte)(c - 91);
        } else if (c > '@' && c < 'G') {
            n = (byte)(c - 65);
        } else {
            throw new IllegalArgumentException("Not a valid move notation");
        }
        return n;
    }

    public long hash() {
        long l = this.turn == 1 ? 0x80000000000L : 0L;
        int n = this.position[13];
        for (int i = 12; n < 48 && i >= 0; n += this.position[i], --i) {
            l += OwareGame.COEFFICIENTS[n][i];
        }
        return l;
    }

    public int hashCode() {
        return Arrays.hashCode(this.position) * this.turn;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OwareBoard)) {
            return false;
        }
        OwareBoard owareBoard = (OwareBoard)object;
        return owareBoard.turn == this.turn && Arrays.equals(owareBoard.position, this.position);
    }

    @Override
    public String toString() {
        return String.format("+----+----+----+----+----+----+----+----+%n|    | %2d | %2d | %2d | %2d | %2d | %2d |    |%n| %2d +----+----+----+----+----+----+ %2d +%n|    | %2d | %2d | %2d | %2d | %2d | %2d |    |%n+----+----+----+----+----+----+----+----+%n%s to move", this.position[11], this.position[10], this.position[9], this.position[8], this.position[7], this.position[6], this.position[13], this.position[12], this.position[0], this.position[1], this.position[2], this.position[3], this.position[4], this.position[5], this.turn == 1 ? "South" : "North");
    }
}

