/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.engine;

import com.joansala.engine.UCIClient;
import java.io.Console;
import java.io.PrintWriter;

public class UCIShell {
    private static UCIClient client;
    private static Console console;
    private static PrintWriter writer;

    public UCIShell(UCIClient uCIClient) {
        console = System.console();
        writer = console.writer();
        client = uCIClient;
    }

    private void showWelcome() {
        Package package_ = UCIShell.class.getPackage();
        String string = package_.getImplementationVersion();
        writer.format("UCI Protocol Shell, version %s%nType UCI commands to send them to the engine.%n%n", string);
    }

    public void start() {
        Object object = null;
        this.showWelcome();
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "user";
        }
        if (client.isRunning()) {
            object = client.getBoard();
            writer.println(object);
            writer.println();
        }
        while (client.isRunning()) {
            try {
                String string2;
                Object object2;
                String string3 = console.readLine("%s> ", string);
                if (string3 == null) {
                    writer.println();
                    continue;
                }
                if (string3.trim().isEmpty()) continue;
                client.send(string3);
                if (!client.isRunning()) break;
                while (!client.isUCIReady()) {
                    object2 = client.receive();
                    writer.format("< %s%n", object2);
                }
                while (!client.isReady()) {
                    object2 = client.receive();
                    writer.format("< %s%n", object2);
                }
                object2 = client.getBoard();
                if (!object2.equals(object)) {
                    object = object2;
                    writer.println();
                    writer.println(object);
                    writer.println();
                }
                if (!client.hasTimeLimit()) continue;
                while (client.isPondering()) {
                    string2 = client.receive();
                    writer.format("< %s%n", string2);
                }
                while (client.isThinking()) {
                    string2 = client.receive();
                    writer.format("< %s%n", string2);
                }
            }
            catch (Exception exception) {
                writer.format("%s%n", exception.getMessage());
            }
        }
    }
}

