/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.engine;

import com.joansala.engine.Board;
import com.joansala.engine.Cache;
import com.joansala.engine.Engine;
import com.joansala.engine.Game;
import com.joansala.engine.Roots;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.regex.Pattern;

public class UCIService {
    public static final long DEFAULT_TIME = 2000L;
    private Brain brain = null;
    private Engine engine = null;
    private Roots roots = null;
    private Cache cache = null;
    private Game game = null;
    private Board board = null;
    private Board start = null;
    private int[] moves = null;
    private int minHashSize = 1;
    private int maxHashSize = 1;
    private int currentHashSize = this.minHashSize;
    private int requestedHashSize = this.minHashSize;
    private int contempt = 0;
    private boolean debug = false;
    private volatile boolean drawSearch = false;
    private volatile boolean ownBook = true;
    private volatile boolean infinite = false;
    private volatile boolean ponder = false;

    public UCIService(Board board, Game game, Engine engine) {
        this.start = board;
        this.game = game;
        this.engine = engine;
    }

    public synchronized void setContempt(int n) {
        this.contempt = n;
    }

    public synchronized void setCache(Cache cache) {
        this.cache = cache;
    }

    public synchronized void setRoots(Roots roots) {
        this.roots = roots;
    }

    public synchronized void start() {
        Scanner scanner = new Scanner(System.in);
        this.brain = new Brain();
        this.brain.start();
        if (this.cache != null) {
            long l = Runtime.getRuntime().freeMemory();
            long l2 = this.cache.size();
            this.maxHashSize = (int)(l2 + l >> 20);
            this.requestedHashSize = this.currentHashSize = (int)(l2 >> 20);
        }
        while (scanner.hasNext()) {
            String string = scanner.next();
            String string2 = scanner.nextLine();
            if (this.debug) {
                UCIService.printString("Command: " + string);
                if (!string2.equals("")) {
                    UCIService.printString("Options:" + string2);
                }
            }
            if ("debug".equals(string)) {
                this.switchDebugMode(string2);
                continue;
            }
            if ("go".equals(string)) {
                this.startThinking(string2);
                continue;
            }
            if ("isready".equals(string)) {
                this.answerPing();
                continue;
            }
            if ("ponderhit".equals(string)) {
                this.stopPondering();
                continue;
            }
            if ("position".equals(string)) {
                this.setPosition(string2);
                continue;
            }
            if ("quit".equals(string)) {
                this.quitEngine();
                break;
            }
            if ("setoption".equals(string)) {
                this.setOption(string2);
                continue;
            }
            if ("stop".equals(string)) {
                this.stopThinking();
                continue;
            }
            if ("uci".equals(string)) {
                this.identifyEngine();
                continue;
            }
            if ("ucinewgame".equals(string)) {
                this.startNewGame();
                continue;
            }
            this.showError("Unknown command");
        }
        this.brain.interrupt();
        scanner.close();
    }

    private void performMove(Game game, int n) {
        if (!game.isLegal(n)) {
            throw new IllegalArgumentException("The provided move is not legal");
        }
        game.ensureCapacity(1 + game.length());
        game.makeMove(n);
    }

    private void synchBrain() {
        for (int i = 0; this.brain.isThinking() && i < 50; ++i) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void identifyEngine() {
        Package package_ = this.game.getClass().getPackage();
        String string = package_.getImplementationTitle();
        String string2 = package_.getImplementationVersion();
        String string3 = package_.getImplementationVendor();
        UCIService.output("id name " + (string == null ? "Unknown Engine" : string) + " " + (string2 == null ? "" : string2));
        UCIService.output("id author " + (string3 == null ? "Unknown Author" : string3));
        if (this.cache != null) {
            UCIService.output("option name Hash type spin default " + this.currentHashSize + " min " + this.minHashSize + " max " + this.maxHashSize);
        }
        if (this.roots != null) {
            UCIService.output("option name OwnBook type check default true");
        }
        UCIService.output("option name Ponder type check default true");
        UCIService.output("option name DrawSearch type check default false");
        UCIService.output("uciok");
    }

    private void answerPing() {
        UCIService.output("readyok");
    }

    private void switchDebugMode(String string) {
        Scanner scanner = new Scanner(string);
        if (!scanner.hasNext()) {
            boolean bl = this.debug = !this.debug;
        }
        while (scanner.hasNext()) {
            String string2 = scanner.next();
            if (string2.equals("on")) {
                this.debug = true;
                continue;
            }
            if (!string2.equals("off")) continue;
            this.debug = false;
        }
        scanner.close();
    }

    private void startNewGame() {
        this.synchBrain();
        if (this.brain.isThinking()) {
            this.showError("A calculation is in progress");
            return;
        }
        if (this.roots != null) {
            this.roots.newMatch();
        }
        this.engine.newMatch();
    }

    private void quitEngine() {
        this.brain.stopThinking();
        this.brain.interrupt();
    }

    private void startThinking(String string) {
        this.synchBrain();
        if (this.brain.isThinking()) {
            this.showError("Already calculating a move");
            return;
        }
        int n = this.contempt;
        int n2 = Integer.MAX_VALUE;
        long l = 2000L;
        this.infinite = false;
        this.ponder = false;
        Scanner scanner = new Scanner(string);
        while (scanner.hasNext()) {
            String string2 = scanner.next();
            if (string2.equals("depth")) {
                if (!scanner.hasNextByte()) continue;
                n2 = scanner.nextByte();
                continue;
            }
            if (string2.equals("infinite")) {
                this.infinite = true;
                continue;
            }
            if (string2.equals("movetime")) {
                if (!scanner.hasNextLong()) continue;
                l = scanner.nextLong();
                continue;
            }
            if (!string2.equals("ponder")) continue;
            this.ponder = true;
            this.infinite = true;
        }
        scanner.close();
        if (this.infinite) {
            n2 = Integer.MAX_VALUE;
            l = 3600000L;
        }
        if (this.board == null) {
            this.game.setStart(this.start.position(), this.start.turn());
        } else {
            this.game.setStart(this.board.position(), this.board.turn());
        }
        try {
            if (this.moves != null) {
                for (Object object : (String)this.moves) {
                    this.performMove(this.game, (int)object);
                }
            }
        }
        catch (Exception exception) {
            this.showError(exception.getMessage());
            return;
        }
        if (this.drawSearch) {
            n = this.engine.getInfinity();
        }
        this.engine.setDepth(n2 - 1);
        this.engine.setMoveTime(l);
        this.engine.setContempt(n);
        if (this.cache != null && this.currentHashSize != this.requestedHashSize) {
            this.cache.resize(this.requestedHashSize << 20);
            this.currentHashSize = this.requestedHashSize;
        }
        this.brain.startThinking();
    }

    private void stopThinking() {
        this.brain.stopThinking();
    }

    private void stopPondering() {
        this.ponder = false;
    }

    private void setOption(String string) {
        String string2 = null;
        String string3 = null;
        Scanner scanner = new Scanner(string);
        Pattern pattern = Pattern.compile("name|value");
        while (scanner.hasNext()) {
            String string4 = scanner.next();
            if (string4.equals("name")) {
                string2 = UCIService.consumeString(scanner, pattern);
                continue;
            }
            if (!string4.equals("value")) continue;
            string3 = UCIService.consumeString(scanner, pattern);
        }
        scanner.close();
        if (string2 == null) {
            this.showError("No option name specified");
            return;
        }
        if (string2.equals("OwnBook")) {
            if (string3.equals("true")) {
                this.ownBook = true;
            } else if (string3.equals("false")) {
                this.ownBook = false;
            } else {
                this.showError("Invalid value for option OwnBook");
            }
            return;
        }
        if (string2.equals("DrawSearch")) {
            if (string3.equals("true")) {
                this.drawSearch = true;
            } else if (string3.equals("false")) {
                this.drawSearch = false;
            } else {
                this.showError("Invalid value for option DrawSearch");
            }
            return;
        }
        if (string2.equals("Hash") && this.cache != null) {
            try {
                int n = Integer.parseInt(string3);
                if (n >= this.minHashSize && n <= this.maxHashSize) {
                    this.requestedHashSize = n;
                } else {
                    this.showError("Hash size out of range");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showError("Hash size is not a number");
            }
            return;
        }
        this.showError("Cannot set requested option");
    }

    private void setPosition(String string) {
        String string2 = null;
        String string3 = null;
        Scanner scanner = new Scanner(string);
        Pattern pattern = Pattern.compile("startpos|fen|moves");
        while (scanner.hasNext()) {
            String string4 = scanner.next();
            if (string4.equals("fen")) {
                if (!scanner.hasNext()) continue;
                string2 = scanner.next();
                continue;
            }
            if (!string4.equals("moves")) continue;
            string3 = UCIService.consumeString(scanner, pattern);
        }
        scanner.close();
        this.board = null;
        this.moves = null;
        if (string2 != null) {
            try {
                this.board = this.start.toBoard(string2);
            }
            catch (Exception exception) {
                this.showError(exception.getMessage());
                return;
            }
        }
        if (string3 != null) {
            try {
                this.moves = this.start.toMoves(string3);
            }
            catch (Exception exception) {
                this.showError(exception.getMessage());
                return;
            }
        }
    }

    private void showError(String string) {
        if (this.debug) {
            UCIService.printString("Error: " + string);
        }
    }

    private static void printString(String string) {
        UCIService.output("info string " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output(String string) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println(string);
        }
    }

    private static String consumeString(Scanner scanner, Pattern pattern) {
        StringBuilder stringBuilder = new StringBuilder();
        while (scanner.hasNext() && !scanner.hasNext(pattern)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(scanner.next());
        }
        return stringBuilder.toString();
    }

    private class Brain
    extends Thread {
        private volatile boolean thinking = false;

        private Brain() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Brain brain = this;
                synchronized (brain) {
                    try {
                        this.thinking = false;
                        this.wait();
                        this.findBestMove();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        }

        public boolean isThinking() {
            return this.thinking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startThinking() {
            Brain brain = this;
            synchronized (brain) {
                this.thinking = true;
                this.notify();
            }
        }

        public void stopThinking() {
            while (this.isThinking()) {
                UCIService.this.engine.abortComputation();
                UCIService.this.synchBrain();
            }
        }

        private void findBestMove() {
            int n = -1;
            int n2 = -1;
            if (UCIService.this.game.hasEnded()) {
                UCIService.output("bestmove 0000");
                return;
            }
            if (UCIService.this.ownBook && !UCIService.this.infinite) {
                n = this.getBookMove(UCIService.this.game);
            }
            if (n == -1) {
                n = UCIService.this.engine.computeBestMove(UCIService.this.game);
            } else {
                UCIService.output("info string A book move was chosen");
            }
            UCIService.this.performMove(UCIService.this.game, n);
            n2 = this.getPonderMove(UCIService.this.game);
            this.showSearchInfo(UCIService.this.game, n);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bestmove ");
            stringBuilder.append(UCIService.this.start.toAlgebraic(n));
            if (n2 != -1) {
                stringBuilder.append(" ponder ");
                stringBuilder.append(UCIService.this.start.toAlgebraic(n2));
            }
            UCIService.output(stringBuilder.toString());
        }

        private void showSearchInfo(Game game, int n) {
            if (UCIService.this.cache == null || !UCIService.this.cache.find(game)) {
                return;
            }
            int n2 = 0;
            int n3 = UCIService.this.cache.getDepth() + 1;
            int n4 = UCIService.this.cache.getScore();
            int n5 = UCIService.this.cache.getFlag();
            int[] nArray = null;
            int n6 = 0;
            if (Math.abs(n4) == UCIService.this.engine.getInfinity()) {
                n5 = 3;
            }
            if (UCIService.this.cache.getMove() != -1 && n3 > 0 && n5 == 3) {
                nArray = new int[n3 + 2];
                nArray[0] = n;
                nArray[1] = UCIService.this.cache.getMove();
                n6 = 2;
                for (int i = 0; i < n3; ++i) {
                    UCIService.this.performMove(game, UCIService.this.cache.getMove());
                    if (game.hasEnded()) {
                        n2 = game.winner();
                        break;
                    }
                    if (!UCIService.this.cache.find(game) || UCIService.this.cache.getMove() == -1 || UCIService.this.cache.getFlag() != 3 && Math.abs(n4) != UCIService.this.engine.getInfinity()) break;
                    nArray[n6++] = UCIService.this.cache.getMove();
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("info");
            stringBuilder.append(" depth ");
            stringBuilder.append(n3);
            stringBuilder.append(" score cp ");
            stringBuilder.append(-n4);
            if (n2 != 0) {
                int n7 = (int)((double)n6 / 2.0 + 0.5);
                int n8 = n4 > 0 ? -n7 : n7;
                stringBuilder.append(" mate ");
                stringBuilder.append(n8);
            }
            if (n5 == 1) {
                stringBuilder.append(" lowerbound");
            }
            if (n5 == 2) {
                stringBuilder.append(" upperbound");
            }
            if (nArray != null) {
                int[] nArray2 = new int[n6];
                System.arraycopy(nArray, 0, nArray2, 0, n6);
                stringBuilder.append(" pv ");
                stringBuilder.append(UCIService.this.start.toAlgebraic(nArray2));
            }
            UCIService.output(stringBuilder.toString());
        }

        private int getBookMove(Game game) {
            try {
                if (UCIService.this.roots != null) {
                    return UCIService.this.roots.pickBestMove(game);
                }
            }
            catch (IOException iOException) {
                UCIService.this.showError("Cannot select book move");
            }
            return -1;
        }

        private int getPonderMove(Game game) {
            int n = -1;
            if (UCIService.this.cache != null && UCIService.this.cache.find(game) && UCIService.this.cache.getFlag() == 3) {
                n = UCIService.this.cache.getMove();
            }
            if (n == -1 && UCIService.this.ownBook) {
                n = this.getBookMove(game);
            }
            return n;
        }
    }
}

