/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.engine;

import com.joansala.engine.Board;
import com.joansala.engine.Game;
import com.joansala.engine.UCIClient;
import java.io.Console;
import java.io.PrintWriter;
import java.util.Timer;
import java.util.TimerTask;

public final class UCIMatch {
    private Board start = null;
    private Game game = null;
    private UCIClient client;
    private Console console = System.console();
    private PrintWriter writer = this.console.writer();
    private int turn = 1;
    private int movetime = 2000;

    public UCIMatch(UCIClient uCIClient, Board board, Game game) {
        this.client = uCIClient;
        this.start = board;
        this.game = game;
    }

    private void showWelcome() {
        Package package_ = UCIMatch.class.getPackage();
        String string = package_.getImplementationVersion();
        this.writer.format("UCI Command-line Interface, version %s%n", string);
    }

    private void showEngineID() {
        String string = this.client.getName();
        String string2 = this.client.getAuthor();
        this.writer.format("%nYou will be playing with %s;%na game engine authored by %s.%n", string, string2);
    }

    private void initEngine() throws Exception {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                UCIMatch.this.writer.println("The engine is not responding");
                UCIMatch.this.client.getService().destroy();
                System.exit(1);
            }
        }, 16000L);
        this.client.send("uci");
        while (!this.client.isUCIReady()) {
            this.client.receive();
        }
        timer.cancel();
    }

    private void startNewGame() throws Exception {
        this.client.send("ucinewgame");
        this.client.send("isready");
        while (!this.client.isReady()) {
            this.client.receive();
        }
    }

    private void quitEngine() throws Exception {
        this.client.send("quit");
    }

    private int requestUserMove() {
        int n = -1;
        while (n == -1) {
            String string = this.console.readLine("Your move? ", new Object[0]);
            if (string == null) {
                this.writer.println();
                continue;
            }
            if ((string = string.trim()).isEmpty()) continue;
            try {
                n = this.start.toMove(string);
            }
            catch (Exception exception) {
                this.writer.format("%s%n", exception.getMessage());
            }
        }
        return n;
    }

    private int requestEngineMove() {
        int n = -1;
        int n2 = -1;
        try {
            if (this.client.isPondering()) {
                this.client.send("stop");
                while (this.client.isPondering()) {
                    this.client.receive();
                }
            }
            this.client.send(this.getPositionCommand(this.game));
            this.client.send(this.getGoCommand(this.movetime));
            while (this.client.isThinking()) {
                this.client.receive();
            }
            n = this.client.getBestMove();
            n2 = this.client.getPonderMove();
            int n3 = this.game.length();
            try {
                if (n != -1) {
                    this.performMove(this.game, n);
                }
                if (n2 != -1) {
                    this.performMove(this.game, n2);
                }
                this.client.send(this.getPositionCommand(this.game));
                this.client.send("go ponder");
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (n3 < this.game.length()) {
                this.game.unmakeMove();
            }
        }
        catch (Exception exception) {
            this.writer.format("%s%n", exception.getMessage());
        }
        if (n != -1) {
            this.writer.format("My move is: %s%n", this.start.toAlgebraic(n));
        }
        return n;
    }

    private String getPositionCommand(Game game) {
        String string = "position startpos";
        int[] nArray = game.moves();
        if (nArray != null) {
            string = String.format("position startpos moves %s", this.start.toAlgebraic(nArray));
        }
        return string;
    }

    private String getGoCommand(int n) {
        return String.format("go movetime %d", n);
    }

    private void performMove(Game game, int n) {
        if (!game.isLegal(n)) {
            throw new IllegalArgumentException("The provided move is not legal");
        }
        game.ensureCapacity(1 + game.length());
        game.makeMove(n);
    }

    public void start(int n, int n2) {
        try {
            this.turn = n;
            this.movetime = n2;
            this.showWelcome();
            this.initEngine();
            this.showEngineID();
            this.startNewGame();
            while (!this.game.hasEnded()) {
                if (!this.client.isRunning()) {
                    throw new IllegalStateException("The engine is not running");
                }
                this.writer.format("%n%s%n%n", this.start.toBoard(this.game));
                int n3 = n == this.game.turn() ? this.requestUserMove() : this.requestEngineMove();
                try {
                    this.performMove(this.game, n3);
                }
                catch (Exception exception) {
                    this.writer.format("%s%n", exception.getMessage());
                }
            }
            this.game.endMatch();
            this.writer.format("%n%s%n%n", this.start.toBoard(this.game));
            if (n == this.game.winner()) {
                this.writer.println("You won this match!");
            } else if (0 == this.game.winner()) {
                this.writer.println("This match was drawn.");
            } else {
                this.writer.println("You lost this match.");
            }
            this.quitEngine();
        }
        catch (Exception exception) {
            this.writer.format("%s%n", exception.getMessage());
        }
    }
}

