/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.engine;

import com.joansala.engine.Board;
import com.joansala.engine.Game;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UCIClient {
    private static final Pattern pattern = Pattern.compile("^[ \\t]*(\\S+)(?:[ \\t]+(.*))?$");
    private Process service;
    private Game game = null;
    private Board board = null;
    private Board start = null;
    private State state = State.STOPPED;
    private String name = "Unknown";
    private String author = "Unknown";
    private Scanner input = null;
    private PrintStream output = null;
    private int bestMove = -1;
    private int ponderMove = -1;
    private boolean infinite = false;
    private boolean debug = false;
    private boolean ready = false;
    private boolean uciok = true;

    public UCIClient(Process process, Board board, Game game) {
        InputStream inputStream = process.getInputStream();
        OutputStream outputStream = process.getOutputStream();
        this.input = new Scanner(inputStream);
        this.output = new PrintStream(outputStream, true);
        this.service = process;
        this.start = board;
        this.board = board;
        this.game = game;
        this.state = State.WAITING;
        this.ready = true;
        this.uciok = true;
    }

    public Process getService() {
        return this.service;
    }

    public Board getBoard() {
        return this.start.toBoard(this.game);
    }

    public State getState() {
        return this.state;
    }

    public int getBestMove() {
        return this.bestMove;
    }

    public int getPonderMove() {
        return this.ponderMove;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean isDebugOn() {
        return this.debug;
    }

    public boolean hasTimeLimit() {
        return !this.infinite;
    }

    public boolean isThinking() {
        return this.state == State.THINKING;
    }

    public boolean isPondering() {
        return this.state == State.PONDERING;
    }

    public boolean isRunning() {
        return this.state != State.STOPPED;
    }

    public boolean isReady() {
        if (this.state == State.STOPPED) {
            return false;
        }
        return this.ready;
    }

    public boolean isUCIReady() {
        if (this.state == State.STOPPED) {
            return false;
        }
        return this.uciok;
    }

    private void parseUCI(String string) throws Exception {
        this.uciok = false;
    }

    private void parseDebug(String string) throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        if (string != null) {
            Scanner scanner = new Scanner(string);
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                if (string2.equals("on")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (!string2.equals("off")) continue;
                bl = false;
                bl2 = false;
            }
            scanner.close();
        }
        this.debug = bl ? !this.debug : bl2;
    }

    private void parseIsReady(String string) throws Exception {
        this.ready = false;
    }

    private void parseSetOption(String string) throws Exception {
    }

    private void parseRegister(String string) throws Exception {
    }

    private void parseUCINewGame(String string) throws Exception {
        if (this.state != State.WAITING) {
            throw new IllegalStateException("The engine is not waiting for commands");
        }
    }

    private void parsePosition(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        Object var4_4 = null;
        int[] nArray = null;
        if (string == null) {
            throw new IllegalArgumentException("No parameters were provided");
        }
        Scanner scanner = new Scanner(string);
        Pattern pattern = Pattern.compile("startpos|fen|moves");
        while (scanner.hasNext()) {
            String string4 = scanner.next();
            if ("startpos".equals(string4)) {
                string2 = "startpos";
                continue;
            }
            if ("fen".equals(string4)) {
                if (!scanner.hasNext()) continue;
                string2 = scanner.next();
                continue;
            }
            if (!"moves".equals(string4)) continue;
            string3 = UCIClient.consumeString(scanner, pattern);
        }
        scanner.close();
        if (string2 == null) {
            throw new IllegalArgumentException("No position was provided");
        }
        this.board = "startpos".equals(string2) ? this.start : this.start.toBoard(string2);
        this.game.setStart(this.board.position(), this.board.turn());
        if (string3 != null) {
            nArray = this.start.toMoves(string3);
        }
        if (nArray == null) {
            return;
        }
        int n = 0;
        this.game.ensureCapacity(nArray.length);
        for (int n2 : nArray) {
            if (!this.game.isLegal(n2)) {
                for (int i = 0; i < n; ++i) {
                    this.game.unmakeMove();
                }
                throw new IllegalArgumentException("The provided moves are not legal");
            }
            this.game.makeMove(n2);
            ++n;
        }
    }

    private void parseGo(String string) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (this.state != State.WAITING) {
            throw new IllegalStateException("The engine is already thinking");
        }
        if (string != null) {
            Scanner scanner = new Scanner(string);
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                if ("infinite".equals(string2)) {
                    bl = true;
                    continue;
                }
                if (!"ponder".equals(string2)) continue;
                bl2 = true;
                bl = true;
            }
            scanner.close();
        }
        this.state = bl2 ? State.PONDERING : State.THINKING;
        this.infinite = bl;
    }

    private void parseStop(String string) throws Exception {
        if (this.state != State.THINKING && this.state != State.PONDERING) {
            throw new IllegalStateException("The engine is not thinking");
        }
        this.infinite = false;
    }

    private void parsePonderHit(String string) throws Exception {
        if (this.state != State.PONDERING) {
            throw new IllegalStateException("The engine is not pondering");
        }
        this.state = State.THINKING;
    }

    private void parseQuit(String string) throws Exception {
        this.state = State.STOPPED;
    }

    private void parseID(String string) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("No parameters were provided");
        }
        Scanner scanner = new Scanner(string);
        Pattern pattern = Pattern.compile("name|value");
        while (scanner.hasNext()) {
            String string2 = scanner.next();
            if (string2.equals("name")) {
                this.name = UCIClient.consumeString(scanner, pattern);
                continue;
            }
            if (!string2.equals("author")) continue;
            this.author = UCIClient.consumeString(scanner, pattern);
        }
        scanner.close();
    }

    private void parseUCIOk(String string) throws Exception {
        this.uciok = true;
    }

    private void parseReadyOk(String string) throws Exception {
        this.ready = true;
    }

    private void parseBestMove(String string) throws Exception {
        String string2 = null;
        String string3 = null;
        this.state = State.WAITING;
        this.infinite = false;
        if (string == null) {
            throw new IllegalArgumentException("No parameters were provided");
        }
        Scanner scanner = new Scanner(string);
        if (scanner.hasNext()) {
            string2 = scanner.next();
        }
        while (scanner.hasNext()) {
            String string4 = scanner.next();
            if (!"ponder".equals(string4) || !scanner.hasNext()) continue;
            string3 = scanner.next();
        }
        scanner.close();
        if ("0000".equals(string2)) {
            this.bestMove = -1;
            this.ponderMove = -1;
            return;
        }
        int n = this.start.toMove(string2);
        int n2 = -1;
        if (!this.game.isLegal(n)) {
            throw new IllegalArgumentException("The returned move is not legal");
        }
        this.game.ensureCapacity(2 + this.game.length());
        this.game.makeMove(n);
        if (string3 != null && !this.game.isLegal(n2 = this.start.toMove(string3))) {
            throw new IllegalArgumentException("The returned move is not legal");
        }
        this.game.unmakeMove();
        this.bestMove = n;
        this.ponderMove = n2;
    }

    private void parseCopyProtection(String string) throws Exception {
    }

    private void parseRegistration(String string) throws Exception {
    }

    private void parseInfo(String string) throws Exception {
    }

    private void parseOption(String string) throws Exception {
    }

    private static String consumeString(Scanner scanner, Pattern pattern) {
        StringBuilder stringBuilder = new StringBuilder();
        while (scanner.hasNext() && !scanner.hasNext(pattern)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(scanner.next());
        }
        return stringBuilder.toString();
    }

    private void evaluateInput(String string) throws Exception {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Syntax error: " + string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if ("id".equals(string2)) {
            this.parseID(string3);
        } else if ("uciok".equals(string2)) {
            this.parseUCIOk(string3);
        } else if ("readyok".equals(string2)) {
            this.parseReadyOk(string3);
        } else if ("bestmove".equals(string2)) {
            this.parseBestMove(string3);
        } else if ("copyprotection".equals(string2)) {
            this.parseCopyProtection(string3);
        } else if ("registration".equals(string2)) {
            this.parseRegistration(string3);
        } else if ("info".equals(string2)) {
            this.parseInfo(string3);
        } else if ("option".equals(string2)) {
            this.parseOption(string3);
        } else {
            throw new IllegalArgumentException("Unknown engine command: " + string2);
        }
    }

    private void evaluateOutput(String string) throws Exception {
        if (this.state == State.STOPPED) {
            throw new IllegalStateException("The engine is not running");
        }
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Syntax error: " + string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if ("uci".equals(string2)) {
            this.parseUCI(string3);
        } else if ("debug".equals(string2)) {
            this.parseDebug(string3);
        } else if ("isready".equals(string2)) {
            this.parseIsReady(string3);
        } else if ("setoption".equals(string2)) {
            this.parseSetOption(string3);
        } else if ("register".equals(string2)) {
            this.parseRegister(string3);
        } else if ("ucinewgame".equals(string2)) {
            this.parseUCINewGame(string3);
        } else if ("position".equals(string2)) {
            this.parsePosition(string3);
        } else if ("go".equals(string2)) {
            this.parseGo(string3);
        } else if ("stop".equals(string2)) {
            this.parseStop(string3);
        } else if ("ponderhit".equals(string2)) {
            this.parsePonderHit(string3);
        } else if ("quit".equals(string2)) {
            this.parseQuit(string3);
        } else {
            throw new IllegalArgumentException("Unknown client command: " + string2);
        }
    }

    public void send(String string) throws Exception {
        this.evaluateOutput(string);
        this.output.format("%s%n", string);
    }

    public String receive() throws Exception {
        String string = null;
        if (this.input.hasNextLine()) {
            string = this.input.nextLine();
            if (!string.isEmpty()) {
                this.evaluateInput(string);
            }
        } else {
            throw new IllegalStateException("Engine process is not responding");
        }
        return string;
    }

    public static enum State {
        STOPPED,
        WAITING,
        THINKING,
        PONDERING;

    }
}

