/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.engine;

import com.joansala.engine.Cache;
import com.joansala.engine.Engine;
import com.joansala.engine.Game;
import com.joansala.engine.Leaves;
import java.util.Timer;
import java.util.TimerTask;

public class Negamax
implements Engine {
    public static final long DEFAULT_TIME = 2000L;
    public static final int MAX_DEPTH = 126;
    public static final int MIN_DEPTH = 4;
    private final Timer timer;
    private Game game = null;
    private Cache cache = null;
    private Leaves leaves = null;
    private int maxDepth = 126;
    private long moveTime = 2000L;
    private int maxScore = Integer.MAX_VALUE;
    private int minScore = -2147483647;
    private int contempt = 0;
    private int bestScore = Integer.MAX_VALUE;
    private volatile boolean aborted = false;
    private final Cache dummyCache = new Cache(){

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public int getScore() {
            return 0;
        }

        @Override
        public int getMove() {
            return -1;
        }

        @Override
        public int getDepth() {
            return 0;
        }

        @Override
        public byte getFlag() {
            return 0;
        }

        @Override
        public boolean find(Game game) {
            return false;
        }

        @Override
        public void store(Game game, int n, int n2, int n3, byte by) {
        }

        @Override
        public void discharge() {
        }

        @Override
        public void resize(long l) {
        }

        @Override
        public void clear() {
        }
    };
    private final Leaves dummyLeaves = new Leaves(){

        @Override
        public int getScore() {
            return 0;
        }

        @Override
        public boolean find(Game game) {
            return false;
        }
    };

    public Negamax() {
        this.timer = new Timer(true);
        this.cache = this.dummyCache;
        this.leaves = this.dummyLeaves;
    }

    @Override
    public int getDepth() {
        return this.maxDepth;
    }

    @Override
    public long getMoveTime() {
        return this.moveTime;
    }

    @Override
    public int getContempt() {
        return this.contempt;
    }

    @Override
    public int getInfinity() {
        return this.maxScore;
    }

    @Override
    public synchronized void setDepth(int n) {
        this.maxDepth = n > 126 ? 126 : (n < 4 ? 4 : n + n % 2);
    }

    @Override
    public synchronized void setMoveTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Move time must be a positive number");
        }
        this.moveTime = l;
    }

    @Override
    public synchronized void setContempt(int n) {
        this.contempt = n;
    }

    @Override
    public synchronized void setInfinity(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Infinity must be a positive number");
        }
        this.maxScore = n;
        this.minScore = -n;
    }

    public synchronized void setCache(Cache cache) {
        this.cache = cache != null ? cache : this.dummyCache;
    }

    public synchronized void setLeaves(Leaves leaves) {
        this.leaves = leaves != null ? leaves : this.dummyLeaves;
    }

    @Override
    public synchronized void newMatch() {
        this.cache.clear();
        this.timer.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortComputation() {
        this.aborted = true;
        Negamax negamax = this;
        synchronized (negamax) {
            this.aborted = false;
        }
    }

    public synchronized int computeBestScore(Game game) {
        this.computeBestMove(game);
        return -this.bestScore;
    }

    @Override
    public synchronized int computeBestMove(Game game) {
        int n;
        int n2;
        this.game = game;
        if (game.hasEnded()) {
            this.bestScore = -(game.outcome() * game.turn());
            return -1;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Negamax.this.aborted = true;
            }
        };
        this.timer.schedule(timerTask, this.moveTime);
        game.ensureCapacity(126 + game.length());
        this.cache.discharge();
        int[] nArray = game.legalMoves();
        if (this.cache.find(game) && this.cache.getMove() != -1) {
            n2 = this.cache.getMove();
            for (n = 0; n < 6; ++n) {
                if (nArray[n] != n2) continue;
                System.arraycopy(nArray, 0, nArray, 1, n);
                nArray[0] = n2;
                break;
            }
        }
        n = this.maxScore;
        int n3 = 4;
        int n4 = this.maxScore;
        int n5 = -1;
        int n6 = nArray[0];
        this.bestScore = 0;
        while (!this.aborted) {
            for (int n7 : nArray) {
                game.makeMove(n7);
                n2 = this.search(this.minScore, n, n3);
                game.unmakeMove();
                if (this.aborted && n3 > 4) {
                    n6 = n5;
                    this.bestScore = n4;
                    break;
                }
                if (n2 < n) {
                    n6 = n7;
                    this.bestScore = n2;
                    n = n2;
                    continue;
                }
                if (n2 != n) continue;
                this.bestScore = n2;
            }
            if (Math.abs(this.bestScore) == this.maxScore || this.aborted || n3 >= this.maxDepth) break;
            n = this.maxScore;
            n5 = n6;
            n4 = this.bestScore;
            n3 += 2;
        }
        timerTask.cancel();
        this.aborted = false;
        return n6;
    }

    private int search(int n, int n2, int n3) {
        int n4;
        if (this.aborted) {
            return this.minScore;
        }
        if (this.game.hasEnded()) {
            int n5 = this.game.outcome();
            return n5 == 0 ? this.contempt * this.game.turn() : n5 * this.game.turn();
        }
        if (this.leaves.find(this.game)) {
            int n6 = this.leaves.getScore();
            return n6 == 0 ? this.contempt * this.game.turn() : n6 * this.game.turn();
        }
        if (n3 == 0) {
            return this.game.score() * this.game.turn();
        }
        int n7 = -1;
        if (n3 > 2 && this.cache.find(this.game)) {
            if (this.cache.getDepth() >= n3) {
                switch (this.cache.getFlag()) {
                    case 2: {
                        if (this.cache.getScore() < n2) break;
                        return n2;
                    }
                    case 1: {
                        if (this.cache.getScore() > n) break;
                        return n;
                    }
                    case 3: {
                        return this.cache.getScore();
                    }
                }
            }
            n7 = this.cache.getMove();
        }
        int n8 = this.minScore;
        int n9 = 1;
        if (n7 != -1) {
            this.game.makeMove(n7);
            n8 = -this.search(-n2, -n, n3 - 1);
            this.game.unmakeMove();
            if (n8 >= n2 && !this.aborted) {
                this.cache.store(this.game, n8, n7, n3, (byte)2);
                return n2;
            }
            if (n8 > n) {
                n = n8;
                n9 = 3;
            }
        }
        while ((n4 = this.game.nextMove()) != -1) {
            if (n4 == n7) continue;
            this.game.makeMove(n4);
            n8 = -this.search(-n2, -n, n3 - 1);
            this.game.unmakeMove();
            if (n8 >= n2) {
                n = n2;
                n7 = n4;
                n9 = 2;
                break;
            }
            if (n8 <= n) continue;
            n = n8;
            n7 = n4;
            n9 = 3;
        }
        if (n3 > 2 && !this.aborted) {
            this.cache.store(this.game, n, n7, n3, (byte)n9);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.timer.cancel();
        }
        finally {
            super.finalize();
        }
    }
}

