/*
 * Decompiled with CFR 0.152.
 */
package com.joansala.engine;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.TreeMap;

public class Book {
    private String version = null;
    private String signature = null;
    private final TreeMap<String, String> headers;
    private final RandomAccessFile database;

    public Book(File file, String string) throws IOException {
        this.signature = string;
        this.database = new RandomAccessFile(file, "r");
        this.headers = this.readHeaders();
    }

    public String getVersion() {
        return this.version;
    }

    public RandomAccessFile getDatabase() {
        return this.database;
    }

    public String getField(String string) {
        return this.headers.get(string);
    }

    public Iterator<String> fields() {
        final Iterator<String> iterator = this.headers.keySet().iterator();
        return new Iterator<String>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)iterator.next();
            }
        };
    }

    private TreeMap<String, String> readHeaders() throws IOException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < this.signature.length(); ++i) {
            if (this.database.readChar() == this.signature.charAt(i)) continue;
            throw new IOException("Invalid header signature");
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = this.database.readChar();
        while (c != '\n') {
            stringBuilder.append(c);
            c = this.database.readChar();
        }
        if (stringBuilder.length() > 0) {
            this.version = stringBuilder.toString();
        }
        StringBuilder stringBuilder2 = null;
        do {
            int n;
            stringBuilder2 = new StringBuilder();
            c = this.database.readChar();
            while (c != '\n') {
                stringBuilder2.append(c);
                c = this.database.readChar();
            }
            if (stringBuilder2.length() <= 0 || (n = stringBuilder2.indexOf(":")) == -1) continue;
            String string = stringBuilder2.substring(0, n).trim();
            String string2 = stringBuilder2.substring(n + 1, stringBuilder2.length()).trim();
            treeMap.put(string, string2);
        } while (stringBuilder2.length() > 0);
        return treeMap;
    }

    protected void finalize() throws Throwable {
        this.database.close();
        super.finalize();
    }
}

