/*
 * Decompiled with CFR 0.152.
 */
package dictionary.core;

import dictionary.core.Entry;
import dictionary.core.SearchOptions;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Dictionary {
    private String filename;
    private ArrayList<String> entries = new ArrayList();

    public Dictionary(String string) {
        this.filename = string;
        this.readInputFile();
    }

    private void readInputFile() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!string.startsWith("#") && !string.equals("")) {
                    this.entries.add(string);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.entries.trimToSize();
            if (this.entries.size() == 0) {
                throw new RuntimeException("The dictionary contains zero entries. Please check the dictionary file.");
            }
        }
        catch (Exception exception) {
            System.out.println("Suspect: Dictionary.java/readInputFile()");
            exception.printStackTrace();
        }
    }

    public void searchAndPrint(String string, SearchOptions searchOptions) {
        ArrayList<Entry> arrayList = this.search(string, searchOptions);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Entry entry = arrayList.get(i);
            entry.print(searchOptions.getSourceLanguage(), searchOptions.getTargetLanguage());
        }
    }

    public ArrayList<Entry> search(String string, SearchOptions searchOptions) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (String string2 : this.entries) {
            Entry entry = new Entry(string2);
            if (!entry.search(string, searchOptions)) continue;
            arrayList.add(entry);
        }
        return arrayList;
    }

    public int size() {
        return this.entries.size();
    }
}

