/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.tooltips.presenter;

import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.shared_ui.tooltips.presenter.AbstractInformationPresenter;
import org.python.pydev.shared_ui.tooltips.presenter.StyleRangeWithCustomData;

public abstract class AbstractTooltipInformationPresenter
extends AbstractInformationPresenter {
    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (drawable instanceof StyledText) {
            final StyledText styledText = (StyledText)drawable;
            styledText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    try {
                        int offset = styledText.getOffsetAtLocation(new Point(e.x, e.y));
                        StyleRange r = styledText.getStyleRangeAtOffset(offset);
                        if (r instanceof StyleRangeWithCustomData) {
                            StyleRangeWithCustomData styleRangeWithCustomData = (StyleRangeWithCustomData)r;
                            AbstractTooltipInformationPresenter.this.onHandleClick(styleRangeWithCustomData.customData);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (SWTException sWTException) {}
                }
            });
            styledText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    try {
                        StyleRange r;
                        if ((e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 0x1000050) && (r = styledText.getStyleRangeAtOffset(styledText.getSelection().y)) instanceof StyleRangeWithCustomData) {
                            StyleRangeWithCustomData styleRangeWithCustomData = (StyleRangeWithCustomData)r;
                            AbstractTooltipInformationPresenter.this.onHandleClick(styleRangeWithCustomData.customData);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (SWTException sWTException) {}
                }
            });
        }
        hoverInfo = this.correctLineDelimiters(hoverInfo);
        this.onUpdatePresentation(hoverInfo, presentation);
        return hoverInfo;
    }

    protected abstract void onUpdatePresentation(String var1, TextPresentation var2);

    protected abstract void onHandleClick(Object var1);
}

