/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.search.BasicElementLabels;
import org.python.pydev.shared_ui.search.DecoratingFileSearchLabelProvider;
import org.python.pydev.shared_ui.search.ICustomLineElement;
import org.python.pydev.shared_ui.search.ICustomMatch;
import org.python.pydev.shared_ui.search.ICustomModule;

public class SearchIndexLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String fgEllipses = " ... ";
    private final WorkbenchLabelProvider fLabelProvider = new WorkbenchLabelProvider();
    private final AbstractTextSearchViewPage fPage;
    private final Comparator fMatchComparator;
    private final Image fLineMatchImage;
    private static final int MIN_MATCH_CONTEXT = 10;

    public SearchIndexLabelProvider(AbstractTextSearchViewPage page) {
        this.fPage = page;
        this.fLineMatchImage = SearchPluginImages.get((String)"org.eclipse.search.ui.line_match.gif");
        this.fMatchComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ICustomMatch)o1).getOriginalOffset() - ((ICustomMatch)o2).getOriginalOffset();
            }
        };
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public StyledString getStyledText(Object element) {
        IResource resource;
        if (element instanceof TreeNode) {
            element = ((TreeNode)element).data;
        }
        if (element instanceof ICustomLineElement) {
            return this.getLineElementLabel((ICustomLineElement)element);
        }
        if (!(element instanceof IResource)) {
            IAdaptable iAdaptable;
            resource = null;
            if (element instanceof IAdaptable && (resource = (IResource)(iAdaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
                if (element instanceof ICustomModule) {
                    return this.getColoredLabelWithCounts(resource, new StyledString(element.toString()));
                }
                element = resource;
            }
            if (!(element instanceof IResource)) {
                return new StyledString(element.toString());
            }
        }
        if (!(resource = (IResource)element).exists()) {
            new StyledString("<removed resource>");
        }
        String name = BasicElementLabels.getResourceName(resource);
        return this.getColoredLabelWithCounts(resource, new StyledString(name));
    }

    private StyledString getLineElementLabel(ICustomLineElement lineElement) {
        int lineNumber = lineElement.getLine();
        String lineNumberString = MessageFormat.format("{0}:", lineNumber);
        StyledString str = new StyledString(lineNumberString, StyledString.QUALIFIER_STYLER);
        Match[] matches = lineElement.getMatches(this.fPage.getInput());
        Arrays.sort(matches, this.fMatchComparator);
        String content = lineElement.getContents();
        int pos = this.evaluateLineStart(matches, content, lineElement.getOffset());
        int length = content.length();
        int charsToCut = this.getCharsToCut(length, matches);
        int i = 0;
        while (i < matches.length) {
            ICustomMatch match = (ICustomMatch)matches[i];
            int start = Math.max(match.getOriginalOffset() - lineElement.getOffset(), 0);
            if (pos < start) {
                if (charsToCut > 0) {
                    charsToCut = this.appendShortenedGap(content, pos, start, charsToCut, i == 0, str);
                } else {
                    str.append(content.substring(pos, start));
                }
            }
            int end = Math.min(match.getOriginalOffset() + match.getOriginalLength() - lineElement.getOffset(), lineElement.getLength());
            str.append(content.substring(start, end), DecoratingFileSearchLabelProvider.HIGHLIGHT_STYLE);
            pos = end;
            ++i;
        }
        if (charsToCut > 0) {
            this.appendShortenedGap(content, pos, length, charsToCut, false, str);
        } else {
            str.append(content.substring(pos));
        }
        return str;
    }

    private int appendShortenedGap(String content, int start, int end, int charsToCut, boolean isFirst, StyledString str) {
        int gapLength = end - start;
        if (!isFirst) {
            gapLength -= 10;
        }
        if (end < content.length()) {
            gapLength -= 10;
        }
        if (gapLength < 10) {
            str.append(content.substring(start, end));
            return charsToCut;
        }
        int context = 10;
        if (gapLength > charsToCut) {
            context += gapLength - charsToCut;
        }
        if (!isFirst) {
            str.append(content.substring(start, start + context));
            context = 10;
        }
        str.append(fgEllipses, StyledString.QUALIFIER_STYLER);
        if (end < content.length()) {
            str.append(content.substring(end - context, end));
        }
        return charsToCut - gapLength + fgEllipses.length();
    }

    private int getCharsToCut(int contentLength, Match[] matches) {
        if (contentLength <= 256 || !"win32".equals(SWT.getPlatform()) || matches.length == 0) {
            return 0;
        }
        return contentLength - 256 + Math.max(matches.length * fgEllipses.length(), 100);
    }

    private int evaluateLineStart(Match[] matches, String lineContent, int lineOffset) {
        ICustomMatch match;
        int max = lineContent.length();
        if (matches.length > 0 && (max = (match = (ICustomMatch)matches[0]).getOriginalOffset() - lineOffset) < 0) {
            return 0;
        }
        int i = 0;
        while (i < max) {
            char ch = lineContent.charAt(i);
            if (!Character.isWhitespace(ch) || ch == '\n' || ch == '\r') {
                return i;
            }
            ++i;
        }
        return max;
    }

    private StyledString getColoredLabelWithCounts(Object element, StyledString coloredName) {
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result == null) {
            return coloredName;
        }
        int matchCount = result.getMatchCount(element);
        if (matchCount <= 1) {
            return coloredName;
        }
        String countInfo = MessageFormat.format("({0} matches)", matchCount);
        coloredName.append(' ').append(countInfo, StyledString.COUNTER_STYLER);
        return coloredName;
    }

    public Image getImage(Object element) {
        if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)element;
            element = treeNode.data;
        }
        if (element instanceof ICustomLineElement) {
            return this.fLineMatchImage;
        }
        if (element instanceof ICustomModule) {
            return SharedUiPlugin.getImageCache().get("icons/python_file.gif");
        }
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        Image image = this.fLabelProvider.getImage((Object)resource);
        return image;
    }

    public void dispose() {
        super.dispose();
        this.fLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.fLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.fLabelProvider.removeListener(listener);
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.fLabelProvider.addListener(listener);
    }
}

