/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.python.pydev.shared_core.structure.OrderedSet;
import org.python.pydev.shared_ui.search.SearchIndexData;

public class SearchIndexDataHistory {
    private static final String PAGE_NAME = "SearchIndexPage";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private static final int HISTORY_SIZE = 15;
    private OrderedSet<SearchIndexData> fPreviousSearchPatterns = new OrderedSet();
    private SearchIndexData last = null;
    private IDialogSettings settings;

    public SearchIndexDataHistory(AbstractUIPlugin plugin) {
        IDialogSettings dialogSettings = plugin.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
        if (section == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        this.settings = section;
    }

    public SearchIndexData getLast() {
        return this.last;
    }

    public void add(SearchIndexData data) {
        this.fPreviousSearchPatterns.remove((Object)data);
        this.fPreviousSearchPatterns.add((Object)data);
        if (this.fPreviousSearchPatterns.size() > 15) {
            Iterator it = this.fPreviousSearchPatterns.iterator();
            it.next();
            it.remove();
        }
        this.last = data;
    }

    public void readConfiguration() {
        try {
            IDialogSettings s = this.settings;
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchIndexData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchIndexData.create(histSettings)) != null) {
                    this.last = data;
                    this.fPreviousSearchPatterns.add((Object)data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void writeConfiguration() {
        IDialogSettings s = this.settings;
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 15);
        s.put(STORE_HISTORY_SIZE, historySize);
        Iterator it = this.fPreviousSearchPatterns.iterator();
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchIndexData data = (SearchIndexData)it.next();
            data.store(histSettings);
            ++i;
        }
    }
}

