/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor;

import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.python.pydev.overview_ruler.MinimapOverviewRulerPreferencesPage;
import org.python.pydev.overview_ruler.StyledTextWithoutVerticalBar;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.editor.ITextViewerExtensionAutoEditions;
import org.python.pydev.shared_ui.editor.IVerticalIndentGuidePreferencesProvider;
import org.python.pydev.shared_ui.editor.IVerticalLinesIndentGuideComputer;
import org.python.pydev.shared_ui.editor.TextVerticalLinesIndentGuide;
import org.python.pydev.shared_ui.editor.VerticalIndentGuidesPainter;

public abstract class BaseSourceViewer
extends ProjectionViewer
implements ITextViewerExtensionAutoEditions {
    private boolean autoEditionsEnabled = true;
    private VerticalIndentGuidesPainter verticalLinesPainter;

    public BaseSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IVerticalIndentGuidePreferencesProvider verticalIndentPrefs) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.verticalLinesPainter = new VerticalIndentGuidesPainter(this.getIndentGuide(verticalIndentPrefs));
        StyledText styledText = this.getTextWidget();
        this.verticalLinesPainter.setStyledText(styledText);
        styledText.addPaintListener((PaintListener)this.verticalLinesPainter);
        styledText.setLeftMargin(Math.max(styledText.getLeftMargin(), 2));
    }

    @Override
    public boolean getAutoEditionsEnabled() {
        return this.autoEditionsEnabled;
    }

    @Override
    public void setAutoEditionsEnabled(boolean b) {
        this.autoEditionsEnabled = b;
    }

    protected void handleDispose() {
        try {
            super.handleDispose();
        }
        finally {
            this.verticalLinesPainter.dispose();
        }
    }

    protected Layout createLayout() {
        return new SourceViewer.RulerLayout((SourceViewer)this, 1){

            protected void layout(Composite composite, boolean flushCache) {
                StyledText textWidget = BaseSourceViewer.this.getTextWidget();
                if (textWidget == null) {
                    Log.log((String)("Error: textWidget is already null. SourceViewer: " + BaseSourceViewer.this + " control: " + BaseSourceViewer.this.getControl()));
                    return;
                }
                super.layout(composite, flushCache);
            }
        };
    }

    protected IVerticalLinesIndentGuideComputer getIndentGuide(IVerticalIndentGuidePreferencesProvider verticalIndentPrefs) {
        return new TextVerticalLinesIndentGuide(verticalIndentPrefs);
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        ScrollBar horizontalBar;
        ScrollBar verticalBar;
        StyledTextWithoutVerticalBar styledText = new StyledTextWithoutVerticalBar(parent, styles);
        if (!MinimapOverviewRulerPreferencesPage.getShowVerticalScrollbar() && (verticalBar = styledText.getVerticalBar()) != null) {
            verticalBar.setVisible(false);
        }
        if (!MinimapOverviewRulerPreferencesPage.getShowHorizontalScrollbar() && (horizontalBar = styledText.getHorizontalBar()) != null) {
            horizontalBar.setVisible(false);
        }
        return styledText;
    }
}

