/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PrettyPrinterPrefsV2
implements IPrettyPrinterPrefs {
    private String newLine;
    private String spacesBeforeComment = "";
    private Map<String, String> tokReplacement = new HashMap<String, String>();
    private int linesAfterMethod = 0;
    private int linesAfterClass = 0;
    private int linesAfterSuite = 0;
    private String indent;
    private IGrammarVersionProvider versionProvider;
    public final String[] boolOperatorMapping = new String[]{"<undef>", "and", "or"};
    public final String[] unaryopOperatorMapping = new String[]{"<undef>", "~", "not", "+", "-"};
    public final String[] operatorMapping = new String[]{"<undef>", "+", "-", "*", "/", "%", "**", "<<", ">>", "|", "^", "&", "//"};
    public final String[] augOperatorMapping = new String[]{"<undef>", "+=", "-=", "*=", "/=", "%=", "**=", "<<=", ">>=", "|=", "^=", "&=", "//="};
    public static final String[] cmpop = new String[]{"<undef>", "==", "!=", "<", "<=", ">", ">=", "is", "is not", "in", "not in"};

    public PrettyPrinterPrefsV2(String newLine, String indent, IGrammarVersionProvider versionProvider) {
        this.newLine = newLine;
        this.indent = indent;
        Assert.isNotNull((Object)versionProvider);
        this.tokReplacement.put("def", "def ");
        this.tokReplacement.put("class", "class ");
        this.tokReplacement.put("if", "if ");
        this.tokReplacement.put("elif", "elif ");
        this.tokReplacement.put("in", " in ");
        this.tokReplacement.put("as", " as ");
        this.tokReplacement.put("yield", "yield ");
        this.tokReplacement.put("from", "from ");
        this.tokReplacement.put("del", "del ");
        this.tokReplacement.put("assert", "assert ");
        this.tokReplacement.put("while", "while ");
        this.tokReplacement.put("global", "global ");
        this.tokReplacement.put("with", "with ");
        this.versionProvider = versionProvider;
    }

    public int getGrammarVersion() throws MisconfigurationException {
        return this.versionProvider.getGrammarVersion();
    }

    @Override
    public String getBoolOperatorMapping(int op) {
        return " " + this.boolOperatorMapping[op] + " ";
    }

    @Override
    public String getOperatorMapping(int op) {
        return " " + this.operatorMapping[op] + " ";
    }

    @Override
    public String getUnaryopOperatorMapping(int op) {
        String str = this.unaryopOperatorMapping[op];
        if (str.equals("not")) {
            return String.valueOf(str) + " ";
        }
        return str;
    }

    @Override
    public String getAugOperatorMapping(int op) {
        return " " + this.augOperatorMapping[op] + " ";
    }

    @Override
    public String getCmpOp(int op) {
        return " " + cmpop[op] + " ";
    }

    @Override
    public String getNewLine() {
        return this.newLine;
    }

    @Override
    public String getIndent() {
        return this.indent;
    }

    @Override
    public void setSpacesAfterComma(int i) {
        this.tokReplacement.put(",", this.createSpacesStr(i, ","));
    }

    public void setSpacesAfterColon(int i) {
        this.tokReplacement.put(":", this.createSpacesStr(i, ":"));
    }

    private String createSpacesStr(int i, String startingWith) {
        FastStringBuffer buf = new FastStringBuffer(startingWith, i);
        buf.appendN(' ', i);
        return buf.toString();
    }

    @Override
    public void setReplacement(String original, String replacement) {
        this.tokReplacement.put(original, replacement);
    }

    @Override
    public String getReplacement(String tok) {
        String r = this.tokReplacement.get(tok);
        if (r == null) {
            return tok;
        }
        return r;
    }

    public void setSpacesBeforeComment(int i) {
        this.spacesBeforeComment = this.createSpacesStr(i, "");
    }

    @Override
    public String getSpacesBeforeComment() {
        return this.spacesBeforeComment;
    }

    @Override
    public void setLinesAfterMethod(int i) {
        this.linesAfterMethod = i;
    }

    @Override
    public int getLinesAfterMethod() {
        return this.linesAfterMethod;
    }

    public void setLinesAfterClass(int i) {
        this.linesAfterClass = i;
    }

    @Override
    public int getLinesAfterClass() {
        return this.linesAfterClass;
    }

    public void setLinesAfterSuite(int i) {
        this.linesAfterSuite = i;
    }

    @Override
    public int getLinesAfterSuite() {
        return this.linesAfterSuite;
    }

    @Override
    public String getAssignPunctuation() {
        return " = ";
    }
}

