/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.python.pydev.shared_core.log.Log;

public class InteractiveConsolePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.python.pydev.shared_interactive_console";
    private static InteractiveConsolePlugin plugin;
    private ResourceBundle resourceBundle;
    private static final String[][] IMAGES;
    private List<ILaunch> consoleLaunches = new ArrayList<ILaunch>();

    static {
        IMAGES = new String[][]{{"icons/save.gif", "save.gif"}, {"icons/terminate.gif", "terminate.gif"}, {"icons/interrupt.gif", "interrupt.gif"}};
    }

    public InteractiveConsolePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.python.pydev.shared.interactive_console.InteractiveConsolePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        for (ILaunch l : new ArrayList<ILaunch>(this.consoleLaunches)) {
            try {
                this.removeConsoleLaunch(l);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    public static InteractiveConsolePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = InteractiveConsolePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        int i = 0;
        while (i < IMAGES.length) {
            URL url = InteractiveConsolePlugin.getDefault().getBundle().getEntry(IMAGES[i][0]);
            registry.put(IMAGES[i][1], ImageDescriptor.createFromURL((URL)url));
            ++i;
        }
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public void addConsoleLaunch(ILaunch launch) {
        this.consoleLaunches.add(launch);
    }

    public void removeConsoleLaunch(ILaunch launch) {
        IProcess[] processes;
        if (this.consoleLaunches.remove(launch) && (processes = launch.getProcesses()) != null) {
            IProcess[] iProcessArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                try {
                    p.terminate();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                ++n2;
            }
        }
    }
}

