/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.visitors.MessagesManager;
import com.python.pydev.analysis.visitors.OccurrencesVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.OrderedSet;

public final class ArgumentsChecker {
    private final IModule current;
    private final IPythonNature nature;
    private final ICompletionCache completionCache;
    private final MessagesManager messagesManager;
    private static final int NO_STATIC_NOR_CLASSMETHOD = 0;
    private static final int CLASSMETHOD = 1;
    private static final int STATICMETHOD = 2;
    private final Map<ClassDef, SimpleNode> defToConsideredInit = new HashMap<ClassDef, SimpleNode>();
    private Map<String, Boolean> valToBounded = new HashMap<String, Boolean>();

    public ArgumentsChecker(OccurrencesVisitor occurrencesVisitor) {
        this.current = occurrencesVisitor.current;
        this.nature = occurrencesVisitor.nature;
        this.completionCache = occurrencesVisitor.completionCache;
        this.messagesManager = occurrencesVisitor.messagesManager;
    }

    private int isStaticOrClassMethod(FunctionDef functionDefinitionReferenced) {
        if (functionDefinitionReferenced.decs != null) {
            decoratorsType[] decoratorsTypeArray = functionDefinitionReferenced.decs;
            int n = functionDefinitionReferenced.decs.length;
            int n2 = 0;
            while (n2 < n) {
                String rep;
                decoratorsType dec = decoratorsTypeArray[n2];
                if (dec != null && (rep = NodeUtils.getRepresentationString((SimpleNode)dec.func)) != null) {
                    if (rep.equals("staticmethod")) {
                        return 2;
                    }
                    if (rep.equals("classmethod")) {
                        return 1;
                    }
                }
                ++n2;
            }
        }
        if (functionDefinitionReferenced.parent instanceof ClassDef) {
            ClassDef classDef = (ClassDef)functionDefinitionReferenced.parent;
            stmtType[] body = classDef.body;
            if (body != null) {
                int len = body.length;
                String funcName = ((NameTok)functionDefinitionReferenced.name).id;
                int i = 0;
                while (i < len) {
                    if (body[i] instanceof Assign) {
                        exprType expr;
                        exprType t;
                        String rep;
                        Assign assign = (Assign)body[i];
                        if (assign.targets != null && (assign.targets.length != 1 || (rep = NodeUtils.getRepresentationString((SimpleNode)(t = assign.targets[0]))) != null) && (expr = assign.value) instanceof Call) {
                            String argRep;
                            Call call = (Call)expr;
                            if (call.args.length == 1 && (argRep = NodeUtils.getRepresentationString((SimpleNode)call.args[0])) != null && argRep.equals(funcName)) {
                                String funcCall = NodeUtils.getRepresentationString((SimpleNode)call.func);
                                if ("staticmethod".equals(funcCall)) {
                                    return 2;
                                }
                                if ("classmethod".equals(funcCall)) {
                                    return 1;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    void checkAttrFound(Call callNode, OccurrencesVisitor.TokenFoundStructure found) throws Exception, CompletionRecursionException {
        if (found != null && found.defined && found.token instanceof SourceToken) {
            SourceToken nameToken = (SourceToken)found.token;
            String rep = nameToken.getRepresentation();
            ArrayList definition = new ArrayList();
            SimpleNode ast = nameToken.getAst();
            try {
                PyRefactoringFindDefinition.findActualDefinition(null, (IModule)this.current, (String)rep, definition, (int)ast.beginLine, (int)ast.beginColumn, (IPythonNature)this.nature, (ICompletionCache)this.completionCache);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return;
            }
            for (IDefinition iDefinition : definition) {
                boolean callingBoundMethod;
                Definition d = (Definition)iDefinition;
                if (!(d.ast instanceof FunctionDef)) continue;
                FunctionDef functionDefinitionReferenced = (FunctionDef)d.ast;
                String withoutLastPart = FullRepIterable.getWithoutLastPart((String)rep);
                Boolean b = this.valToBounded.get(withoutLastPart);
                if (b != null) {
                    callingBoundMethod = b;
                } else {
                    int count = StringUtils.count((String)rep, (char)'.');
                    if (count == 1 && rep.startsWith("self.")) {
                        FastStack scopeStack = d.scope.getScopeStack();
                        callingBoundMethod = scopeStack.size() > 0 && scopeStack.peek() instanceof ClassDef;
                    } else {
                        FastStack scopeStack = d.scope.getScopeStack();
                        if (scopeStack.size() > 1 && scopeStack.peek(1) instanceof ClassDef) {
                            callingBoundMethod = true;
                            String withoutLast = FullRepIterable.getWithoutLastPart((String)rep);
                            ArrayList definition2 = new ArrayList();
                            PyRefactoringFindDefinition.findActualDefinition(null, (IModule)this.current, (String)withoutLast, definition2, (int)-1, (int)-1, (IPythonNature)this.nature, (ICompletionCache)this.completionCache);
                            for (IDefinition iDefinition2 : definition2) {
                                Definition d2 = (Definition)iDefinition2;
                                if (!(d2.ast instanceof ClassDef)) continue;
                                callingBoundMethod = false;
                                break;
                            }
                        } else {
                            callingBoundMethod = false;
                        }
                    }
                }
                this.analyzeCallAndFunctionMatch(callNode, functionDefinitionReferenced, (IToken)nameToken, callingBoundMethod);
                break;
            }
        }
    }

    void checkNameFound(Call callNode, SourceToken sourceToken) throws Exception {
        boolean callingBoundMethod = false;
        SimpleNode ast = sourceToken.getAst();
        if (ast instanceof FunctionDef) {
            FunctionDef functionDefinitionReferenced = (FunctionDef)ast;
            this.analyzeCallAndFunctionMatch(callNode, functionDefinitionReferenced, (IToken)sourceToken, callingBoundMethod);
        } else if (ast instanceof ClassDef) {
            ClassDef classDef = (ClassDef)ast;
            SimpleNode initNode = this.defToConsideredInit.get(classDef);
            callingBoundMethod = true;
            if (initNode == null) {
                SimpleNode n;
                String className = ((NameTok)classDef.name).id;
                Definition foundDef = sourceToken.getDefinition();
                IModule mod = this.current;
                if (foundDef != null) {
                    mod = foundDef.module;
                }
                if ((n = NodeUtils.getNodeFromPath((SimpleNode)classDef, (String)"__init__")) instanceof FunctionDef) {
                    initNode = n;
                } else {
                    IDefinition[] definition;
                    IDefinition[] iDefinitionArray = definition = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)(String.valueOf(className) + ".__init__"), (IPythonNature)this.nature, (ICompletionCache)this.completionCache), -1, -1, this.nature);
                    int n2 = definition.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IDefinition iDefinition = iDefinitionArray[n3];
                        Definition d = (Definition)iDefinition;
                        if (d.ast instanceof FunctionDef) {
                            initNode = d.ast;
                            this.defToConsideredInit.put(classDef, initNode);
                            break;
                        }
                        ++n3;
                    }
                }
            }
            if (initNode instanceof FunctionDef) {
                FunctionDef functionDefinitionReferenced = (FunctionDef)initNode;
                this.analyzeCallAndFunctionMatch(callNode, functionDefinitionReferenced, (IToken)sourceToken, callingBoundMethod);
            }
        }
    }

    protected void analyzeCallAndFunctionMatch(Call callNode, FunctionDef functionDefinitionReferenced, IToken nameToken, boolean callingBoundMethod) throws Exception {
        int functionArgsLen = functionDefinitionReferenced.args.args != null ? functionDefinitionReferenced.args.args.length : 0;
        OrderedSet functionRequiredArgs = new OrderedSet(functionArgsLen);
        OrderedSet functionOptionalArgs = new OrderedSet(functionArgsLen);
        int staticOrClassMethod = this.isStaticOrClassMethod(functionDefinitionReferenced);
        boolean ignoreFirstParameter = callingBoundMethod;
        if (staticOrClassMethod != 0) {
            switch (staticOrClassMethod) {
                case 2: {
                    ignoreFirstParameter = false;
                    break;
                }
                case 1: {
                    ignoreFirstParameter = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected condition.");
                }
            }
        }
        int i = 0;
        while (i < functionArgsLen) {
            String rep;
            if (!(i == 0 && ignoreFirstParameter || (rep = NodeUtils.getRepresentationString((SimpleNode)functionDefinitionReferenced.args.args[i])) == null)) {
                if (functionDefinitionReferenced.args.defaults == null || functionDefinitionReferenced.args.defaults.length > i && functionDefinitionReferenced.args.defaults[i] == null) {
                    functionRequiredArgs.add(rep);
                } else {
                    functionOptionalArgs.add(rep);
                }
            }
            ++i;
        }
        exprType[] kwonlyargs = functionDefinitionReferenced.args.kwonlyargs;
        OrderedSet functionKeywordOnlyArgs = null;
        if (kwonlyargs != null) {
            functionKeywordOnlyArgs = new OrderedSet(kwonlyargs.length);
            exprType[] exprTypeArray = kwonlyargs;
            int n = kwonlyargs.length;
            int n2 = 0;
            while (n2 < n) {
                String representationString;
                exprType exprType2 = exprTypeArray[n2];
                if (exprType2 != null && (representationString = NodeUtils.getRepresentationString((SimpleNode)exprType2)) != null) {
                    functionKeywordOnlyArgs.add(representationString);
                }
                ++n2;
            }
        }
        int callArgsLen = callNode.args != null ? callNode.args.length : 0;
        int i2 = 0;
        while (i2 < callArgsLen) {
            if (functionRequiredArgs.size() > 0) {
                Iterator it = functionRequiredArgs.iterator();
                it.next();
                it.remove();
            } else if (functionOptionalArgs.size() > 0) {
                Iterator it = functionOptionalArgs.iterator();
                it.next();
                it.remove();
            } else if (functionDefinitionReferenced.args.vararg == null) {
                this.onArgumentsMismatch(nameToken, callNode);
                return;
            }
            ++i2;
        }
        int callKeywordArgsLen = callNode.keywords != null ? callNode.keywords.length : 0;
        int i3 = 0;
        while (i3 < callKeywordArgsLen) {
            String rep = NodeUtils.getRepresentationString((SimpleNode)callNode.keywords[i3].arg);
            if (!(rep == null || functionRequiredArgs.remove(rep) || functionOptionalArgs.remove(rep) || functionKeywordOnlyArgs != null && functionKeywordOnlyArgs.remove(rep) || functionDefinitionReferenced.args.kwarg != null)) {
                this.onArgumentsMismatch(nameToken, callNode);
                return;
            }
            ++i3;
        }
        if (functionRequiredArgs.size() > 0 || functionKeywordOnlyArgs != null && functionKeywordOnlyArgs.size() > 0) {
            if (callNode.kwargs == null && callNode.starargs == null) {
                this.onArgumentsMismatch(nameToken, callNode);
                return;
            }
        } else if (functionOptionalArgs.size() <= 0) {
            if (callNode.kwargs != null && functionDefinitionReferenced.args.kwarg == null) {
                this.onArgumentsMismatch(nameToken, callNode);
                return;
            }
            if (callNode.starargs != null && functionDefinitionReferenced.args.vararg == null) {
                this.onArgumentsMismatch(nameToken, callNode);
                return;
            }
        }
    }

    private void onArgumentsMismatch(IToken node, Call callNode) {
        this.messagesManager.onArgumentsMismatch(node, callNode);
    }

    public void visitAssign(Assign node) {
        boolean bounded = false;
        exprType[] targets = node.targets;
        if (node.value != null && node.value instanceof Call) {
            bounded = true;
        }
        if (targets != null) {
            int len = targets.length;
            int i = 0;
            while (i < len) {
                exprType expr = targets[i];
                this.valToBounded.put(NodeUtils.getFullRepresentationString((SimpleNode)expr), bounded);
                ++i;
            }
        }
    }
}

