/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.OccurrencesAnalyzer;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.builder.AbstractAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableFactory;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableForRemove;
import com.python.pydev.analysis.builder.AnalysisRunner;
import com.python.pydev.analysis.builder.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.KeyForAnalysisRunnable;
import com.python.pydev.analysis.messages.IMessage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.shared_core.callbacks.ICallback;

public class AnalysisBuilderRunnable
extends AbstractAnalysisBuilderRunnable {
    public static final List<ICallback<Object, IResource>> analysisBuilderListeners = new ArrayList<ICallback<Object, IResource>>();
    private IDocument document;
    private IResource resource;
    private ICallback<IModule, Integer> module;
    private int moduleRequest;
    private boolean onlyRecreateCtxInsensitiveInfo;
    private static boolean useEclipse32DerivedVersion = false;

    private static boolean isHierarchicallyDerived(IResource curr) {
        if (useEclipse32DerivedVersion) {
            do {
                if (!curr.isDerived()) continue;
                return true;
            } while ((curr = curr.getParent()) != null);
            return false;
        }
        try {
            return curr.isDerived(512);
        }
        catch (Throwable throwable) {
            useEclipse32DerivedVersion = true;
            return AnalysisBuilderRunnable.isHierarchicallyDerived(curr);
        }
    }

    AnalysisBuilderRunnable(IDocument document, IResource resource, ICallback<IModule, Integer> module, boolean isFullBuild, String moduleName, boolean forceAnalysis, int analysisCause, IAnalysisBuilderRunnable oldAnalysisBuilderThread, IPythonNature nature, long documentTime, KeyForAnalysisRunnable key, long resourceModificationStamp) {
        super(isFullBuild, moduleName, forceAnalysis, analysisCause, oldAnalysisBuilderThread, nature, documentTime, key, resourceModificationStamp);
        if (resource == null) {
            Log.toLogFile((Object)this, (String)("Unexpected null resource for: " + moduleName));
            return;
        }
        this.document = document;
        this.resource = resource;
        this.module = module;
        boolean updateIndex = analysisCause == 1;
        try {
            AbstractAdditionalDependencyInfo info;
            boolean bl = this.onlyRecreateCtxInsensitiveInfo = !forceAnalysis && analysisCause == 1 && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor();
            if (!this.onlyRecreateCtxInsensitiveInfo && !nature.isResourceInPythonpathProjectSources(resource, false)) {
                this.onlyRecreateCtxInsensitiveInfo = true;
            }
            if ((info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature)) == null) {
                Log.log((String)("Unable to get additional info for: " + resource + " -- " + moduleName));
                return;
            }
            if (!isFullBuild && updateIndex) {
                AnalysisBuilderRunnableForRemove.removeInfoForModule(moduleName, nature, isFullBuild);
            }
            this.moduleRequest = this.onlyRecreateCtxInsensitiveInfo ? 2 : 1;
            if (updateIndex) {
                this.recreateCtxInsensitiveInfo(info, (SourceModule)this.module.call((Object)this.moduleRequest), nature, resource);
            }
        }
        catch (CoreException | MisconfigurationException e) {
            Log.log((Throwable)e);
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.document = null;
        this.resource = null;
        this.module = null;
    }

    @Override
    protected void doAnalysis() {
        if (!this.nature.startRequests()) {
            return;
        }
        try {
            boolean makeAnalysis;
            IResource r;
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)this, (String)("doAnalysis() - " + this.moduleName + " " + this.getAnalysisCauseStr()));
            }
            if ((r = this.resource) == null) {
                Log.toLogFile((Object)this, (String)("Finished analysis -- resource null -- " + this.moduleName));
                return;
            }
            if (!r.getProject().isOpen()) {
                Log.toLogFile((Object)this, (String)("Finished analysis -- project closed -- " + this.moduleName));
                return;
            }
            AnalysisRunner runner = new AnalysisRunner();
            this.checkStop();
            AnalysisPreferences analysisPreferences = new AnalysisPreferences((IAdaptable)r);
            boolean bl = makeAnalysis = runner.canDoAnalysis(this.document) && PyDevBuilderVisitor.isInPythonPath((IResource)r) && analysisPreferences.makeCodeAnalysis();
            if (!makeAnalysis) {
                AnalysisRunner.deleteMarkers(r);
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Skipping: !makeAnalysis -- " + this.moduleName));
                }
                return;
            }
            if (this.onlyRecreateCtxInsensitiveInfo) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Skipping: !forceAnalysis && analysisCause == ANALYSIS_CAUSE_BUILDER && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor() -- " + this.moduleName));
                }
                return;
            }
            if (this.nature == null) {
                Log.log((String)("Finished analysis: null nature -- " + this.moduleName));
                return;
            }
            AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(this.nature);
            if (info == null) {
                Log.log((String)("Unable to get additional info for: " + r + " -- " + this.moduleName));
                return;
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)this, (String)("makeAnalysis:" + makeAnalysis + " " + "analysisCause: " + this.getAnalysisCauseStr() + " -- " + this.moduleName));
            }
            this.checkStop();
            if (AnalysisBuilderRunnable.isHierarchicallyDerived(r)) {
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Resource marked as derived not analyzed: " + r + " -- " + this.moduleName));
                }
                if (r != null) {
                    runner.setMarkers(r, this.document, new IMessage[0], this.internalCancelMonitor);
                }
                return;
            }
            try {
                OccurrencesAnalyzer analyzer = new OccurrencesAnalyzer();
                this.checkStop();
                SourceModule module = (SourceModule)this.module.call((Object)this.moduleRequest);
                IMessage[] messages = analyzer.analyzeDocument(this.nature, module, analysisPreferences, this.document, this.internalCancelMonitor, DefaultIndentPrefs.get((IAdaptable)this.resource));
                this.checkStop();
                if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)this, (String)("Adding markers for module: " + this.moduleName));
                }
                this.checkStop();
                if (r != null) {
                    boolean analyzeOnlyActiveEditor = PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor();
                    if (this.forceAnalysis || !analyzeOnlyActiveEditor || analyzeOnlyActiveEditor && (!PyDevBuilderPrefPage.getRemoveErrorsWhenEditorIsClosed() || PyEdit.isEditorOpenForResource((IResource)r))) {
                        runner.setMarkers(r, this.document, messages, this.internalCancelMonitor);
                    } else if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                        Log.toLogFile((Object)this, (String)("Skipped adding markers for module: " + this.moduleName + " (editor not opened)."));
                    }
                }
                for (ICallback<Object, IResource> callback : analysisBuilderListeners) {
                    try {
                        callback.call((Object)r);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.logOperationCancelled();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        finally {
            try {
                this.nature.endRequests();
            }
            catch (Throwable e) {
                Log.log((String)("Error when analyzing: " + this.moduleName), (Throwable)e);
            }
            try {
                AnalysisBuilderRunnableFactory.removeFromThreads(this.key, this);
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            this.dispose();
        }
    }

    private void recreateCtxInsensitiveInfo(AbstractAdditionalTokensInfo info, SourceModule sourceModule, IPythonNature nature, IResource r) {
        boolean generateDelta = !this.isFullBuild;
        info.addAstInfo(sourceModule.getAst(), sourceModule.getModulesKey(), generateDelta);
    }
}

