/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AttrInfo;
import com.python.pydev.analysis.additionalinfo.ClassInfo;
import com.python.pydev.analysis.additionalinfo.FuncInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.ModInfo;
import com.python.pydev.analysis.additionalinfo.NameInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.python.pydev.core.FastBufferedReader;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class TreeIO {
    public static void dumpTreeToBuffer(SortedMap<String, Set<IInfo>> tree, FastStringBuffer tempBuf, Map<String, Integer> strToInt) {
        Set<Map.Entry<String, Set<IInfo>>> entrySet = tree.entrySet();
        Iterator<Map.Entry<String, Set<IInfo>>> it = entrySet.iterator();
        tempBuf.append(entrySet.size());
        tempBuf.append('\n');
        while (it.hasNext()) {
            Map.Entry<String, Set<IInfo>> next = it.next();
            tempBuf.append(next.getKey());
            Set<IInfo> value = next.getValue();
            tempBuf.append('|');
            tempBuf.append(value.size());
            tempBuf.append('|');
            for (IInfo info : value) {
                String modName;
                Integer integer;
                tempBuf.append(info.getName());
                tempBuf.append('!');
                String path = info.getPath();
                if (path != null) {
                    integer = strToInt.get(path);
                    if (integer == null) {
                        integer = strToInt.size() + 1;
                        strToInt.put(path, integer);
                    }
                    tempBuf.append(integer.intValue());
                    tempBuf.append('&');
                }
                if ((integer = strToInt.get(modName = info.getDeclaringModuleName())) == null) {
                    integer = strToInt.size() + 1;
                    strToInt.put(modName, integer);
                }
                int v = integer << 3;
                tempBuf.append(v |= info.getType());
                tempBuf.append('@');
            }
            tempBuf.append('\n');
        }
        tempBuf.append("-- END TREE\n");
    }

    public static void dumpDictToBuffer(Map<String, Integer> strToInt, FastStringBuffer buf2) {
        Iterator<Map.Entry<String, Integer>> it = strToInt.entrySet().iterator();
        buf2.append("-- START DICTIONARY\n");
        buf2.append(strToInt.size());
        buf2.append('\n');
        while (it.hasNext()) {
            Map.Entry<String, Integer> next = it.next();
            buf2.append(next.getValue().intValue());
            buf2.append('=');
            buf2.append(next.getKey());
            buf2.append('\n');
        }
        buf2.append("-- END DICTIONARY\n");
    }

    public static PyPublicTreeMap<String, Set<IInfo>> loadTreeFrom(FastBufferedReader reader, Map<Integer, String> dictionary, FastStringBuffer buf, ObjectsInternPool.ObjectsPoolMap objectsPoolMap) throws IOException {
        PyPublicTreeMap tree = new PyPublicTreeMap();
        final int size = StringUtils.parsePositiveInt((FastStringBuffer)reader.readLine());
        try {
            final Map.Entry[] entries = new Map.Entry[size];
            int iEntry = 0;
            while (iEntry < size) {
                buf.clear();
                FastStringBuffer line = reader.readLine();
                if (line == null || line.startsWith("-- ")) {
                    throw new RuntimeException("Unexpected line: " + line);
                }
                char[] internalCharsArray = line.getInternalCharsArray();
                int length = line.length();
                String key = null;
                String infoName = null;
                String path = null;
                int i = 0;
                block21: while (i < length) {
                    char c = internalCharsArray[i];
                    switch (c) {
                        case '|': {
                            key = ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)objectsPoolMap, (String)buf.toString());
                            buf.clear();
                            ++i;
                            break block21;
                        }
                        default: {
                            buf.appendResizeOnExc(c);
                            ++i;
                        }
                    }
                }
                int hashSize = 0;
                block22: while (i < length) {
                    char c = internalCharsArray[i];
                    switch (c) {
                        case '|': {
                            hashSize = StringUtils.parsePositiveInt((FastStringBuffer)buf);
                            buf.clear();
                            ++i;
                            break block22;
                        }
                        default: {
                            buf.appendResizeOnExc(c);
                            ++i;
                        }
                    }
                }
                HashSet<IInfo> set = new HashSet<IInfo>(hashSize);
                while (i < length) {
                    char c = internalCharsArray[i];
                    block7 : switch (c) {
                        case '!': {
                            infoName = ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)objectsPoolMap, (String)buf.toString());
                            buf.clear();
                            break;
                        }
                        case '&': {
                            path = dictionary.get(StringUtils.parsePositiveInt((FastStringBuffer)buf));
                            buf.clear();
                            break;
                        }
                        case '@': {
                            int dictKey = StringUtils.parsePositiveInt((FastStringBuffer)buf);
                            byte type = (byte)dictKey;
                            type = (byte)(type & 7);
                            buf.clear();
                            String moduleDeclared = dictionary.get(dictKey >>= 3);
                            if (moduleDeclared == null) {
                                throw new AssertionError((Object)("Unable to find key: " + dictKey));
                            }
                            if (infoName == null) {
                                throw new AssertionError((Object)("Info name may not be null. Line: " + line));
                            }
                            switch (type) {
                                case 1: {
                                    set.add(new ClassInfo(infoName, moduleDeclared, path, false));
                                    break block7;
                                }
                                case 2: {
                                    set.add(new FuncInfo(infoName, moduleDeclared, path, false));
                                    break block7;
                                }
                                case 3: {
                                    set.add(new AttrInfo(infoName, moduleDeclared, path, false));
                                    break block7;
                                }
                                case 4: {
                                    set.add(new NameInfo(infoName, moduleDeclared, path, false));
                                    break block7;
                                }
                                case 5: {
                                    set.add(new ModInfo(infoName, false));
                                    break block7;
                                }
                            }
                            Log.log((String)("Unexpected type: " + type));
                            break;
                        }
                        default: {
                            buf.appendResizeOnExc(c);
                        }
                    }
                    ++i;
                }
                entries[iEntry] = new MapEntry(key, set);
                ++iEntry;
            }
            tree.buildFromSorted(size, new Iterator(){
                private int iNext;

                @Override
                public boolean hasNext() {
                    return this.iNext > size;
                }

                public Object next() {
                    Map.Entry o = entries[this.iNext];
                    ++this.iNext;
                    return o;
                }

                @Override
                public void remove() {
                }
            }, null, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return tree;
    }

    public static Map<Integer, String> loadDictFrom(FastBufferedReader reader, FastStringBuffer buf, ObjectsInternPool.ObjectsPoolMap objectsPoolMap) throws IOException {
        int size = StringUtils.parsePositiveInt((FastStringBuffer)reader.readLine());
        HashMap<Integer, String> map = new HashMap<Integer, String>(size + 5);
        int val = 0;
        FastStringBuffer line;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("-- ")) {
                if (line.startsWith("-- END DICTIONARY")) {
                    return map;
                }
                throw new RuntimeException("Unexpected line: " + line);
            }
            int length = line.length();
            int i = 0;
            while (i < length) {
                char c = line.charAt(i);
                if (c == '=') {
                    val = StringUtils.parsePositiveInt((FastStringBuffer)buf);
                    buf.clear();
                } else {
                    buf.appendResizeOnExc(c);
                }
                ++i;
            }
            String bufStr = buf.toString();
            String interned = (String)objectsPoolMap.get((Object)bufStr);
            if (interned == null) {
                interned = bufStr;
                objectsPoolMap.put((Object)bufStr, (Object)bufStr);
            }
            map.put(val, interned);
            buf.clear();
        }
        return map;
    }

    private static final class MapEntry
    implements Map.Entry {
        private final String key;
        private final HashSet<IInfo> set;

        public MapEntry(String key, HashSet<IInfo> set) {
            this.key = key;
            this.set = set;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.set;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

