/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.IPyContextObserver;
import com.python.pydev.analysis.PyContextActivator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_ui.utils.IViewWithControls;
import org.python.pydev.ui.IViewCreatedObserver;

public class PyContextActivatorViewCreatedObserver
implements IViewCreatedObserver {
    public static final PyContextObserver pyContextObserver = new PyContextObserver();
    private ICallbackListener onControlCreated = new ICallbackListener(){

        public Object call(Object obj) {
            if (obj instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)obj;
                obj = treeViewer.getTree();
            }
            if (obj instanceof Control) {
                Control control = (Control)obj;
                control.addFocusListener((FocusListener)pyContextObserver);
            }
            return null;
        }
    };
    private ICallbackListener onControlDisposed = new ICallbackListener(){

        public Object call(Object obj) {
            Control control;
            if (obj instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)obj;
                obj = treeViewer.getTree();
            }
            if (obj instanceof Control && !(control = (Control)obj).isDisposed()) {
                control.removeFocusListener((FocusListener)pyContextObserver);
            }
            return null;
        }
    };

    public void notifyViewCreated(IViewWithControls view) {
        view.getOnControlCreated().registerListener(this.onControlCreated);
        view.getOnControlDisposed().registerListener(this.onControlDisposed);
    }

    public static final class PyContextObserver
    implements IPyContextObserver,
    FocusListener,
    DisposeListener {
        private final CallbackWithListeners onStateChange = new CallbackWithListeners();
        private boolean active = false;
        private Widget currWidget = null;

        PyContextObserver() {
            PyContextActivator.getSingleton().registerPyContextObserver(this);
        }

        @Override
        public boolean isPyContextActive() {
            return this.active;
        }

        @Override
        public CallbackWithListeners getOnStateChange() {
            return this.onStateChange;
        }

        public void focusLost(FocusEvent e) {
            Widget widget = e.widget;
            this.stop(widget);
        }

        protected void stop(Widget widget) {
            if (widget == this.currWidget) {
                if (!this.currWidget.isDisposed()) {
                    this.currWidget.removeDisposeListener((DisposeListener)this);
                }
                this.currWidget = null;
                this.changeState(false);
            }
        }

        public void focusGained(FocusEvent e) {
            Widget widget;
            if (e.widget == this.currWidget) {
                return;
            }
            if (this.currWidget != null) {
                if (!this.currWidget.isDisposed()) {
                    this.currWidget.removeDisposeListener((DisposeListener)this);
                }
                this.currWidget = null;
            }
            if ((widget = e.widget).isDisposed()) {
                Log.log((String)"Gained focus on disposed widget?");
                this.stop(widget);
                return;
            }
            widget.addDisposeListener((DisposeListener)this);
            this.currWidget = widget;
            this.changeState(true);
        }

        protected void changeState(boolean newActiveState) {
            if (this.active != newActiveState) {
                this.active = newActiveState;
                this.onStateChange.call(null);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget != this.currWidget) {
                Log.log((String)"Heard disposed on non current widget?");
            }
            this.stop(this.currWidget);
        }
    }
}

