/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.edit;

import org.eclipse.text.edits.TextEdit;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.NodeHelper;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.rewriter.Rewriter;
import org.python.pydev.refactoring.core.request.IExtractMethodRefactoringRequest;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;

public abstract class AbstractTextEdit {
    private static final String WHITESPACE = " ";
    private static final String REPLACE_PATTERN = "\\r\\n|\\n|\\r";
    protected ModuleAdapter moduleAdapter;
    protected IASTNodeAdapter<? extends SimpleNode> offsetAdapter;
    protected NodeHelper nodeHelper;
    protected AdapterPrefs adapterPrefs;
    protected PyAstFactory astFactory;
    private AbstractScopeNode<?> scopeAdapter;

    public AbstractTextEdit(IRefactoringRequest req) {
        this.moduleAdapter = req.getOffsetNode().getModule();
        this.offsetAdapter = req.getOffsetNode();
        if (req instanceof IExtractMethodRefactoringRequest) {
            this.scopeAdapter = ((IExtractMethodRefactoringRequest)((Object)req)).getScopeAdapter();
        }
        this.nodeHelper = new NodeHelper(req.getAdapterPrefs());
        this.adapterPrefs = req.getAdapterPrefs();
        this.astFactory = new PyAstFactory(this.nodeHelper.getAdapterPrefs());
    }

    protected abstract SimpleNode getEditNode() throws MisconfigurationException;

    public abstract TextEdit getEdit() throws MisconfigurationException;

    protected String getFormattedNode() throws MisconfigurationException {
        SimpleNode node = this.getEditNode().createCopy();
        try {
            MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String source = Rewriter.createSourceFromAST(node, this.adapterPrefs);
        return this.getIndentedSource(node, source, this.getIndent());
    }

    private String getIndentedSource(SimpleNode node, String source, String indentation) {
        StringBuilder indented = new StringBuilder();
        if (this.nodeHelper.isFunctionDef(node)) {
            indented.append(this.adapterPrefs.endLineDelim);
        }
        indented.append(indentation);
        source = source.replaceAll(REPLACE_PATTERN, String.valueOf(this.adapterPrefs.endLineDelim) + indentation);
        source = source.trim();
        indented.append(source);
        indented.append(this.adapterPrefs.endLineDelim);
        if (this.nodeHelper.isFunctionDef(node)) {
            indented.append(this.adapterPrefs.endLineDelim);
        }
        return indented.toString();
    }

    public abstract int getOffsetStrategy();

    public int getOffset() {
        return this.moduleAdapter.getOffset(this.offsetAdapter, this.getOffsetStrategy(), this.scopeAdapter);
    }

    public String getIndent() {
        return this.offsetAdapter.getNodeBodyIndent();
    }
}

