/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils.internal.linux;

import java.io.File;
import java.io.FilenameFilter;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.utils.IProcessInfo;
import org.python.pydev.shared_core.utils.IProcessList;
import org.python.pydev.shared_core.utils.internal.ProcessInfo;

public class ProcessListLinux
implements IProcessList {
    ProcessInfo[] empty = new ProcessInfo[0];

    @Override
    public IProcessInfo[] getProcessList() {
        File proc = new File("/proc");
        File[] pidFiles = null;
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isPID = false;
                    try {
                        Integer.parseInt(name);
                        isPID = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    return isPID;
                }
            };
            pidFiles = proc.listFiles(filter);
        }
        catch (SecurityException securityException) {}
        IProcessInfo[] processInfo = this.empty;
        if (pidFiles != null) {
            processInfo = new ProcessInfo[pidFiles.length];
            int i = 0;
            while (i < pidFiles.length) {
                File cmdLine = new File(pidFiles[i], "cmdline");
                String name = FileUtils.getFileContents(cmdLine).replace('\u0000', ' ');
                if (name.length() == 0) {
                    name = "Unknown";
                }
                processInfo[i] = new ProcessInfo(pidFiles[i].getName(), name);
                ++i;
            }
        } else {
            pidFiles = new File[]{};
        }
        return processInfo;
    }

    public static void main(String[] args) {
        IProcessInfo[] processList;
        IProcessInfo[] iProcessInfoArray = processList = new ProcessListLinux().getProcessList();
        int n = processList.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInfo iProcessInfo = iProcessInfoArray[n2];
            System.out.println(iProcessInfo);
            ++n2;
        }
    }
}

