/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.resource_stubs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.resource_stubs.AbstractIFileStub;
import org.python.pydev.shared_core.resource_stubs.ProjectStub;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class FileStub
extends AbstractIFileStub
implements IFile {
    private ProjectStub project;
    protected File file;

    public FileStub(ProjectStub project, File file) {
        Assert.isTrue((file.exists() && file.isFile() ? 1 : 0) != 0);
        this.project = project;
        this.file = file;
    }

    @Override
    public String getFileExtension() {
        String name = this.file.getName();
        List<String> dotSplit = StringUtils.dotSplit(name);
        if (dotSplit.size() > 1) {
            return dotSplit.get(dotSplit.size() - 1);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IContainer getParent() {
        return this.project.getFolder(this.file.getParentFile());
    }

    @Override
    public long getModificationStamp() {
        try {
            FileTime ret = Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]);
            return ret.to(TimeUnit.NANOSECONDS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        try {
            FastStringBuffer buffer = FileUtils.fillBufferWithStream(source, "utf-8", monitor);
            FileUtils.writeStrToFile(buffer.toString(), this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getContents(boolean force) throws CoreException {
        return this.getContents();
    }

    @Override
    public IPath getFullPath() {
        IPath projectPath = Path.fromOSString((String)FileUtils.getFileAbsolutePath(this.project.projectRoot));
        IPath filePath = Path.fromOSString((String)FileUtils.getFileAbsolutePath(this.file));
        return filePath.makeRelativeTo(projectPath);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileStub other = (FileStub)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public String toString() {
        return "FileStub:" + this.file;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }
}

