/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IToken;
import org.python.pydev.shared_core.partitioner.DummyToken;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;

public final class SubRuleToken {
    public IToken token;
    public int offset;
    public int len;
    private LinkedList<SubRuleToken> children;

    public SubRuleToken(IToken token, int offset, int len) {
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        this.token = token;
        this.offset = offset;
        this.len = len;
    }

    public SubRuleToken createCopy() {
        SubRuleToken copy = this.copyWithoutChildren();
        if (this.children != null) {
            for (SubRuleToken c : this.children) {
                copy.addChild(c.createCopy());
            }
        }
        return copy;
    }

    public String toString() {
        FastStringBuffer ret = new FastStringBuffer("SubRuleToken[", 30).appendObject(this.token.getData()).append(" offset: ").append(this.offset).append(" len: ").append(this.len);
        if (this.children != null && this.children.size() > 0) {
            ret.append(" children:\n").append(this.children.toString());
        }
        ret.append(']').toString();
        return ret.toString();
    }

    public String toStringBetter() {
        return this.toString(0);
    }

    public String toString(int level) {
        String ident = new FastStringBuffer().appendN("   ", level + 1).toString();
        String ident2 = new FastStringBuffer().appendN("   ", level).toString();
        FastStringBuffer ret = new FastStringBuffer("SubRuleToken: ", 30).appendObject(this.token.getData()).append(" offset: ").append(this.offset).append(" len: ").append(this.len);
        if (this.children != null && this.children.size() > 0) {
            ret.append(" children:[");
            for (SubRuleToken subRuleToken : this.children) {
                ret.append("\n");
                ret.append(ident);
                ret.append(subRuleToken.toString(level + 1));
            }
            ret.append("\n");
            ret.append(ident2);
            ret.append("]");
        }
        return ret.toString();
    }

    public void makeRelativeToOffset(int offset) {
        this.offset -= offset;
        if (this.children != null) {
            for (SubRuleToken c : this.children) {
                c.makeRelativeToOffset(offset);
            }
        }
    }

    public void addOffset(int offset) {
        this.offset += offset;
        if (this.children != null) {
            for (SubRuleToken c : this.children) {
                c.addOffset(offset);
            }
        }
    }

    public void flatten(LinkedList<SubRuleToken> lst) {
        SubRuleToken.addSubRuleToken(lst, this.copyWithoutChildren(), true);
        if (this.children != null) {
            for (SubRuleToken c : this.children) {
                c.flatten(lst);
            }
        }
    }

    private SubRuleToken copyWithoutChildren() {
        return new SubRuleToken(this.token, this.offset, this.len);
    }

    public List<SubRuleToken> flatten() {
        LinkedListWarningOnSlowOperations<SubRuleToken> lst = new LinkedListWarningOnSlowOperations<SubRuleToken>();
        this.flatten(lst);
        return lst;
    }

    public void addChildren(List<SubRuleToken> lst) {
        if (lst == null) {
            return;
        }
        if (this.children == null) {
            this.children = new LinkedListWarningOnSlowOperations<SubRuleToken>();
        }
        for (SubRuleToken subRuleToken : lst) {
            SubRuleToken.addSubRuleToken(this.children, subRuleToken);
        }
    }

    public void addChild(SubRuleToken subRuleToken) {
        if (this.children == null) {
            this.children = new LinkedListWarningOnSlowOperations<SubRuleToken>();
        }
        SubRuleToken.addSubRuleToken(this.children, subRuleToken);
    }

    public static void addSubRuleToken(LinkedList<SubRuleToken> lst, SubRuleToken subRuleToken) {
        SubRuleToken.addSubRuleToken(lst, subRuleToken, false);
    }

    public static void addSubRuleToken(LinkedList<SubRuleToken> lst, SubRuleToken subRuleToken, boolean ignoreEmpty) {
        ListIterator<SubRuleToken> it;
        if (ignoreEmpty) {
            if (subRuleToken.token == null) {
                return;
            }
            if (subRuleToken.token instanceof DummyToken) {
                return;
            }
            Object data = subRuleToken.token.getData();
            if (data == null || "".equals(data)) {
                return;
            }
        }
        if ((it = lst.listIterator(lst.size())).hasPrevious()) {
            SubRuleToken prev = it.previous();
            if (prev.offset + prev.len <= subRuleToken.offset) {
                it.next();
                it.add(subRuleToken);
                return;
            }
            if (prev.offset < subRuleToken.offset) {
                int prevEndOffset = prev.offset + prev.len;
                int newEndOffset = subRuleToken.offset + subRuleToken.len;
                prev.len = subRuleToken.offset - prev.offset;
                it.next();
                it.add(subRuleToken);
                if (prevEndOffset > newEndOffset) {
                    it.add(new SubRuleToken(prev.token, newEndOffset, prevEndOffset - newEndOffset));
                }
                return;
            }
            if (prev.offset == subRuleToken.offset) {
                if (prev.len <= subRuleToken.len) {
                    it.remove();
                    it.add(subRuleToken);
                    return;
                }
                int newOffset = subRuleToken.offset + subRuleToken.len;
                prev.len -= newOffset - prev.offset;
                prev.offset = newOffset;
                it.add(subRuleToken);
                return;
            }
            it.remove();
            while (it.hasPrevious()) {
                SubRuleToken beforePrevious = it.previous();
                int beforePreviousEndOffset = beforePrevious.offset + beforePrevious.len;
                if (beforePreviousEndOffset < subRuleToken.offset) {
                    it.next();
                    break;
                }
                if (beforePrevious.offset == subRuleToken.offset) {
                    if (beforePrevious.len <= subRuleToken.len) {
                        it.remove();
                        break;
                    }
                    it.remove();
                    it.add(subRuleToken);
                    beforePrevious.offset = subRuleToken.offset + subRuleToken.len;
                    beforePrevious.len = beforePreviousEndOffset - beforePrevious.offset;
                    subRuleToken = null;
                    it.add(beforePrevious);
                    break;
                }
                if (beforePrevious.offset < subRuleToken.offset) {
                    if (beforePreviousEndOffset > subRuleToken.offset + subRuleToken.len) {
                        beforePrevious.len = subRuleToken.offset - beforePrevious.offset;
                        it.next();
                        it.add(subRuleToken);
                        int newEndOffset = subRuleToken.offset + subRuleToken.len;
                        it.add(new SubRuleToken(beforePrevious.token, newEndOffset, beforePreviousEndOffset - newEndOffset));
                        it.add(prev);
                        return;
                    }
                    if (subRuleToken.offset < beforePreviousEndOffset) {
                        beforePrevious.len = subRuleToken.offset - beforePrevious.offset;
                    }
                    it.next();
                    break;
                }
                if (beforePrevious.offset >= subRuleToken.offset + subRuleToken.len || beforePreviousEndOffset > subRuleToken.offset + subRuleToken.len) {
                    it.remove();
                    it.add(prev);
                    it.previous();
                    prev = beforePrevious;
                    continue;
                }
                it.remove();
            }
            if (subRuleToken != null) {
                int newOffset = subRuleToken.offset + subRuleToken.len;
                int prevEndOffset = prev.offset + prev.len;
                if (prev.offset < newOffset) {
                    prev.len = prevEndOffset - newOffset;
                    prev.offset = newOffset;
                }
                it.add(subRuleToken);
            }
            if (prev.len > 0) {
                it.add(prev);
            }
            return;
        }
        lst.add(subRuleToken);
    }

    public static void fillWithSubToken(IToken contentScope, IRegion contentRegion, LinkedList<SubRuleToken> lst) {
        int offset = contentRegion.getOffset();
        int len = contentRegion.getLength();
        SubRuleToken.fillWithSubToken(contentScope, offset, len, lst);
    }

    public static void fillWithSubToken(IToken contentScope, int offset, int len, LinkedList<SubRuleToken> lst) {
        int lastOffset = offset;
        int lastLen = 0;
        ListIterator<SubRuleToken> it = lst.listIterator();
        while (it.hasNext()) {
            SubRuleToken next = (SubRuleToken)it.next();
            if (next.offset > lastOffset + lastLen) {
                int off = lastOffset + lastLen;
                int l = next.offset - (lastOffset + lastLen);
                it.set(new SubRuleToken(contentScope, off, l));
                it.add(next);
            }
            lastOffset = next.offset;
            lastLen = next.len;
        }
        if (offset + len > lastOffset + lastLen) {
            int off = lastOffset + lastLen;
            int l = offset + len - (lastOffset + lastLen);
            lst.add(new SubRuleToken(contentScope, off, l));
        }
    }

    public List<SubRuleToken> getChildren() {
        return this.children;
    }

    public void fillWithTokensAtOffset(int offset, List<IToken> lst) {
        if (offset >= this.offset && offset <= this.offset + this.len) {
            lst.add(this.token);
            if (this.children != null) {
                for (SubRuleToken c : this.children) {
                    c.fillWithTokensAtOffset(offset, lst);
                }
            }
        }
    }
}

