/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import at.jta.Key;
import at.jta.Regor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.log.Log;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.PlatformUtils;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterProviderFactory;
import org.python.pydev.ui.pythonpathconf.AlreadyInstalledInterpreterProvider;
import org.python.pydev.ui.pythonpathconf.IInterpreterProvider;
import org.python.pydev.ui.pythonpathconf.IInterpreterProviderFactory;

public class PythonInterpreterProviderFactory
extends AbstractInterpreterProviderFactory {
    @Override
    public IInterpreterProvider[] getInterpreterProviders(IInterpreterProviderFactory.InterpreterType type) {
        if (type != IInterpreterProviderFactory.InterpreterType.PYTHON) {
            return null;
        }
        if (!PlatformUtils.isWindowsPlatform()) {
            LinkedHashSet<String> pathsToSearch = new LinkedHashSet<String>();
            try {
                Map<String, String> env = SimpleRunner.getDefaultSystemEnv(null);
                if (env.containsKey("PYTHON_HOME")) {
                    pathsToSearch.add(env.get("PYTHON_HOME"));
                }
                if (env.containsKey("PYTHONHOME")) {
                    pathsToSearch.add(env.get("PYTHONHOME"));
                }
                if (env.containsKey("PATH")) {
                    String path = env.get("PATH");
                    String separator = SimpleRunner.getPythonPathSeparator();
                    List split = StringUtils.split((String)path, (String)separator);
                    pathsToSearch.addAll(split);
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
            pathsToSearch.add("/usr/bin");
            pathsToSearch.add("/usr/local/bin");
            String[] ret = this.searchPaths(pathsToSearch, Arrays.asList("python", "python\\d(\\.\\d)*|pypy"), false);
            if (ret.length > 0) {
                return AlreadyInstalledInterpreterProvider.create("python", ret);
            }
        } else {
            ArrayList<String> foundVersions = new ArrayList<String>();
            try {
                Regor regor = new Regor();
                Key[] keyArray = new Key[]{Regor.HKEY_LOCAL_MACHINE, Regor.HKEY_CURRENT_USER};
                int n = keyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Key root = keyArray[n2];
                    Key key = regor.openKey(root, "Software\\Python\\PythonCore", 131097);
                    if (key != null) {
                        try {
                            List l = regor.listKeys(key);
                            for (Object o : l) {
                                Key openKey = regor.openKey(key, String.valueOf((String)o) + "\\InstallPath", 131097);
                                if (openKey == null) continue;
                                try {
                                    String parseValue;
                                    File file;
                                    byte[] buf = regor.readValue(openKey, "");
                                    if (buf == null || !(file = new File(parseValue = Regor.parseValue((byte[])buf), "python.exe")).isFile()) continue;
                                    foundVersions.add(file.toString());
                                }
                                finally {
                                    regor.closeKey(openKey);
                                }
                            }
                        }
                        finally {
                            regor.closeKey(key);
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            if (foundVersions.size() > 0) {
                return AlreadyInstalledInterpreterProvider.create("python", foundVersions.toArray(new String[foundVersions.size()]));
            }
        }
        return AlreadyInstalledInterpreterProvider.create("python", "python");
    }
}

