/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class JythonInterpreterManager
extends AbstractInterpreterManager {
    public JythonInterpreterManager(IPreferenceStore preferences) {
        super(preferences);
    }

    @Override
    protected String getPreferenceName() {
        return "JYTHON_INTERPRETER_PATH";
    }

    @Override
    public String getInterpreterUIName() {
        return "Jython";
    }

    @Override
    public Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException, JDTNotAvailableException {
        return JythonInterpreterManager.doCreateInterpreterInfo(executable, monitor, askUser);
    }

    @Override
    protected String getPreferencesPageId() {
        return "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageJython";
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException, JDTNotAvailableException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (!isJythonExecutable) {
            throw new RuntimeException("In order to get the info for the jython interpreter, a jar is needed (e.g.: jython.jar)");
        }
        File script = JythonInterpreterManager.getInterpreterInfoPy();
        Tuple<String, String> outTup = new SimpleJythonRunner().runAndGetOutputWithJar(FileUtils.getFileAbsolutePath((File)script), executable, null, null, null, monitor, "utf-8");
        String output = (String)outTup.o1;
        InterpreterInfo info = JythonInterpreterManager.createInfoFromOutput(monitor, outTup, askUser, executable, false);
        if (info == null) {
            return null;
        }
        info.executableOrJar = executable;
        List<File> jars = JavaVmLocationFinder.findDefaultJavaJars();
        for (File jar : jars) {
            info.libs.add(FileUtils.getFileAbsolutePath((File)jar));
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)output);
    }

    public int getInterpreterType() {
        return 1;
    }

    public String getManagerRelatedName() {
        return "jython";
    }
}

