/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.actions.container.PyContainerAction;

abstract class PyContainerFormatterAction
extends PyContainerAction {
    private final String verbPassed;
    private final String verbPresent;
    private final String verbPresentMsg;
    protected IFormatter formatter;
    protected Set<IFile> openFiles;

    PyContainerFormatterAction(String present, String presentMsg, String passed) {
        this.verbPassed = passed;
        this.verbPresent = present;
        this.verbPresentMsg = presentMsg;
    }

    abstract IFormatter createFormatter();

    @Override
    protected void beforeRun() {
        this.openFiles = PyAction.getOpenFiles();
        this.formatter = this.createFormatter();
    }

    @Override
    protected void afterRun(int formatted) {
        this.openFiles = null;
        this.formatter = null;
        MessageDialog.openInformation(null, (String)("Files " + this.verbPassed), (String)StringUtils.format((String)"%s %s files.", (Object[])new Object[]{StringUtils.getWithFirstUpper((String)this.verbPassed), formatted}));
    }

    @Override
    protected boolean confirmRun() {
        return MessageDialog.openConfirm(null, (String)("Confirm " + this.verbPresent), (String)("Are you sure that you want to recursively " + this.verbPresentMsg + " the python files from the selected folder(s)?\n" + "\n" + "It'll be applied to all the file-types specified in the preferences: PyDev > Editor > Code Style > File types.\n" + "\n" + "This action cannot be undone."));
    }

    @Override
    protected int doActionOnContainer(IContainer container, IProgressMonitor monitor) {
        int formatted = 0;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                final IResource c = iResourceArray[n2];
                if (monitor.isCanceled()) break;
                monitor.worked(1);
                if (c instanceof IContainer) {
                    formatted += this.doActionOnContainer((IContainer)c, monitor);
                } else if (c instanceof IFile && (name = c.getName()) != null) {
                    monitor.setTaskName("Formatting: " + name);
                    if (PythonPathHelper.isValidSourceFile(name)) {
                        IFile file = (IFile)c;
                        final IDocument doc = FileUtilsFileBuffer.getDocFromResource((IResource)c);
                        final boolean isOpenedFile = this.openFiles.contains(file);
                        try {
                            if (isOpenedFile) {
                                RunInUiThread.async((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            PyContainerFormatterAction.this.formatter.formatAll(doc, null, (IFile)c, isOpenedFile, true);
                                        }
                                        catch (SyntaxErrorException e) {
                                            Log.log((int)4, (String)("Could not " + PyContainerFormatterAction.this.verbPresentMsg + " file: " + name + " (invalid syntax)."), (Throwable)e);
                                        }
                                    }
                                });
                            } else {
                                this.formatter.formatAll(doc, null, (IFile)c, isOpenedFile, true);
                            }
                        }
                        catch (SyntaxErrorException e) {
                            Log.log((int)4, (String)("Could not " + this.verbPresentMsg + " file: " + name + " (invalid syntax)."), (Throwable)e);
                        }
                        ++formatted;
                        if (!isOpenedFile) {
                            file.setContents((InputStream)new ByteArrayInputStream(doc.get().getBytes()), true, true, monitor);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return formatted;
    }
}

