/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.sorter;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.python.pydev.navigator.PythonLabelProvider;
import org.python.pydev.navigator.elements.ISortedElement;
import org.python.pydev.navigator.elements.PythonNode;
import org.python.pydev.shared_core.structure.TreeNode;

public class PythonModelSorter
extends ViewerSorter {
    private PythonLabelProvider labelProvider = new PythonLabelProvider();

    public int category(Object element) {
        if (element instanceof TreeNode) {
            return ISortedElement.RANK_TREE_NODE;
        }
        if (element instanceof ISortedElement) {
            ISortedElement iSortedElement = (ISortedElement)element;
            return iSortedElement.getRank();
        }
        if (element instanceof IContainer) {
            return ISortedElement.RANK_REGULAR_FOLDER;
        }
        if (element instanceof IFile) {
            return ISortedElement.RANK_REGULAR_FILE;
        }
        if (element instanceof IResource) {
            return ISortedElement.RANK_REGULAR_RESOURCE;
        }
        return ISortedElement.UNKNOWN_ELEMENT;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (e1 instanceof PythonNode && e2 instanceof PythonNode) {
            return 0;
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        String name1 = this.getLabel(viewer, e1);
        String name2 = this.getLabel(viewer, e2);
        int compare = this.getComparator().compare(name1, name2);
        return compare;
    }

    private String getLabel(Viewer viewer, Object e1) {
        String text = this.labelProvider.getText(e1);
        return text;
    }
}

