/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.ModuleRenameRefactoringRequest;
import org.python.pydev.editor.refactoring.PyRefactoringRequest;
import org.python.pydev.navigator.actions.Helpers;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;

public class PyRenameResourceAction
extends RenameResourceAction {
    private ISelectionProvider provider;
    private List<IResource> selected;
    private IFolder renamedFolder;
    private List<IResource> preResources;
    private Shell shell;

    public PyRenameResourceAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell);
        this.shell = shell;
        this.provider = selectionProvider;
    }

    protected String queryNewResourceName(final IResource resource) {
        final IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (resource.getName().equals(string)) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                IStatus status = workspace.validateName(string, resource.getType());
                if (!status.isOK()) {
                    return status.getMessage();
                }
                if (workspace.getRoot().exists(prefix.append(string))) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameExists;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.shell, IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, resource.getName(), validator);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public boolean isEnabled() {
        IStructuredSelection sSelection;
        this.selected = new ArrayList<IResource>();
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() >= 1) {
            for (Object element : sSelection) {
                IAdaptable adaptable;
                IResource resource;
                if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null && resource.isAccessible()) {
                    this.selected.add(resource);
                    continue;
                }
                this.selected = null;
                return false;
            }
        }
        return true;
    }

    private void updatePyPath() {
        if (this.renamedFolder == null) {
            return;
        }
        IProject project = this.renamedFolder.getProject();
        IPath oldPath = this.renamedFolder.getFullPath();
        try {
            IPythonPathNature pythonPathNature = PythonNature.getPythonPathNature(project);
            if (pythonPathNature == null) {
                return;
            }
            OrderedMap projectSourcePathMap = pythonPathNature.getProjectSourcePathResolvedToUnresolvedMap();
            LinkedListWarningOnSlowOperations sourcePaths = new LinkedListWarningOnSlowOperations();
            ArrayList<Object> actualPaths = new ArrayList<Object>();
            for (String pathName : projectSourcePathMap.keySet()) {
                sourcePaths.add(new Path(pathName));
                actualPaths.add(new Path((String)projectSourcePathMap.get((Object)pathName)));
            }
            ArrayList<IResource> postResources = new ArrayList<IResource>();
            IResource[] iResourceArray = this.renamedFolder.getParent().members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                postResources.add(r);
                ++n2;
            }
            for (IResource r : this.preResources) {
                postResources.remove(r);
            }
            if (postResources.size() == 0) {
                return;
            }
            if (postResources.size() > 1) {
                Log.log((String)"Unexpected error. There is more than one renamed file.");
                return;
            }
            boolean changedSomething = false;
            IPath newPath = ((IResource)postResources.get(0)).getFullPath();
            int i = 0;
            while (sourcePaths.size() > 0) {
                IPath sourcePath = (IPath)sourcePaths.remove(0);
                if (oldPath.equals((Object)sourcePath)) {
                    actualPaths.set(i, ((IPath)actualPaths.get(i)).removeLastSegments(1).append(newPath.lastSegment()));
                    changedSomething = true;
                } else if (oldPath.isPrefixOf(sourcePath)) {
                    sourcePath = newPath.append(sourcePath.removeFirstSegments(newPath.segmentCount()));
                    IPath actualPath = (IPath)actualPaths.get(i);
                    int match = 0;
                    int segS = sourcePath.segmentCount();
                    int segV = actualPath.segmentCount();
                    while (match <= segS && match <= segV && sourcePath.segment(segS - 1 - match).equals(actualPath.segment(segV - 1 - match))) {
                        ++match;
                    }
                    actualPaths.set(i, actualPath.removeLastSegments(match + 1).append(sourcePath.removeFirstSegments(segS - match - 1)));
                    changedSomething = true;
                }
                ++i;
            }
            if (!changedSomething) {
                return;
            }
            pythonPathNature.setProjectSourcePath(StringUtils.join((String)"|", actualPaths));
            PythonNature.getPythonNature(project).rebuildPath();
        }
        catch (CoreException e) {
            Log.log((int)4, (String)"Unexpected error setting project properties", (Throwable)e);
        }
    }

    protected List<IResource> getSelectedResources() {
        return this.selected;
    }

    public IStructuredSelection getStructuredSelection() {
        return new StructuredSelection(this.selected);
    }

    public void run() {
        IResource[] editorInput;
        int n;
        if (!this.isEnabled()) {
            return;
        }
        IEditorPart[] dirtyEditors = Helpers.checkValidateState();
        List<IResource> resources = this.getSelectedResources();
        if (resources.size() != 1) {
            DialogHelpers.openWarning((String)"Can only rename one element.", (String)"One element must be selected for rename.");
            return;
        }
        IResource r = resources.get(0);
        if (r instanceof IFile) {
            IEditorPart[] iEditorPartArray = dirtyEditors;
            n = dirtyEditors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart iEditorPart = iEditorPartArray[n2];
                editorInput = iEditorPart.getEditorInput();
                Object input = editorInput.getAdapter(IResource.class);
                if (r.equals(input)) {
                    iEditorPart.doSave(null);
                }
                ++n2;
            }
        } else if (r instanceof IFolder) {
            try {
                IResource[] members;
                this.renamedFolder = (IFolder)r;
                this.preResources = new ArrayList<IResource>();
                editorInput = members = this.renamedFolder.getParent().members();
                int n3 = members.length;
                n = 0;
                while (n < n3) {
                    IResource m = editorInput[n];
                    this.preResources.add(m);
                    ++n;
                }
            }
            catch (CoreException e) {
                Log.log((int)4, (String)"Unexpected error reading parent properties", (Throwable)e);
                this.renamedFolder = null;
                this.preResources = null;
            }
        } else {
            this.renamedFolder = null;
            this.preResources = null;
        }
        IProject project = r.getProject();
        PythonNature n4 = PythonNature.getPythonNature(project);
        if (n4 != null && (!(r instanceof IFile) || PythonPathHelper.isValidSourceFile((IFile)r))) {
            try {
                String resolveModule = n4.resolveModule(r);
                if (resolveModule != null && !resolveModule.endsWith(".__init__")) {
                    IFile file = null;
                    boolean foundAsInit = false;
                    if (r instanceof IContainer) {
                        file = PythonPathHelper.getFolderInit((IContainer)r);
                        foundAsInit = true;
                    } else if (r instanceof IFile) {
                        file = (IFile)r;
                    }
                    if (file != null && file.exists()) {
                        ModuleRenameRefactoringRequest request = new ModuleRenameRefactoringRequest(file.getLocation().toFile(), n4, null);
                        if (!foundAsInit) {
                            request.setFileResource(file);
                        }
                        AbstractPyRefactoring.getPyRefactoring().rename(new PyRefactoringRequest(request));
                        return;
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        super.run();
        this.updatePyPath();
        this.renamedFolder = null;
        this.preResources = null;
    }
}

