/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.navigator.PythonpathTreeNode;
import org.python.pydev.navigator.PythonpathZipChildTreeNode;
import org.python.pydev.navigator.actions.PyOpenPythonFileAction;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_ui.editor_input.PydevZipFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileStorage;

public class PyOpenResourceAction
extends PyOpenPythonFileAction {
    private IWorkbenchPage page;

    public PyOpenResourceAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        super(page, selectionProvider);
        this.page = page;
        this.setText("Open");
    }

    @Override
    protected void openFiles(PythonpathTreeNode[] pythonPathFilesSelected) {
        PythonpathTreeNode[] pythonpathTreeNodeArray = pythonPathFilesSelected;
        int n = pythonPathFilesSelected.length;
        int n2 = 0;
        while (n2 < n) {
            PythonpathTreeNode n3 = pythonpathTreeNodeArray[n2];
            try {
                if (PythonPathHelper.isValidSourceFile(n3.file.getName())) {
                    new PyOpenAction().run(new ItemPointer(n3.file));
                } else {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(n3.file.toURI());
                    IDE.openEditorOnFileStore((IWorkbenchPage)this.page, (IFileStore)fileStore);
                }
            }
            catch (PartInitException e) {
                Log.log((Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    protected void openFiles(PythonpathZipChildTreeNode[] pythonPathFilesSelected) {
        PythonpathZipChildTreeNode[] pythonpathZipChildTreeNodeArray = pythonPathFilesSelected;
        int n = pythonPathFilesSelected.length;
        int n2 = 0;
        while (n2 < n) {
            PythonpathZipChildTreeNode n3 = pythonpathZipChildTreeNodeArray[n2];
            try {
                if (PythonPathHelper.isValidSourceFile(n3.zipPath)) {
                    new PyOpenAction().run(new ItemPointer(n3.zipStructure.file, new Location(), new Location(), null, n3.zipPath));
                } else {
                    IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
                    IEditorDescriptor defaultEditor = editorReg.getDefaultEditor(n3.zipPath);
                    PydevZipFileStorage storage = new PydevZipFileStorage(n3.zipStructure.file, n3.zipPath);
                    PydevZipFileEditorInput input = new PydevZipFileEditorInput(storage);
                    if (defaultEditor != null) {
                        IDE.openEditor((IWorkbenchPage)this.page, (IEditorInput)input, (String)defaultEditor.getId());
                    } else {
                        IDE.openEditor((IWorkbenchPage)this.page, (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor");
                    }
                }
            }
            catch (PartInitException e) {
                Log.log((Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    protected void openFiles(List<IFile> filesSelected) {
        for (IFile f : filesSelected) {
            PythonPathHelper.markAsPyDevFileIfDetected(f);
            try {
                IDE.openEditor((IWorkbenchPage)this.page, (IFile)f);
            }
            catch (PartInitException e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public boolean isEnabledForSelectionWithoutContainers() {
        this.fillSelections();
        return this.pythonPathFilesSelected.size() > 0 || this.pythonPathZipFilesSelected.size() > 0;
    }
}

