/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.core.IPyStackFrame;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editorinput.EditorInputFactory;
import org.python.pydev.editorinput.PyFileLabelProvider;
import org.python.pydev.editorinput.PySourceLocatorPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.locator.GetContainers;
import org.python.pydev.shared_core.locator.GetFiles;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.editor_input.EditorInputUtils;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PySourceLocatorBase {
    private static final GetFiles getFiles = new GetFiles(){

        protected IFile getFileInProject(IPath location, IProject project) {
            IFile file = super.getFileInProject(location, project);
            if (file != null) {
                return file;
            }
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                try {
                    Set projectSourcePathSet = pythonPathNature.getProjectSourcePathFolderSet();
                    for (IResource iResource : projectSourcePathSet) {
                        IContainer iContainer;
                        if (!(iResource instanceof IContainer) || (file = this.getFileInContainer(location, iContainer = (IContainer)iResource)) == null) continue;
                        return file;
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };
    private static final GetContainers getContainers = new GetContainers(){

        protected IContainer getContainerInProject(IPath location, IProject project) {
            IContainer file = super.getContainerInProject(location, project);
            if (file != null) {
                return file;
            }
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                try {
                    Set projectSourcePathSet = pythonPathNature.getProjectSourcePathFolderSet();
                    for (IResource iResource : projectSourcePathSet) {
                        IContainer iContainer;
                        if (!(iResource instanceof IContainer) || (file = this.getContainerInContainer(location, iContainer = (IContainer)iResource)) == null) continue;
                        return file;
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };

    public IEditorInput createEditorInput(IPath path, IProject project) {
        return this.createEditorInput(path, true, null, project);
    }

    public IEditorInput createEditorInput(IPath path) {
        return this.createEditorInput(path, true, null, null);
    }

    public IFile[] getFilesForLocation(IPath location, IProject project, boolean stopOnFirst) {
        return getFiles.getFilesForLocation(location, project, stopOnFirst);
    }

    public IFile getFileForLocation(IPath location, IProject project) {
        return getFiles.getFileForLocation(location, project);
    }

    public IFile getWorkspaceFile(File file, IProject project) {
        return this.getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()), project);
    }

    public IFile[] getWorkspaceFiles(File file) {
        boolean stopOnFirst = false;
        IFile[] files = this.getFilesForLocation(Path.fromOSString((String)file.getAbsolutePath()), null, stopOnFirst);
        if (files == null || files.length == 0) {
            return null;
        }
        return files;
    }

    public IContainer getContainerForLocation(IPath location, IProject project) {
        return getContainers.getContainerForLocation(location, project);
    }

    public IContainer[] getContainersForLocation(IPath location) {
        boolean stopOnFirst = false;
        return getContainers.getContainersForLocation(location, null, stopOnFirst);
    }

    public IEditorInput createEditorInput(IPath path, boolean askIfDoesNotExist, IPyStackFrame pyStackFrame, IProject project) {
        IEditorInput edInput;
        block20: {
            IFile fileForLocation;
            int onSourceNotFound = PySourceLocatorPrefs.getOnSourceNotFound();
            edInput = null;
            File systemFile = path.toFile();
            IEditorInput input = this.getEditorInputFromExistingEditors(systemFile);
            if (input != null) {
                return input;
            }
            String pathTranslation = PySourceLocatorPrefs.getPathTranslation(path);
            if (pathTranslation != null) {
                if (!pathTranslation.equals("DONTASK")) {
                    path = Path.fromOSString((String)pathTranslation);
                } else {
                    askIfDoesNotExist = false;
                }
            }
            if ((fileForLocation = this.getFileForLocation(path, project)) != null && fileForLocation.exists()) {
                return new FileEditorInput(fileForLocation);
            }
            if (systemFile.exists()) {
                edInput = EditorInputFactory.create(systemFile, true);
            }
            if (edInput == null) {
                input = this.getEditorInputFromExistingEditors(systemFile.getName());
                if (input != null) {
                    return input;
                }
                if (askIfDoesNotExist && (onSourceNotFound == 0 || onSourceNotFound == 1)) {
                    File file;
                    IPath location;
                    IWorkspace w = ResourcesPlugin.getWorkspace();
                    List<IFile> likelyFiles = this.getLikelyFiles(path, w);
                    IFile iFile = this.selectWorkspaceFile(likelyFiles.toArray(new IFile[0]));
                    if (iFile != null && (location = iFile.getLocation()) != null) {
                        PySourceLocatorPrefs.addPathTranslation(path, location);
                        return new FileEditorInput(iFile);
                    }
                    IEditorInput pydevFileEditorInput = this.selectFilesystemFileForPath(path);
                    input = pydevFileEditorInput;
                    if (input != null && (file = EditorInputUtils.getFile((IEditorInput)pydevFileEditorInput)) != null) {
                        PySourceLocatorPrefs.addPathTranslation(path, Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)file)));
                        return input;
                    }
                    PySourceLocatorPrefs.setIgnorePathTranslation(path);
                }
            }
            if (edInput == null && (onSourceNotFound == 1 || onSourceNotFound == 2) && pyStackFrame != null) {
                try {
                    String fileContents = pyStackFrame.getFileContents();
                    if (fileContents == null || fileContents.length() <= 0) break block20;
                    String lastSegment = path.lastSegment();
                    File workspaceMetadataFile = PydevPlugin.getWorkspaceMetadataFile("temporary_files");
                    if (!workspaceMetadataFile.exists()) {
                        workspaceMetadataFile.mkdirs();
                    }
                    File file = new File(workspaceMetadataFile, lastSegment);
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {}
                    FileUtils.writeStrToFile((String)fileContents, (File)file);
                    try {
                        file.setReadOnly();
                    }
                    catch (Exception exception) {}
                    edInput = EditorInputFactory.create(file, true);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return edInput;
    }

    private IEditorInput getEditorInputFromExistingEditors(File matchFile) {
        return new FindFromExistingEditorsFile(matchFile).findFromOpenedPyEdits();
    }

    private IEditorInput getEditorInputFromExistingEditors(String matchName) {
        return new FindFromExistingEditorsName(matchName).findFromOpenedPyEdits();
    }

    protected IEditorInput selectFilesystemFileForPath(final IPath path) {
        final ArrayList l = new ArrayList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog dialog = new FileDialog(shell);
                dialog.setText(path + " - select correspondent filesystem file.");
                String[] wildcardValidSourceFiles = FileTypesPreferencesPage.getWildcardValidSourceFiles();
                wildcardValidSourceFiles = StringUtils.addString((String[])wildcardValidSourceFiles, (String)"*");
                dialog.setFilterExtensions(wildcardValidSourceFiles);
                String string = dialog.open();
                if (string != null) {
                    l.add(string);
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (l.size() > 0) {
            String fileAbsolutePath = FileUtils.getFileAbsolutePath((String)((String)l.get(0)));
            return EditorInputFactory.create(new File(fileAbsolutePath), true);
        }
        return null;
    }

    private List<IFile> getLikelyFiles(IPath path, IWorkspace w) {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            IResource[] resources = w.getRoot().members();
            this.getLikelyFiles(path, ret, resources);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    private void getLikelyFiles(IPath path, List<IFile> ret, IResource[] resources) throws CoreException {
        String strPath = path.removeFileExtension().lastSegment().toLowerCase();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile f = (IFile)resource;
                if (PythonPathHelper.isValidSourceFile(f) && resource.getFullPath().removeFileExtension().lastSegment().toLowerCase().equals(strPath)) {
                    ret.add((IFile)resource);
                }
            } else if (resource instanceof IContainer) {
                this.getLikelyFiles(path, ret, ((IContainer)resource).members());
            }
            ++n2;
        }
    }

    private IFile selectWorkspaceFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final ArrayList selected = new ArrayList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new PyFileLabelProvider());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("File may be matched to multiple files in the workspace.");
                if (dialog.open() == 0) {
                    selected.add((IFile)dialog.getFirstResult());
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (selected.size() > 0) {
            return (IFile)selected.get(0);
        }
        return null;
    }

    private static abstract class FindFromExistingEditors {
        private final Object matchName;

        protected FindFromExistingEditors(Object matchName) {
            this.matchName = matchName;
        }

        public IEditorInput findFromOpenedPyEdits() {
            Object ret = PyEdit.iterOpenEditorsUntilFirstReturn(new ICallback<Object, PyEdit>(){

                public Object call(PyEdit pyEdit) {
                    File editorFile;
                    IPathEditorInput pathEditorInput;
                    IPath localPath;
                    IEditorInput editorInput = pyEdit.getEditorInput();
                    if (editorInput instanceof IPathEditorInput ? (localPath = (pathEditorInput = (IPathEditorInput)editorInput).getPath()) != null && this.matchesPath(matchName, editorInput, localPath) : (editorFile = pyEdit.getEditorFile()) != null && this.matchesFile(matchName, editorInput, editorFile)) {
                        return editorInput;
                    }
                    return null;
                }
            });
            return (IEditorInput)ret;
        }

        protected abstract boolean matchesFile(Object var1, IEditorInput var2, File var3);

        protected abstract boolean matchesPath(Object var1, IEditorInput var2, IPath var3);
    }

    private static class FindFromExistingEditorsFile
    extends FindFromExistingEditors {
        protected FindFromExistingEditorsFile(File matchFile) {
            super(matchFile);
        }

        @Override
        protected boolean matchesFile(Object match, IEditorInput editorInput, File editorFile) {
            File matchFile = (File)match;
            return editorFile.equals(matchFile);
        }

        @Override
        protected boolean matchesPath(Object match, IEditorInput editorInput, IPath localPath) {
            File matchFile = (File)match;
            return Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)matchFile)).equals((Object)localPath);
        }
    }

    private static class FindFromExistingEditorsName
    extends FindFromExistingEditors {
        protected FindFromExistingEditorsName(String matchName) {
            super(matchName);
        }

        @Override
        protected boolean matchesFile(Object match, IEditorInput editorInput, File editorFile) {
            String matchName = (String)match;
            return editorFile.getName().equals(matchName);
        }

        @Override
        protected boolean matchesPath(Object match, IEditorInput editorInput, IPath localPath) {
            String matchName = (String)match;
            String considerName = localPath.segment(localPath.segmentCount() - 1);
            return matchName.equals(considerName);
        }
    }
}

