/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.preferences;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;
import org.python.pydev.shared_ui.field_editors.BooleanFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class PydevTypingPrefs
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String AUTO_PAR = "AUTO_PAR";
    public static final boolean DEFAULT_AUTO_PAR = true;
    public static final String AUTO_LINK = "AUTO_LINK";
    public static final boolean DEFAULT_AUTO_LINK = false;
    public static final String AUTO_INDENT_TO_PAR_LEVEL = "AUTO_INDENT_TO_PAR_LEVEL";
    public static final boolean DEFAULT_AUTO_INDENT_TO_PAR_LEVEL = true;
    public static final String AUTO_INDENT_AFTER_PAR_WIDTH = "AUTO_INDENT_AFTER_PAR_WIDTH";
    public static final int DEFAULT_AUTO_INDENT_AFTER_PAR_WIDTH = 1;
    public static final String AUTO_DEDENT_ELSE = "AUTO_DEDENT_ELSE";
    public static final boolean DEFAULT_AUTO_DEDENT_ELSE = true;
    public static final String SMART_INDENT_PAR = "SMART_INDENT_PAR";
    public static final boolean DEFAULT_SMART_INDENT_PAR = true;
    public static final String SMART_LINE_MOVE = "SMART_LINE_MOVE";
    public static final boolean DEFAULT_SMART_LINE_MOVE = false;
    public static final String AUTO_COLON = "AUTO_COLON";
    public static final boolean DEFAULT_AUTO_COLON = true;
    public static final String AUTO_BRACES = "AUTO_BRACES";
    public static final boolean DEFAULT_AUTO_BRACES = true;
    public static final String AUTO_WRITE_IMPORT_STR = "AUTO_WRITE_IMPORT_STR";
    public static final boolean DEFAULT_AUTO_WRITE_IMPORT_STR = true;
    public static final String AUTO_LITERALS = "AUTO_LITERALS";
    public static final boolean DEFAULT_AUTO_LITERALS = true;
    public static final String AUTO_ADD_SELF = "AUTO_ADD_SELF";
    public static final boolean DEFAULT_AUTO_ADD_SELF = true;
    public static final int TOOLTIP_WIDTH = 80;

    public PydevTypingPrefs() {
        super(1);
        this.setDescription("Editor");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite initialParent;
        final Composite p = initialParent = this.getFieldEditorParent();
        String preference = AUTO_LINK;
        String text = "Enable link on automatic parenthesis or literals closing?";
        String tooltip = "Enabling this option will enable the linking mode after a parenthesis or literal is auto-closed.";
        this.addBooleanField(p, preference, text, tooltip);
        this.addBooleanField(p, AUTO_PAR, "Automatic parentheses insertion", "Enabling this option will enable automatic insertion of parentheses.  Specifically, whenever you hit a brace such as '(', '{', or '[', its related peer will be inserted and your cursor will be placed between the two braces.");
        final BooleanFieldEditorCustom autoIndentToParLevel = this.addBooleanField(p, AUTO_INDENT_TO_PAR_LEVEL, "After '(' indent to its level (indents by tabs if unchecked)", "");
        final IntegerFieldEditor intField = new IntegerFieldEditor(AUTO_INDENT_AFTER_PAR_WIDTH, "    Number of indentation levels to add:", p, 1);
        this.addField((FieldEditor)intField);
        Button checkBox = autoIndentToParLevel.getCheckBox(p);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                intField.setEnabled(!autoIndentToParLevel.getBooleanValue(), p);
            }
        });
        intField.setEnabled(!this.getPreferenceStore().getBoolean(AUTO_INDENT_TO_PAR_LEVEL), p);
        this.addBooleanField(p, AUTO_DEDENT_ELSE, "Automatic dedent of 'else:' and 'elif:'", "");
        this.addBooleanField(p, AUTO_BRACES, "Automatically skip matching braces when typing", "Enabling this option will enable automatically skipping matching braces if you try to insert them.  For example, if you have the following code:\n\ndef function(self):\n\n...with your cursor before the end parenthesis (after the 'f' in \"self\"), typing a ')' will simply move the cursor to the position after the ')' without inserting a new one.");
        this.addBooleanField(p, SMART_INDENT_PAR, "Use smart-indent?", "");
        this.addBooleanField(p, AUTO_COLON, "Automatic colon detection", "Enabling this feature will enable the editor to detect if you are trying to enter a colon which is already there.  Instead of inserting another colon, the editor will simply move your cursor to the next position after the colon.");
        this.addBooleanField(p, AUTO_LITERALS, "Automatic literal closing", "Automatically close literals (when ' or \" is added, another one is added to close it).");
        this.addBooleanField(p, AUTO_WRITE_IMPORT_STR, "Automatic insertion of the 'import' string on 'from xxx' ", "Enabling this will allow the editor to automatically write the'import' string when you write a space after you've written 'from xxx '.");
        this.addBooleanField(p, AUTO_ADD_SELF, "Add 'self' automatically when declaring methods?", "");
        KeySequence down = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.edit.text.moveLineDown");
        KeySequence up = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.edit.text.moveLineUp");
        String downKey = down != null ? down.format() : "Alt+Down";
        String upKey = up != null ? up.format() : "Alt+Up";
        this.addBooleanField(p, SMART_LINE_MOVE, StringUtils.format((String)"Smart move for line up  (%s) and line down (%s)?.", (Object[])new Object[]{upKey, downKey}), "");
        this.addField((FieldEditor)new LabelFieldEditor("__UNUSED__", "Note: smart move line up/down change applied on editor restart.", p));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private BooleanFieldEditorCustom addBooleanField(Composite p, String preference, String text, String tooltip) {
        BooleanFieldEditorCustom field = new BooleanFieldEditorCustom(preference, text, 0, p);
        this.addField((FieldEditor)field);
        field.setTooltip(p, WrapAndCaseUtils.wrap((String)tooltip, (int)80));
        return field;
    }

    public void init(IWorkbench workbench) {
    }
}

