/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.templates;

import java.io.File;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codecompletion.templates.DocumentTemplateContextWithIndent;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleViewer;

public final class PyDocumentTemplateContext
extends DocumentTemplateContextWithIndent {
    public ITextViewer viewer;

    PyDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, String indentTo, IIndentPrefs indentPrefs) {
        super(type, document, offset, length, indentTo, indentPrefs);
    }

    public PyDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, String indentTo, ITextViewer viewer) {
        this(type, document, offset, length, indentTo, PyDocumentTemplateContext.getIndentPrefs(viewer));
        this.viewer = viewer;
    }

    public PySelection createPySelection() {
        return new PySelection(this.getDocument(), this.getStart());
    }

    public Class<FastParser> getFastParserClass() {
        return FastParser.class;
    }

    public Class<NodeUtils> getNodeUtilsClass() {
        return NodeUtils.class;
    }

    public Class<FunctionDef> getFunctionDefClass() {
        return FunctionDef.class;
    }

    public Class<ClassDef> getClassDefClass() {
        return ClassDef.class;
    }

    public Class<BadLocationException> getBadLocationExceptionClass() {
        return BadLocationException.class;
    }

    public boolean isCythonFile() {
        if (this.viewer instanceof PySourceViewer) {
            return ((PySourceViewer)this.viewer).getEdit().isCythonFile();
        }
        return false;
    }

    public File getEditorFile() {
        if (this.viewer instanceof PySourceViewer) {
            return ((PySourceViewer)this.viewer).getEdit().getEditorFile();
        }
        return new File("");
    }

    public int getGrammarVersion() {
        IScriptConsoleViewer v;
        IInterpreterInfo interpreterInfo;
        if (this.viewer instanceof PySourceViewer) {
            try {
                IPythonNature nature = ((PySourceViewer)this.viewer).getEdit().getPythonNature();
                if (nature != null) {
                    return nature.getGrammarVersion();
                }
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        if (this.viewer instanceof IScriptConsoleViewer && (interpreterInfo = (IInterpreterInfo)(v = (IScriptConsoleViewer)this.viewer).getInterpreterInfo()) != null) {
            return interpreterInfo.getGrammarVersion();
        }
        return 13;
    }

    public String getModuleName() {
        if (this.viewer instanceof PySourceViewer) {
            try {
                PySourceViewer pyViewer = (PySourceViewer)this.viewer;
                PyEdit edit = pyViewer.getEdit();
                IPythonNature nature = edit.getPythonNature();
                if (nature != null) {
                    return nature.resolveModule(edit.getEditorFile());
                }
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        return "";
    }

    private static IIndentPrefs getIndentPrefs(ITextViewer viewer) {
        if (viewer instanceof PySourceViewer) {
            PySourceViewer pyViewer = (PySourceViewer)viewer;
            return pyViewer.getEdit().getIndentPrefs();
        }
        return DefaultIndentPrefs.get(null);
    }
}

