/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.ModulesManagerWithBuild;
import org.python.pydev.editor.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.PredefinedSourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public final class SystemModulesManager
extends ModulesManagerWithBuild
implements ISystemModulesManager {
    private static final String DIR_NAME_FOR_COMPILED_CACHE = "shell";
    private transient IPythonNature nature;
    private InterpreterInfo info;
    private final LRUCache<String, String> builtinsNotConsidered = new LRUCache(500);
    private transient Map<File, Long> predefinedFilesNotParsedToTimestamp;

    public SystemModulesManager(InterpreterInfo info) {
        this.info = info;
    }

    public void setInfo(InterpreterInfo info) {
        this.info = info;
    }

    public InterpreterInfo getInfo() {
        return this.info;
    }

    public void endProcessing() {
        this.save();
    }

    public String[] getBuiltins() {
        return this.info.getBuiltins();
    }

    public void setPythonNature(IPythonNature nature) {
        Assert.isTrue((boolean)(nature instanceof SystemPythonNature));
        Assert.isTrue((((SystemPythonNature)nature).info == this.info ? 1 : 0) != 0);
        this.nature = nature;
    }

    public IPythonNature getNature() {
        if (this.nature == null) {
            IInterpreterManager manager = this.getInterpreterManager();
            this.nature = new SystemPythonNature(manager, this.info);
        }
        return this.nature;
    }

    public IInterpreterManager getInterpreterManager() {
        int interpreterType = this.info.getInterpreterType();
        switch (interpreterType) {
            case 1: {
                return PydevPlugin.getJythonInterpreterManager();
            }
            case 0: {
                return PydevPlugin.getPythonInterpreterManager();
            }
            case 2: {
                return PydevPlugin.getIronpythonInterpreterManager();
            }
        }
        throw new RuntimeException("Don't know how to handle: " + interpreterType);
    }

    public ISystemModulesManager getSystemModulesManager() {
        return this;
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        return this.getModule(name, nature, dontSearchInit);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        return super.resolveModule(full);
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        if (interpreter == null) {
            throw new RuntimeException("The interpreter must be specified (received null)");
        }
        return interpreter.getPythonPath();
    }

    public IModule getRelativeModule(String name, IPythonNature nature) {
        return super.getModule(name, nature, true);
    }

    @Override
    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
        String[] builtins = this.getBuiltins();
        if (builtins != null) {
            int i = 0;
            while (i < builtins.length) {
                String name = builtins[i];
                ModulesKey k = new ModulesKey(name, null);
                keys.put(k, k);
                ++i;
            }
        }
        super.onChangePythonpath(keys);
    }

    private boolean contains(IToken[] tokens, String rep) {
        IToken[] iTokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken token = iTokenArray[n2];
            if (token.getRepresentation().equals(rep)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public AbstractModule getBuiltinModule(String name, boolean dontSearchInit) {
        AbstractModule n = null;
        String[] builtins = this.getBuiltins();
        if (builtins == null || this.info == null) {
            return null;
        }
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        File predefinedModule = this.info.getPredefinedModule(name);
        if (predefinedModule != null && predefinedModule.exists()) {
            PredefinedSourceModule predefinedSourceModule;
            keyForCacheAccess.name = name;
            keyForCacheAccess.file = predefinedModule;
            n = cache.getObj(keyForCacheAccess, this);
            if (n instanceof PredefinedSourceModule && (predefinedSourceModule = (PredefinedSourceModule)n).isSynched()) {
                return n;
            }
            boolean tryToParse = true;
            Long lastModified = null;
            if (this.predefinedFilesNotParsedToTimestamp == null) {
                this.predefinedFilesNotParsedToTimestamp = new HashMap<File, Long>();
            } else {
                Long lastTimeChanged = this.predefinedFilesNotParsedToTimestamp.get(predefinedModule);
                if (lastTimeChanged != null) {
                    lastModified = FileUtils.lastModified((File)predefinedModule);
                    if (lastTimeChanged.equals(lastModified)) {
                        tryToParse = false;
                    } else {
                        this.predefinedFilesNotParsedToTimestamp.remove(predefinedModule);
                    }
                }
            }
            if (tryToParse) {
                try {
                    IDocument doc = FileUtilsFileBuffer.getDocFromFile((File)predefinedModule);
                    IGrammarVersionProvider provider = new IGrammarVersionProvider(){

                        public int getGrammarVersion() throws MisconfigurationException {
                            return 99;
                        }
                    };
                    BaseParser.ParseOutput obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, provider, name, predefinedModule));
                    if (obj.error != null) {
                        if (lastModified == null) {
                            lastModified = FileUtils.lastModified((File)predefinedModule);
                        }
                        this.predefinedFilesNotParsedToTimestamp.put(predefinedModule, lastModified);
                        Log.log((String)("Unable to parse: " + predefinedModule), (Throwable)obj.error);
                    } else if (obj.ast != null) {
                        n = new PredefinedSourceModule(name, predefinedModule, (SimpleNode)obj.ast, obj.error);
                        this.doAddSingleModule(keyForCacheAccess, n);
                        return n;
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        }
        boolean foundStartingWithBuiltin = false;
        FastStringBuffer buffer = null;
        int i = 0;
        while (i < builtins.length) {
            String forcedBuiltin = builtins[i];
            if (name.startsWith(forcedBuiltin)) {
                if (name.length() > forcedBuiltin.length() && name.charAt(forcedBuiltin.length()) == '.') {
                    foundStartingWithBuiltin = true;
                    keyForCacheAccess.name = name;
                    n = cache.getObj(keyForCacheAccess, this);
                    if (n == null && !dontSearchInit) {
                        if (buffer == null) {
                            buffer = new FastStringBuffer();
                        } else {
                            buffer.clear();
                        }
                        keyForCacheAccess.name = buffer.append(name).append(".__init__").toString();
                        n = cache.getObj(keyForCacheAccess, this);
                    }
                    if (n instanceof EmptyModule || n instanceof SourceModule) {
                        n = new CompiledModule(name, this);
                        this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                        return n;
                    }
                }
                if (name.equals(forcedBuiltin)) {
                    keyForCacheAccess.name = name;
                    n = cache.getObj(keyForCacheAccess, this);
                    if (n == null || n instanceof EmptyModule || n instanceof SourceModule) {
                        n = new CompiledModule(name, this);
                        this.doAddSingleModule(new ModulesKey(n.getName(), null), n);
                        return n;
                    }
                }
                if (n instanceof CompiledModule) {
                    return n;
                }
            }
            ++i;
        }
        if (foundStartingWithBuiltin) {
            if (this.builtinsNotConsidered.getObj((Object)name) != null) {
                return null;
            }
            n = new CompiledModule(name, this);
            IToken[] globalTokens = n.getGlobalTokens();
            if (globalTokens.length > 0 && this.contains(globalTokens, "__file__")) {
                this.doAddSingleModule(new ModulesKey(name, null), n);
                return n;
            }
            this.builtinsNotConsidered.add((Object)name, (Object)name);
            return null;
        }
        return null;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        AbstractModule n = this.getBuiltinModule(name, dontSearchInit);
        if (n != null) {
            return n;
        }
        return super.getModule(name, nature, dontSearchInit);
    }

    public IModule getModuleWithoutBuiltins(String name, IPythonNature nature, boolean dontSearchInit) {
        return super.getModule(name, nature, dontSearchInit);
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        IModule module = this.getModule(name, nature, checkSystemManager, dontSearchInit);
        if (module != null) {
            return new Tuple((Object)module, (Object)this);
        }
        return null;
    }

    public void load() throws IOException {
        File workspaceMetadataFile = this.getIoDirectory();
        ModulesManager.loadFromFile(this, workspaceMetadataFile);
        DeltaSaver d = this.deltaSaver = new DeltaSaver(this.getIoDirectory(), "v1_sys_astdelta", readFromFileMethod, toFileMethod);
        d.processDeltas((IDeltaProcessor)this);
    }

    public void save() {
        File workspaceMetadataFile = this.getIoDirectory();
        DeltaSaver d = this.deltaSaver;
        if (d != null) {
            d.clearAll();
        }
        this.saveToFile(workspaceMetadataFile);
    }

    public File getIoDirectory() {
        return this.info.getIoDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeysAndSave(PyPublicTreeMap<ModulesKey, ModulesKey> keysFound) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.clear();
            this.modulesKeys.putAll(keysFound);
        }
        this.save();
    }

    @Override
    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        block6: {
            try {
                File[] files;
                File d;
                File ioDirectory = this.getIoDirectory();
                if (ioDirectory == null || !(d = new File(ioDirectory, DIR_NAME_FOR_COMPILED_CACHE)).exists() || (files = d.listFiles()) == null) break block6;
                int i = 0;
                while (i < files.length) {
                    File f = files[i];
                    if (f.isFile()) {
                        try {
                            FileUtils.deleteFile((File)f);
                        }
                        catch (IOException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        super.changePythonPath(pythonpath, project, monitor);
    }

    public File getCompiledModuleCacheFile(String name) {
        File ioDirectory = this.getIoDirectory();
        if (ioDirectory != null) {
            File d = new File(ioDirectory, DIR_NAME_FOR_COMPILED_CACHE);
            if (!d.exists()) {
                d.mkdirs();
            }
            int len = name.length();
            String pre = "";
            if (len >= 3) {
                pre = name.substring(0, 3);
            } else if (len >= 2) {
                pre = name.substring(0, 2);
            } else if (len >= 1) {
                pre = name.substring(0, 1);
            }
            String post = name.contains(".") ? ".top" : ".inn";
            return new File(d, StringUtils.join((String)"", (Object[])new Object[]{pre, "_", StringUtils.md5((String)name), post}));
        }
        return null;
    }
}

