/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.UnpackInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.revisited.AssignCompletionInfo;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ReturnVisitor;
import org.python.pydev.shared_core.string.StringUtils;

public class AssignAnalysis {
    public static final Map<String, Integer> CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS = new HashMap<String, Integer>();

    static {
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("adapt".toLowerCase(), 2);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetSingleton".toLowerCase(), 1);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetImplementation".toLowerCase(), 1);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetAdapter".toLowerCase(), 1);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("get_adapter".toLowerCase(), 1);
    }

    public AssignCompletionInfo getAssignCompletions(ICodeCompletionASTManager manager, IModule module, ICompletionState state, ILocalScope localScope) {
        state.pushAssign();
        try {
            ArrayList<IToken> ret = new ArrayList<IToken>();
            Definition[] defs = new Definition[]{};
            if (module instanceof SourceModule) {
                SourceModule s = (SourceModule)module;
                try {
                    IToken[] tokens;
                    defs = s.findDefinition(state, state.getLine() + 1, state.getCol() + 1, state.getNature());
                    if (defs.length > 0) {
                        int i = 0;
                        while (i < defs.length) {
                            Definition definition = defs[i];
                            if (!(state.getAlreadySearchedInAssign(definition.line, definition.col, definition.module, definition.value, state.getActivationToken()) || state.getLine() == definition.line && state.getCol() == definition.col && definition.module != null && definition.module.equals(s) && state.checkFoudSameDefinition(definition.line, definition.col, definition.module))) {
                                List<IToken> found;
                                AssignDefinition assignDefinition = null;
                                if (definition instanceof AssignDefinition) {
                                    assignDefinition = (AssignDefinition)definition;
                                }
                                if (definition.ast instanceof FunctionDef) {
                                    found = this.addFunctionDefCompletionsFromReturn(manager, state, s, definition);
                                    ret.addAll(found);
                                } else {
                                    found = this.getNonFunctionDefCompletionsFromAssign(manager, state, s, definition, assignDefinition);
                                    ret.addAll(found);
                                }
                            }
                            ++i;
                        }
                    } else if (localScope != null && (tokens = this.searchInLocalTokens(manager, state, true, state.getLine() + 1, state.getCol() + 1, module, localScope, state.getActivationToken())) != null) {
                        ret.addAll(Arrays.asList(tokens));
                    }
                }
                catch (CompletionRecursionException completionRecursionException) {
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    throw new RuntimeException("Error when getting assign completions for:" + module.getName(), e);
                }
                catch (Throwable t) {
                    throw new RuntimeException("A throwable exception has been detected " + t.getClass());
                }
            }
            AssignCompletionInfo assignCompletionInfo = new AssignCompletionInfo(defs, ret);
            return assignCompletionInfo;
        }
        finally {
            state.popAssign();
        }
    }

    private List<IToken> addFunctionDefCompletionsFromReturn(ICodeCompletionASTManager manager, ICompletionState state, SourceModule s, Definition definition) throws CompletionRecursionException {
        ArrayList<IToken> ret = new ArrayList<IToken>();
        FunctionDef functionDef = (FunctionDef)definition.ast;
        String type = NodeUtils.getReturnTypeFromDocstring((SimpleNode)functionDef);
        if (type != null) {
            ICompletionState copy = state.getCopy();
            copy.setActivationToken(type);
            stmtType[] body = functionDef.body;
            if (body.length > 0) {
                copy.setLine(body[0].beginLine - 1);
                copy.setCol(body[0].beginColumn - 1);
            }
            IModule module = definition.module;
            state.checkDefinitionMemory(module, (IDefinition)definition);
            IToken[] tks = manager.getCompletionsForModule(module, copy);
            if (tks.length > 0) {
                ret.addAll(Arrays.asList(tks));
                return ret;
            }
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
            for (IPyDevCompletionParticipant participant : participants) {
                Collection<IToken> collection = participant.getCompletionsForType(copy);
                if (collection == null || collection.size() <= 0) continue;
                ret.addAll(collection);
                return ret;
            }
        }
        for (Return return1 : ReturnVisitor.findReturns((FunctionDef)functionDef)) {
            ICompletionState copy = state.getCopy();
            String act = NodeUtils.getFullRepresentationString((SimpleNode)return1.value);
            if (act == null) continue;
            copy.setActivationToken(act);
            copy.setLine(return1.value.beginLine - 1);
            copy.setCol(return1.value.beginColumn - 1);
            IModule module = definition.module;
            state.checkDefinitionMemory(module, (IDefinition)definition);
            IToken[] tks = manager.getCompletionsForModule(module, copy);
            if (tks.length <= 0) continue;
            ret.addAll(Arrays.asList(tks));
        }
        return ret;
    }

    private List<IToken> getNonFunctionDefCompletionsFromAssign(ICodeCompletionASTManager manager, ICompletionState state, SourceModule sourceModule, Definition definition, AssignDefinition assignDefinition) throws CompletionRecursionException {
        ArrayList<IToken> ret = new ArrayList<IToken>();
        if (definition.ast instanceof ClassDef) {
            state.setLookingFor(2);
            ret.addAll(((SourceModule)definition.module).getClassToks(state, manager, definition.ast));
        } else {
            boolean lookForAssign = true;
            if (assignDefinition != null) {
                IToken[] tokens;
                Assign assign = (Assign)assignDefinition.ast;
                if (assign.value instanceof Call) {
                    Integer parameterIndex;
                    Call call = (Call)assign.value;
                    String lastPart = FullRepIterable.getLastPart((String)assignDefinition.value);
                    if ("namedtuple".equals(lastPart) && call.args != null && call.args.length > 1) {
                        exprType args = call.args[1];
                        exprType[] elts = null;
                        if (args instanceof org.python.pydev.parser.jython.ast.List) {
                            org.python.pydev.parser.jython.ast.List list = (org.python.pydev.parser.jython.ast.List)args;
                            elts = list.elts;
                        } else if (args instanceof Tuple) {
                            Tuple tuple = (Tuple)args;
                            elts = tuple.elts;
                        } else if (args instanceof Set) {
                            Set set = (Set)args;
                            elts = set.elts;
                        }
                        if (elts != null) {
                            exprType[] exprTypeArray = elts;
                            int n = elts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                exprType exprType2 = exprTypeArray[n2];
                                if (exprType2 instanceof Str) {
                                    ret.add(new SourceToken((SimpleNode)exprType2, ((Str)exprType2).s, "", "", sourceModule.getName()));
                                }
                                ++n2;
                            }
                            return ret;
                        }
                        if (args instanceof Call) {
                            Call call2 = (Call)args;
                            if (call2.func instanceof Attribute) {
                                Attribute attribute = (Attribute)call2.func;
                                if ("split".equals(NodeUtils.getRepresentationString((SimpleNode)attribute.attr)) && attribute.value instanceof Str) {
                                    Str str = (Str)attribute.value;
                                    if (str.s != null) {
                                        List split = StringUtils.split((String)str.s, (String)" ");
                                        for (String string : split) {
                                            ret.add(new SourceToken((SimpleNode)str, string, "", "", sourceModule.getName()));
                                        }
                                        return ret;
                                    }
                                }
                            }
                        }
                    }
                    if ((parameterIndex = CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.get(lastPart.toLowerCase())) != null && call.args.length >= parameterIndex) {
                        String rep = NodeUtils.getFullRepresentationString((SimpleNode)call.args[parameterIndex - 1]);
                        HashSet hashSet = new HashSet();
                        ArrayList<String> lookForClass = new ArrayList<String>();
                        lookForClass.add(rep);
                        manager.getCompletionsForClassInLocalScope((IModule)sourceModule, state, true, false, lookForClass, hashSet);
                        if (hashSet.size() > 0) {
                            lookForAssign = false;
                            ret.addAll(hashSet);
                        }
                    }
                }
                if (lookForAssign && (tokens = this.searchInLocalTokens(manager, state, lookForAssign, definition.line, definition.col, definition.module, assignDefinition.scope, assignDefinition.value)) != null && tokens.length > 0) {
                    ret.addAll(Arrays.asList(tokens));
                    lookForAssign = false;
                }
            }
            if (lookForAssign) {
                IToken[] tks;
                state.setLookingFor(4);
                ICompletionState copy = state.getCopy();
                if (definition.ast instanceof Attribute) {
                    copy.setActivationToken(NodeUtils.getFullRepresentationString((SimpleNode)definition.ast));
                } else {
                    copy.setActivationToken(definition.value);
                }
                copy.setLine(definition.line);
                copy.setCol(definition.col);
                IModule module = definition.module;
                state.checkDefinitionMemory(module, (IDefinition)definition);
                if (assignDefinition != null) {
                    Collection interfaceForLocal = assignDefinition.scope.getInterfaceForLocal(assignDefinition.target);
                    ret.addAll(interfaceForLocal);
                }
                int unpackPos = -1;
                boolean unpackBackwards = false;
                if (assignDefinition != null) {
                    unpackPos = assignDefinition.unpackPos;
                    if (definition.ast instanceof Assign) {
                        Assign assign = (Assign)definition.ast;
                        if (assign.value instanceof Subscript) {
                            Subscript subscript = (Subscript)assign.value;
                            if (subscript.slice instanceof Index) {
                                Index index = (Index)subscript.slice;
                                exprType indexValue = index.value;
                                if (indexValue instanceof UnaryOp) {
                                    UnaryOp unaryOp = (UnaryOp)indexValue;
                                    if (unaryOp.op == 4) {
                                        unpackBackwards = true;
                                    }
                                    indexValue = unaryOp.operand;
                                }
                                if (indexValue instanceof Num) {
                                    Num num = (Num)indexValue;
                                    String rep = NodeUtils.getRepresentationString((SimpleNode)num);
                                    try {
                                        int subscriptIndex;
                                        unpackPos = subscriptIndex = Integer.parseInt(rep);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                            }
                        }
                    }
                }
                if (assignDefinition != null && unpackPos >= 0) {
                    tks = manager.getCompletionsUnpackingObject(module, copy, assignDefinition.scope, new UnpackInfo(false, unpackPos, unpackBackwards));
                    if (tks != null) {
                        ret.addAll(Arrays.asList(tks));
                    }
                } else {
                    tks = manager.getCompletionsForModule(module, copy, true, true);
                    ret.addAll(Arrays.asList(tks));
                }
            }
        }
        return ret;
    }

    public IToken[] searchInLocalTokens(ICodeCompletionASTManager manager, ICompletionState state, boolean lookForAssign, int line, int col, IModule module, ILocalScope scope, String activationToken) throws CompletionRecursionException {
        IToken[] allLocalTokens;
        IToken[] iTokenArray = allLocalTokens = scope.getAllLocalTokens();
        int n = allLocalTokens.length;
        int n2 = 0;
        while (n2 < n) {
            List<IToken> classToks;
            SourceToken srcToken;
            SimpleNode ast;
            IToken token = iTokenArray[n2];
            if (token.getRepresentation().equals(activationToken) && token instanceof SourceToken && (ast = (srcToken = (SourceToken)token).getAst()) instanceof ClassDef && module instanceof SourceModule && (classToks = ((SourceModule)module).getClassToks(state, manager, ast)).size() > 0) {
                return classToks.toArray(new IToken[0]);
            }
            ++n2;
        }
        ICompletionState copy = state.getCopy();
        copy.setLine(line);
        copy.setCol(col);
        copy.setActivationToken(activationToken);
        IToken[] tokens = manager.getCompletionsFromTokenInLocalScope(module, copy, false, false, scope);
        if (tokens != null && tokens.length > 0) {
            return tokens;
        }
        return null;
    }
}

