/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IToken;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;

public abstract class AbstractToken
implements IToken {
    protected String rep;
    protected String originalRep;
    protected String doc;
    protected String args;
    protected String parentPackage;
    public int type;
    private boolean originalHasRep;

    public AbstractToken(String rep, String doc, String args, String parentPackage, int type, String originalRep, boolean originalHasRep) {
        this(rep, doc, args, parentPackage, type);
        this.originalRep = originalRep;
        this.originalHasRep = originalHasRep;
    }

    public AbstractToken(String rep, String doc, String args, String parentPackage, int type) {
        this.rep = rep != null ? rep : "";
        this.args = args != null ? args : "";
        this.originalRep = this.rep;
        this.doc = doc != null ? doc : "";
        this.parentPackage = parentPackage != null ? parentPackage : "";
        this.type = type;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getRepresentation() {
        return this.rep;
    }

    public void setDocStr(String docStr) {
        this.doc = docStr;
    }

    public String getDocStr() {
        return this.doc;
    }

    public String getParentPackage() {
        return this.parentPackage;
    }

    public int getType() {
        return this.type;
    }

    public Image getImage() {
        return PyCodeCompletionImages.getImageForType(this.type);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractToken)) {
            return false;
        }
        AbstractToken c = (AbstractToken)obj;
        if (!c.getRepresentation().equals(this.getRepresentation())) {
            return false;
        }
        if (!c.getParentPackage().equals(this.getParentPackage())) {
            return false;
        }
        return c.getType() == this.getType();
    }

    public int hashCode() {
        return this.getRepresentation().hashCode() * this.getType();
    }

    public int compareTo(Object o) {
        int c;
        int otherT;
        AbstractToken comp = (AbstractToken)o;
        int thisT = this.getType();
        if (thisT != (otherT = comp.getType())) {
            if (thisT == 5 || thisT == 9 || thisT == 10) {
                return -1;
            }
            if (otherT == 5 || otherT == 9 || otherT == 10) {
                return 1;
            }
            if (thisT == 0) {
                return -1;
            }
            if (otherT == 0) {
                return 1;
            }
        }
        if ((c = this.getRepresentation().compareTo(comp.getRepresentation())) != 0) {
            return c;
        }
        c = this.getParentPackage().compareTo(comp.getParentPackage());
        if (c != 0) {
            return c;
        }
        return c;
    }

    public String toString() {
        if (this.getParentPackage() != null && this.getParentPackage().length() > 0) {
            return new FastStringBuffer(this.getRepresentation(), 64).append(" - ").append(this.getParentPackage()).toString();
        }
        return this.getRepresentation();
    }

    private String getOriginalRep(boolean decorateWithModule) {
        if (!decorateWithModule) {
            return this.originalRep;
        }
        String p = this.getParentPackage();
        if (p != null && p.length() > 0) {
            return String.valueOf(p) + "." + this.originalRep;
        }
        return this.originalRep;
    }

    public String getAsRelativeImport(String baseModule) {
        String completePath = this.getOriginalRep(true);
        return AbstractToken.makeRelative(baseModule, completePath);
    }

    public String getAsAbsoluteImport() {
        return this.getAsRelativeImport(".");
    }

    public static String makeRelative(String baseModule, String completePath) {
        if (baseModule == null) {
            return completePath;
        }
        if (completePath.startsWith(baseModule)) {
            String relative = completePath.substring(baseModule.length());
            if ((baseModule = FullRepIterable.headAndTail((String)baseModule)[0]).length() == 0 && relative.length() > 0 && relative.charAt(0) == '.') {
                return relative.substring(1);
            }
            if (relative.length() > 0 && relative.charAt(0) == '.') {
                return String.valueOf(baseModule) + relative;
            }
            return String.valueOf(baseModule) + '.' + relative;
        }
        return completePath;
    }

    public String getOriginalRep() {
        return this.originalRep;
    }

    public String getOriginalWithoutRep() {
        int i = this.originalRep.length() - this.rep.length() - 1;
        if (!this.originalHasRep) {
            return "";
        }
        return i > 0 ? this.originalRep.substring(0, i) : "";
    }

    public int getLineDefinition() {
        return -1;
    }

    public int getColDefinition() {
        return -1;
    }

    public boolean isImport() {
        return false;
    }

    public boolean isImportFrom() {
        return false;
    }

    public boolean isWildImport() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public int[] getLineColEnd() {
        return new int[]{-1, -1};
    }

    public static boolean isClassDef(IToken element) {
        SourceToken token;
        SimpleNode ast;
        return element instanceof SourceToken && (ast = (token = (SourceToken)element).getAst()) instanceof ClassDef;
    }

    public static boolean isFunctionDefProperty(IToken element) {
        SourceToken token;
        SimpleNode ast;
        if (element instanceof SourceToken && (ast = (token = (SourceToken)element).getAst()) instanceof FunctionDef) {
            FunctionDef functionDef = (FunctionDef)ast;
            decoratorsType[] decs = functionDef.decs;
            if (decs != null) {
                int i = 0;
                while (i < decs.length) {
                    decoratorsType dec = decs[i];
                    if (dec != null && dec.func != null && "property".equals(NodeUtils.getRepresentationString((SimpleNode)dec.func))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }
}

