/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.IASTManagerObserver;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.shared_core.callbacks.ICallback0;

public final class ASTManager
extends AbstractASTManager
implements ICodeCompletionASTManager {
    @Override
    public void setProject(IProject project, IPythonNature nature, boolean restoreDeltas) {
        this.getProjectModulesManager().setProject(project, nature, restoreDeltas);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_manager_observer");
        for (IASTManagerObserver observer : participants) {
            try {
                observer.notifyASTManagerAttached(this);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public IModulesManager getModulesManager() {
        return this.getProjectModulesManager();
    }

    private synchronized IProjectModulesManager getProjectModulesManager() {
        if (this.modulesManager == null) {
            this.modulesManager = new ProjectModulesManager();
        }
        return (IProjectModulesManager)this.modulesManager;
    }

    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        this.getProjectModulesManager().changePythonPath(pythonpath, project, monitor);
    }

    @Override
    public void rebuildModule(File f, ICallback0<IDocument> doc, IProject project, IProgressMonitor monitor, IPythonNature nature) {
        this.getProjectModulesManager().rebuildModule(f, doc, project, monitor, nature);
    }

    @Override
    public void removeModule(File file, IProject project, IProgressMonitor monitor) {
        this.getProjectModulesManager().removeModule(file, project, monitor);
    }

    public int getSize() {
        return this.getProjectModulesManager().getSize(true);
    }

    public void saveToFile(File astOutputFile) {
        this.modulesManager.saveToFile(astOutputFile);
    }

    public static ICodeCompletionASTManager loadFromFile(File astOutputFile) throws IOException {
        ASTManager astManager = new ASTManager();
        ProjectModulesManager projectModulesManager = new ProjectModulesManager();
        ProjectModulesManager.loadFromFile(projectModulesManager, astOutputFile);
        astManager.modulesManager = projectModulesManager;
        return astManager;
    }
}

