/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.IToken;
import org.python.pydev.editor.codecompletion.IPyCalltipsContextInformation;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;

public class PyCalltipsContextInformationFromIToken
implements IPyCalltipsContextInformation {
    private final IToken token;
    private String argumentsWithParens;
    private String argumentsWithoutParens;
    private final Image fImage;
    private final int fReplacementOffset;
    private final String defaultArguments;

    public PyCalltipsContextInformationFromIToken(IToken token, String defaultArguments, int replacementOffset) {
        Assert.isNotNull((Object)token);
        this.fImage = null;
        this.fReplacementOffset = replacementOffset;
        this.defaultArguments = defaultArguments;
        this.token = token;
    }

    public boolean equals(Object object) {
        if (object instanceof PyCalltipsContextInformationFromIToken) {
            PyCalltipsContextInformationFromIToken contextInformation = (PyCalltipsContextInformationFromIToken)object;
            contextInformation.calculateArgumentsWithParens();
            this.calculateArgumentsWithParens();
            return this.argumentsWithParens.equalsIgnoreCase(contextInformation.argumentsWithParens);
        }
        return false;
    }

    private void calculateArgumentsWithParens() {
        if (this.argumentsWithParens == null) {
            if (this.token instanceof SourceToken) {
                SourceToken sourceToken = (SourceToken)this.token;
                SimpleNode ast = sourceToken.getAst();
                String fullArgs = NodeUtils.getFullArgs((SimpleNode)ast);
                this.argumentsWithParens = fullArgs.length() == 0 ? null : fullArgs;
            }
            if (this.argumentsWithParens == null) {
                this.argumentsWithParens = this.defaultArguments;
            }
        }
    }

    public int hashCode() {
        this.calculateArgumentsWithParens();
        return this.argumentsWithParens.hashCode();
    }

    public String getInformationDisplayString() {
        if (this.argumentsWithoutParens == null) {
            this.calculateArgumentsWithParens();
            this.argumentsWithoutParens = this.argumentsWithParens.substring(1, this.argumentsWithParens.length() - 1);
        }
        return this.argumentsWithoutParens;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getContextDisplayString() {
        return this.getInformationDisplayString();
    }

    @Override
    public int getShowCalltipsOffset() {
        return this.fReplacementOffset;
    }
}

