/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.PyEditConfigurationWithoutEditor;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PythonCompletionProcessor;
import org.python.pydev.editor.codecompletion.PythonStringCompletionProcessor;
import org.python.pydev.editor.correctionassist.PyCorrectionAssistant;
import org.python.pydev.editor.correctionassist.PythonCorrectionProcessor;
import org.python.pydev.editor.hover.PyAnnotationHover;
import org.python.pydev.editor.hover.PyEditorTextHoverDescriptor;
import org.python.pydev.editor.hover.PyEditorTextHoverProxy;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.editor.simpleassist.SimpleAssistProcessor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyEditConfiguration
extends PyEditConfigurationWithoutEditor {
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;

    private void setEdit(IPySyntaxHighlightingAndCodeCompletionEditor edit) {
        this.edit = edit;
    }

    private IPySyntaxHighlightingAndCodeCompletionEditor getEdit() {
        return this.edit;
    }

    public PyEditConfiguration(ColorAndStyleCache colorManager, IPySyntaxHighlightingAndCodeCompletionEditor edit, IPreferenceStore preferenceStore) {
        super(colorManager, preferenceStore, edit);
        this.setEdit(edit);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new PyAnnotationHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        PyEditorTextHoverDescriptor combiningHover;
        if (PyHoverPreferencesPage.getCombineHoverInfo() && (combiningHover = PydevPlugin.getCombiningHoverDescriptor()).getStateMask() == stateMask) {
            return new PyEditorTextHoverProxy(combiningHover, contentType);
        }
        PyEditorTextHoverDescriptor[] hoverDescs = PydevPlugin.getDefault().getPyEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new PyEditorTextHoverProxy(hoverDescs[i], contentType);
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.python.pydev.editor.PythonEditor", this.edit);
        return targets;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        SimpleAssistProcessor processor = new SimpleAssistProcessor(this.edit, new PythonCompletionProcessor(this.edit, this.pyContentAssistant), this.pyContentAssistant);
        PythonStringCompletionProcessor stringProcessor = new PythonStringCompletionProcessor(this.edit, this.pyContentAssistant);
        this.pyContentAssistant.setRestoreCompletionProposalSize(this.getSettings("pydev_completion_proposal_size"));
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_singleline_string1");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_singleline_string2");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_multiline_string1");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_multiline_string2");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_singleline_unicode1");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_singleline_unicode2");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_multiline_unicode1");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_multiline_unicode");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_singleline_bytes_or_unicode1");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_singleline_bytes_or_unicode2");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_multiline_bytes_or_unicode1");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_multiline_bytes_or_unicode2");
        this.pyContentAssistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__python_comment");
        this.pyContentAssistant.setContentAssistProcessor(processor, "__dftl_partition_content_type");
        this.pyContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.pyContentAssistant.enableAutoActivation(true);
        this.pyContentAssistant.setDocumentPartitioning("__PYTHON_PARTITION_TYPE");
        this.pyContentAssistant.setAutoActivationDelay(PyCodeCompletionPreferencesPage.getAutocompleteDelay());
        return this.pyContentAssistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        PyCorrectionAssistant assistant = new PyCorrectionAssistant();
        PythonCorrectionProcessor processor = new PythonCorrectionProcessor(this.getEdit());
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        PyEditorTextHoverDescriptor[] hoverDescs = PydevPlugin.getDefault().getPyEditorTextHoverDescriptors();
        hoverDescs = (PyEditorTextHoverDescriptor[])ArrayUtils.concatArrays((Object[][])new PyEditorTextHoverDescriptor[][]{hoverDescs, {PydevPlugin.getCombiningHoverDescriptor()}});
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }
}

