/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.lang.ref.WeakReference;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.Token;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.AbstractStringScanner;
import org.python.pydev.editor.PyPresentationReconciler;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyBytesOrUnicodeScanner
extends AbstractStringScanner {
    private WeakReference<PyPresentationReconciler> reconciler;
    private IGrammarVersionProvider grammarVersionProvider;
    private boolean hasFromFutureImportUnicode = false;
    private boolean defaultIsUnicode = false;
    private IDocument fDocument;
    private long last = 0L;

    public PyBytesOrUnicodeScanner(ColorAndStyleCache colorCache, IGrammarVersionProvider grammarVersionProvider, PyPresentationReconciler reconciler) {
        super(colorCache);
        this.setGrammarVersionProvider(grammarVersionProvider);
        this.reconciler = new WeakReference<PyPresentationReconciler>(reconciler);
    }

    @Override
    public void updateColorAndStyle() {
        this.fStringReturnToken = this.defaultIsUnicode ? new Token((Object)this.colorCache.getUnicodeTextAttribute()) : new Token((Object)this.colorCache.getStringTextAttribute());
        this.fDocStringMarkupTextReturnToken = new Token((Object)this.colorCache.getDocstringMarkupTextAttribute());
    }

    private boolean setDefaultIsUnicode(boolean defaultIsUnicode) {
        if (defaultIsUnicode != this.defaultIsUnicode) {
            this.defaultIsUnicode = defaultIsUnicode;
            this.updateColorAndStyle();
            PyPresentationReconciler r = (PyPresentationReconciler)((Object)this.reconciler.get());
            if (r != null) {
                r.invalidateTextPresentation();
            }
            return true;
        }
        return false;
    }

    public void setGrammarVersionProvider(IGrammarVersionProvider grammarVersionProvider) {
        if (grammarVersionProvider != null) {
            this.grammarVersionProvider = grammarVersionProvider;
        }
    }

    private void setFromFutureImportUnicode(boolean hasFromFutureImportUnicode) {
        if (this.hasFromFutureImportUnicode != hasFromFutureImportUnicode) {
            this.hasFromFutureImportUnicode = hasFromFutureImportUnicode;
        }
    }

    private boolean updateDefaultIsBytesOrUnicode() {
        if (this.hasFromFutureImportUnicode) {
            return this.setDefaultIsUnicode(true);
        }
        int grammarVersion = 13;
        IGrammarVersionProvider g = this.grammarVersionProvider;
        if (g != null) {
            try {
                grammarVersion = g.getGrammarVersion();
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        if (grammarVersion >= 99) {
            return this.setDefaultIsUnicode(true);
        }
        return this.setDefaultIsUnicode(false);
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        if (this.fDocument != document) {
            this.fDocument = document;
            this.last = System.currentTimeMillis();
            this.updateFutureUnicodeFromDocument();
        } else {
            long curr = System.currentTimeMillis();
            if (curr - this.last > 1000L) {
                this.last = curr;
                this.updateFutureUnicodeFromDocument();
            }
        }
        super.setRange(document, offset, length);
    }

    private void updateFutureUnicodeFromDocument() {
        if (this.fDocument != null) {
            this.setFromFutureImportUnicode(PySelection.hasFromFutureImportUnicode((IDocument)this.fDocument));
        }
        this.updateDefaultIsBytesOrUnicode();
    }
}

