/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineLibrary;
import org.python.core.PlainConsole;
import org.python.util.ConsoleInputStream;
import org.python.util.ConsoleOutputStream;

public class ReadlineConsole
extends PlainConsole {
    public static final int MAX_PROMPT = 512;
    private ConsoleOutputStream outWrapper;
    private PrintStream originalSystemOut;
    private final Charset latin1;

    public ReadlineConsole(String encoding) {
        super(encoding);
        String backingLib = System.getProperty("python.console.readlinelib", "Editline");
        Readline.load((ReadlineLibrary)ReadlineLibrary.byName((String)backingLib));
        String name = this.encodingCharset.name();
        if (name.equals("ISO-8859-1") || name.equals("US-ASCII")) {
            this.latin1 = null;
            return;
        }
        this.latin1 = Charset.forName("ISO-8859-1");
    }

    @Override
    public void install() {
        Readline.initReadline((String)"jython");
        try {
            Readline.parseAndBind((String)"tab: tab-insert");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.originalSystemOut = System.out;
            this.outWrapper = new ConsoleOutputStream(this.originalSystemOut, 512);
            System.setOut(new PrintStream((OutputStream)this.outWrapper, true, this.encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Stream wrapper = new Stream(this);
        System.setIn(wrapper);
    }

    private CharSequence preEncode(CharSequence prompt) {
        if (prompt == null || prompt.length() == 0) {
            return "";
        }
        if (this.latin1 == null) {
            return prompt;
        }
        CharBuffer cb = CharBuffer.wrap(prompt);
        ByteBuffer bb = this.encodingCharset.encode(cb);
        return this.latin1.decode(bb).toString();
    }

    private CharSequence postDecode(String line) {
        if (line == null) {
            return "";
        }
        if (this.latin1 == null) {
            return line;
        }
        CharBuffer cb = CharBuffer.wrap(line);
        ByteBuffer bb = this.latin1.encode(cb);
        return this.encodingCharset.decode(bb).toString();
    }

    public class Stream
    extends ConsoleInputStream {
        private /* synthetic */ ReadlineConsole this$0;

        Stream(ReadlineConsole readlineConsole) {
            this.this$0 = readlineConsole;
            super(System.in, readlineConsole.encodingCharset, ConsoleInputStream.EOLPolicy.ADD, LINE_SEPARATOR);
        }

        @Override
        protected CharSequence getLine() throws IOException, EOFException {
            this.this$0.originalSystemOut.print('\r');
            CharSequence prompt = this.this$0.outWrapper.getPrompt(this.this$0.encodingCharset).toString();
            prompt = this.this$0.preEncode(prompt);
            String line = Readline.readline((String)prompt.toString());
            return this.this$0.postDecode(line);
        }
    }
}

