/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NFor
extends NNode {
    private NNode target;
    private NNode iter;
    private NBlock body;
    private NBlock orelse;

    public NFor(NNode target, NNode iter, NBlock body, NBlock orelse) {
        this(null, null, null, null, 0, 1);
    }

    public NFor(NNode target, NNode iter, NBlock body, NBlock orelse, int start, int end) {
        super(start, end);
        this.target = target;
        this.iter = iter;
        this.body = body;
        this.orelse = orelse;
        this.addChildren(target, iter, body, orelse);
    }

    @Override
    public final boolean bindsName() {
        return true;
    }

    @Override
    protected final void bindNames(Scope s) throws Exception {
        this.bindNames(s, this.target, NameBinder.make());
    }

    private void bindNames(Scope s, NNode target, NameBinder binder) throws Exception {
        if (target instanceof NName) {
            binder.bind(s, (NName)target, (NType)new NUnknownType());
            return;
        }
        if (target instanceof NSequence) {
            NSequence nSequence = (NSequence)target;
            for (NNode n : nSequence.elts) {
                this.bindNames(s, n, binder);
            }
        }
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NameBinder.make().bindIter(s, this.target, this.iter);
        if (this.body == null) {
            this.setType(new NUnknownType());
        } else {
            this.setType(NFor.resolveExpr(this.body, s));
        }
        if (this.orelse != null) {
            this.addType(NFor.resolveExpr(this.orelse, s));
        }
        return this.getType();
    }

    public final String toString() {
        return "<For:" + this.target + ":" + this.iter + ":" + this.body + ":" + this.orelse + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NFor.visitNode(this.target, v);
            NFor.visitNode(this.iter, v);
            NFor.visitNode(this.body, v);
            NFor.visitNode(this.orelse, v);
        }
    }
}

